// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

/*
39150
37970
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <math.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

int framestep;

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus game;
	char prevframe = 0;
	int saucer_was_there=0;
	int nothing_in_range=0;
	int t = 0;
	time_t tstart,tcurrent;

	for (;;)
	{
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);
		
//printf("\n%4i ",t);
		framestep = frame.frameno - prevframe;
		if (framestep <0) framestep += 0x100;
		++prevframe;
		
		if (framestep != 1 || frame.ping != keys.ping)
		{
			//printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
		}
//fprintf(stderr,"\npre");
		InterpretScreen(frame, game);
//fprintf(stderr,"si,");

		keys.clear();   // alle Tasten loslassen
		int best_priority = -0x7fffffff;
		int best_target=-1;
		int min_dist = 0x7fffffff;
		int targetx = 0;
		int targety = 0;
		double heading_vec_len = sqrt(game.ship_hx*game.ship_hx + game.ship_hy*game.ship_hy);
//fprintf(stderr,"cship,");
		if (game.ship_present)
		{
//fprintf(stderr,"csaucer,");
			//das UFO wird als Asteroid mit erhhter Zielprioritt behandelt
			if (game.saucer_present)
			{
				saucer_was_there=45;
				switch (game.saucer_size)
				{	
				case 15: // groes UFO
					game.asteroids[game.nasteroids].set(game.saucer_x,game.saucer_y, 0, 1);
					game.asteroids[game.nasteroids].target_priority = W_UFO;	
//fprintf(stderr,"1");				
					break;
				case 14: // kleines UFO
					game.asteroids[game.nasteroids].set(game.saucer_x, game.saucer_y, 0, 2);
					game.asteroids[game.nasteroids].target_priority = W_UFO;
//fprintf(stderr,"2");					
					break;
				}
				if (game.saucer_tracked) 
				{
					game.asteroids[game.nasteroids].vx = game.saucer_vx;
					game.asteroids[game.nasteroids].vy = game.saucer_vy;					
					game.asteroids[game.nasteroids].tracked = true;
				}
				game.nasteroids++;
			}
			else
			{
				if (saucer_was_there>0) saucer_was_there-=framestep;
			}

//fprintf(stderr,"loop %i",game.nasteroids );
			// potentielle Angriffsziele bewerten
			for (int i=0; i<game.nasteroids; ++i)
			{   
				game.asteroids[i].crash_priority=0;
//fprintf(stderr,"checking obj %i ",i);			
				// Kriterium 1: Entfernung (relativ zum Schiff)
				int dx = game.asteroids[i].x - game.ship_x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;
				int dy = game.asteroids[i].y - game.ship_y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				
				int size_correction;
				
				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						size_correction = 40*40;
						break;
                                        case 1: // groes UFO
                                        	size_correction = 20*12;
                                        	break;
                                        case 2: // kleines UFO
                                        	size_correction = 10*6;
                                        	break;						
					case 15: // mittlerer Asteroid
						size_correction = 20*20;
						break;
					case 14: // kleiner Asteroid
						size_correction = 8*8;
						break;
				}
				if (dist<size_correction) 
					dist=1;
				else
					dist = (int)sqrt(dist - size_correction);
				
				if (dist < min_dist)
					min_dist = dist;
													
				game.asteroids[i].target_priority -= dist * W_DIST; // je weiter weg desto geringer die Zielprioritaet
				
				// Kriterium 2: Bewegungsvektor (relativ zur Schiffgeschwindigkeit)
				
				int vrelx = game.asteroids[i].vx - game.ship_vx;
				int vrely = game.asteroids[i].vy - game.ship_vy;				
				double vrel = sqrt(vrelx*vrelx + vrely*vrely);
				double cos_alpha = (vrelx * dx + vrely * dy) / (sqrt(vrelx*vrelx + vrely*vrely)*sqrt(dx*dx + dy*dy));
				double alpha = acos(cos_alpha);
				
				// Kriterium 2a: je eher uns das Ziel entgegen kommt, desto hher die Zielprioritt			
				game.asteroids[i].target_priority -= (int)(cos_alpha*W_MOVE); 
				
				// Kriterium 2b: Kommt etwas schnell und direkt auf uns zu?
				if ((sin(alpha)*dist < 10+sqrt(size_correction)) && (dist<300))
				{
					//game.asteroids[i].target_priority+= (int)(vrel*W_CRASH*(100.0+game.nasteroids*game.nasteroids/10)/dist);
					game.asteroids[i].crash_priority+= (int)(vrel*W_CRASH*(100.0+game.nasteroids*game.nasteroids/10)/dist);
					//printf("crash course obj%i dist=%i alpha=%.2f sp=%.1f tp=%i (+%i)\n",i,dist,alpha*180.0/3.142,vrel,game.asteroids[i].target_priority, (int)(vrel*W_CRASH*50.0/dist));
				}
				//dist += (int)(cos_alpha*sqrt(vrelx*vrelx + vrely*vrely));
				
				
				
				// Berechnung des Zielpunkts
				int targetx = dx;
				int targety = dy;				
				int shottraveltime=0;
				
				do
				{
					targetx += vrelx;
					targety += vrely;				
					while (targetx < -512) targetx += 1024;
		    			while (targetx > 511) targetx -= 1024;
    					while (targety < -384) targety += 768;
    					while (targety > 383) targety -= 768;
					
					dist = targetx*targetx+targety*targety;
					if (dist<size_correction) 
					  dist=1;
					else
					  dist = (int)sqrt(dist - size_correction);
					shottraveltime++;
				}
				while (shottraveltime * SHOTSPEED <= dist);
				
				game.asteroids[i].targetx = targetx;
				game.asteroids[i].targety = targety;	
				
				// Kriterium 3: Winkel zwischen Schiffblickrichtung und Ziel
				
				double cos_beta = (game.ship_hx * targetx + game.ship_hy * targety) / 
							(sqrt((double)targetx*targetx+targety*targety)*heading_vec_len);
				
				game.asteroids[i].target_priority += (int)(cos_beta*W_HEAD); //je geringer der Winkelunterschied, umso besser
				
			}
			
			int sum_crash_priority=0;
			for (int i=1; i<game.nasteroids; ++i)
			{
				sum_crash_priority+=game.asteroids[i].crash_priority;
			}	
			for (int i=1; i<game.nasteroids; ++i)
			{
				if (game.asteroids[i].crash_priority>0) game.asteroids[i].target_priority += game.asteroids[i].crash_priority+sum_crash_priority/2;
			}			
			
			best_priority = game.asteroids[0].target_priority;
			best_target=0;
			for (int i=1; i<game.nasteroids; ++i)
			{
				if (game.asteroids[i].target_priority > best_priority)
					{
						best_priority=game.asteroids[i].target_priority;
						best_target=i;
					}
			}
			 

			// Schiff in Richtung auf das nchstgelegene Objekt drehen
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
			// ship_hx/y/0 und min_dx/y/0 berechnet
			if (best_target >=0)			
				if (game.ship_hx * game.asteroids[best_target].targety - game.ship_hy * game.asteroids[best_target].targetx > 0)
					keys.left(true);
				else
					keys.right(true);

			if (min_dist < FLEEING_DISTANCE)  // Flucht, wenn Kollision unausweichlich
				keys.hyperspace(true);
			else if (saucer_was_there>0)
			{  //nach Schssen suchen, welche das Schiff treffen
			  for (int i=0; i<game.nshots; ++i)
			  {
			  	if (!game.shots[i].tracked) continue;
				int shotx=game.shots[i].x;
				int shoty=game.shots[i].y;
				int shipx=game.ship_x;
				int shipy=game.ship_y;
				bool hyperspace=false;
				
				for (int j=0; j<7; ++j)
				{
				   int dx,dy;
				   shotx += game.shots[i].vx;
   				   shoty += game.shots[i].vy;
				   shipx += game.ship_vx;
				   shipy += game.ship_vy;				   
				   dx=shotx-shipx;
				   dy=shoty-shipy;
				   if ((j>1)&&(dx*dx+dy*dy < 20*20))
				   {
				     /*printf("hyp.shot (st:%i,%i %i,%i sh:%i,%i %i,%i) col at step %i dx=%i dy=%i!\n",
				     game.shots[i].x,game.shots[i].y,game.shots[i].vx,game.shots[i].vy,
				     game.ship_x,game.ship_y,game.ship_vx,game.ship_vy,
				     j,dx,dy);*/
				     keys.hyperspace(true);
				     hyperspace=true;
				     break;
				   }
				}
				if (hyperspace) break;
			   }
			}

			if ((min_dist > 400) && (game.nasteroids>0)) // beschleunigen, wenn nichts in der Nhe
			{
				if (nothing_in_range++ > 30)
				{
				  double cos_gamma_v = (game.ship_hx * game.ship_vx + game.ship_hy * game.ship_vy) /
					heading_vec_len;
				  if (cos_gamma_v < 0.0)
					keys.thrust(true);
				}
			}
			else
				nothing_in_range=0;

			if (t % FIRERATE == 0)  // Feuerknopf drcken
				keys.fire(true);
		}
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;
	
//	fprintf(stdout, "score=%i\n",game.score);
	game.score=0;
	
	game.clear();
	if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		int obj = vector_ram[pc] & 0xfff;
		int i;
		
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
		
			// Check for score digits
			if ((vs==1) && (vx==100) && (vy==876)) //that's where the score is
                          for (i=0; i<=9; i++)
                          {
                            if (obj == OBJ_NUMBERS[i])
                            {
                              game.score = game.score*10 + i;
                            }
                          }
		
			switch (obj)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
			        game.saucer_present = true;
				game.saucer_tracked = true;
				if (!game.saucer_present) game.saucer_tracked = false;
				game.saucer_vx = vx - game.saucer_x;
				game.saucer_vy = vy - game.saucer_y;
				game.saucer_vx /= framestep;
				game.saucer_vy /= framestep;
				
				if (game.saucer_vx*game.saucer_vx + game.saucer_vy*game.saucer_vy > 100) game.saucer_tracked = false;
				
				game.saucer_x = vx;
				game.saucer_y = vy;
				
				game.saucer_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy, pc);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_vx = game.ship_x - vx;	    // Bewegungsvektor des Schiffes
					game.ship_vy = game.ship_y - vy;
					game.ship_vx /= framestep;
					game.ship_vy /= framestep;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_hx = v1x - dx;
					game.ship_hy = v1y - dy;
					++shipdetect;
					//fprintf(stdout,"ship: dx:%i dy:%i",v1x - dx,v1y - dy);
					break;
				}
			}
			else if (shipdetect == 1)	//falscher Alarm
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->tracked = true;
	if ((this->type != type)||(this->sf != sf)) tracked=false;

	if (tracked == true)
	{
	  this->oldx = this->x;
	  this->oldy = this->y;	  
	  vx = x - this->oldx;
	  vy = y - this->oldy;
	  
          while (vx < -512) vx += 1024;
          while (vx > 511) vx -= 1024;
          while (vy < -384) vy += 768;
          while (vy > 383) vy -= 768;
	  
	  vx /= framestep;
	  vy /= framestep;
	  //fprintf(stdout,"\ntracked dx=%i dy=%i",this->dx,this->dy);
	}
	if (vx * vx + vy * vy > 100) tracked=false;
	
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
	this->target_priority=0;
}

void Shot::set(int x, int y, int pc)
{
        oldx = this->x;
        oldy = this->y;	  
        vx = x - this->oldx;
        vy = y - this->oldy;
        
        while (vx < -512) vx += 1024;
        while (vx > 511)  vx -= 1024;
        while (vy < -384) vy += 768;
        while (vy > 383)  vy -= 768;        
	  
	vx /= framestep;
	vy /= framestep;	
	  
	if (vx*vx + vy*vy > 100) 
	  tracked=false;	  
	else
	  tracked=true;
	  
	this->x = x;
	this->y = y;
	this->pc = pc;
	//printf("S:%3i %3i (%3x) ",x,y,pc);
	
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}


