package utils;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Tables {
	
	public static final double EE = 0;
	
	public static final double NE = Math.PI * 0.25;
	
	public static final double NN = Math.PI * 0.5;
	
	public static final double NW = Math.PI * 0.75;
	
	public static final double WW = Math.PI;
	
	public static final double SW = -Math.PI * 0.75;
	
	public static final double SS = -Math.PI * 0.5;
	
	public static final double SE = -Math.PI * 0.25;
	
	public static final int[] SAUCER_SPAWN_DELAY = {507, 597, 573, 549, 525, 501, 477, 453, 429, 405, 381, 357, 333, 309, 285, 261, 237, 213, 189, 165};
	
	public static final int[] SPEED_BORDERS = {26, 41, 68, 96, 125, 155, 187, 218};
	
	private Point2D.Double[] shotOffsets = new  Point2D.Double[Utils.MAX_TURN_ANGLES];
	
	private Point2D.Double[] shotBaseDirections = new  Point2D.Double[Utils.MAX_TURN_ANGLES];
	
	private Point[] directions = {
		new Point(1536, 0), new Point(1536, 0),	new Point(1536, 0), 
		new Point(1536, 0), new Point(1528, 152), new Point(1528, 152), 
		new Point(1528, 152), new Point(1528, 152),	new Point(1504, 296), 
		new Point(1504, 296), new Point(1504, 296),	new Point(1504, 296), 
		new Point(1472, 440), new Point(1472, 440),	new Point(1472, 440),
		new Point(1472, 440), new Point(1416, 584),	new Point(1416, 584),
		new Point(1416, 584), new Point(1416, 584),	new Point(1360, 720),
		new Point(1360, 720), new Point(1360, 720),	new Point(1360, 720),
		new Point(1280, 856), new Point(1280, 856),	new Point(1280, 856),
		new Point(1280, 856), new Point(1192, 976),	new Point(1192, 976),
		new Point(1192, 976), new Point(1192, 976),	new Point(1088, 1088), 
		new Point(1088, 1088), new Point(1088, 1088), new Point(1088, 1088),
		new Point(976, 1192), new Point(976, 1192), new Point(976, 1192),
		new Point(976, 1192), new Point(856, 1280), new Point(856, 1280),
		new Point(856, 1280), new Point(856, 1280), new Point(720, 1360),
		new Point(720, 1360), new Point(720, 1360), new Point(720, 1360),
		new Point(584, 1416), new Point(584, 1416), new Point(584, 1416), 
		new Point(584, 1416), new Point(440, 1472), new Point(440, 1472), 
		new Point(440, 1472), new Point(440, 1472), new Point(296, 1504), 
		new Point(296, 1504), new Point(296, 1504), new Point(296, 1504), 
		new Point(152, 1528), new Point(152, 1528), new Point(152, 1528), 
		new Point(152, 1528), new Point(0, 1536), new Point(-152, 1528), 
		new Point(-152, 1528), new Point(-152, 1528), new Point(-152, 1528),
		new Point(-296, 1504), new Point(-296, 1504), new Point(-296, 1504), 
		new Point(-296, 1504),new Point(-440, 1472), new Point(-440, 1472),
		new Point(-440, 1472), new Point(-440, 1472), new Point(-584, 1416),
		new Point(-584, 1416), new Point(-584, 1416), new Point(-584, 1416),
		new Point(-720, 1360), new Point(-720, 1360), new Point(-720, 1360), 
		new Point(-720, 1360), new Point(-856, 1280), new Point(-856, 1280),
		new Point(-856, 1280), new Point(-856, 1280), new Point(-976, 1192), 
		new Point(-976, 1192), new Point(-976, 1192), new Point(-976, 1192),
		new Point(-1088, 1088), new Point(-1088, 1088), new Point(-1088, 1088), 
		new Point(-1088, 1088), new Point(-1192, 976), new Point(-1192, 976),
		new Point(-1192, 976), new Point(-1192, 976), new Point(-1280, 856), 
		new Point(-1280, 856), new Point(-1280, 856), new Point(-1280, 856),
		new Point(-1360, 720), new Point(-1360, 720), new Point(-1360, 720), 
		new Point(-1360, 720), new Point(-1416, 584), new Point(-1416, 584),
		new Point(-1416, 584), new Point(-1416, 584), new Point(-1472, 440),
		new Point(-1472, 440), new Point(-1472, 440), new Point(-1472, 440),
		new Point(-1504, 296), new Point(-1504, 296), new Point(-1504, 296), 
		new Point(-1504, 296), new Point(-1528, 152), new Point(-1528, 152),
		new Point(-1528, 152), new Point(-1528, 152), new Point(-1536, 0),
		new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0),
		new Point(-1536, 0), new Point(-1536, 0), new Point(-1536, 0),
		new Point(-1528, -152), new Point(-1528, -152), new Point(-1528, -152), 
		new Point(-1528, -152),	new Point(-1504, -296), new Point(-1504, -296),
		new Point(-1504, -296), new Point(-1504, -296),	new Point(-1472, -440), 
		new Point(-1472, -440),	new Point(-1472, -440), new Point(-1472, -440),
		new Point(-1416, -584), new Point(-1416, -584), new Point(-1416, -584), 
		new Point(-1416, -584),	new Point(-1360, -720), new Point(-1360, -720),
		new Point(-1360, -720), new Point(-1360, -720),	new Point(-1280, -856), 
		new Point(-1280, -856),	new Point(-1280, -856), new Point(-1280, -856),
		new Point(-1192, -976), new Point(-1192, -976),	new Point(-1192, -976), 
		new Point(-1192, -976),	new Point(-1088, -1088), new Point(-1088, -1088),
		new Point(-1088, -1088), new Point(-1088, -1088), new Point(-976, -1192), 
		new Point(-976, -1192),	new Point(-976, -1192), new Point(-976, -1192),
		new Point(-856, -1280), new Point(-856, -1280),	new Point(-856, -1280),
		new Point(-856, -1280),	new Point(-720, -1360), new Point(-720, -1360),
		new Point(-720, -1360), new Point(-720, -1360),	new Point(-584, -1416),
		new Point(-584, -1416),	new Point(-584, -1416), new Point(-584, -1416),
		new Point(-440, -1472), new Point(-440, -1472),	new Point(-440, -1472),
		new Point(-440, -1472),	new Point(-296, -1504), new Point(-296, -1504),
		new Point(-296, -1504), new Point(-296, -1504),	new Point(-152, -1528),
		new Point(-152, -1528),	new Point(-152, -1528), new Point(-152, -1528),
		new Point(0, -1536), new Point(152, -1528), new Point(152, -1528),
		new Point(152, -1528), new Point(152, -1528), new Point(296, -1504), 
		new Point(296, -1504), new Point(296, -1504), new Point(296, -1504),
		new Point(440, -1472), new Point(440, -1472), new Point(440, -1472),
		new Point(440, -1472), new Point(584, -1416), new Point(584, -1416),
		new Point(584, -1416), new Point(584, -1416), new Point(720, -1360),
		new Point(720, -1360), new Point(720, -1360), new Point(720, -1360),
		new Point(856, -1280), new Point(856, -1280), new Point(856, -1280),
		new Point(856, -1280), new Point(976, -1192), new Point(976, -1192),
		new Point(976, -1192), new Point(976, -1192), new Point(1088, -1088),
		new Point(1088, -1088), new Point(1088, -1088), new Point(1088, -1088),
		new Point(1192, -976), new Point(1192, -976), new Point(1192, -976),
		new Point(1192, -976), new Point(1280, -856), new Point(1280, -856),
		new Point(1280, -856), new Point(1280, -856), new Point(1360, -720), 
		new Point(1360, -720), new Point(1360, -720), new Point(1360, -720),
		new Point(1416, -584), new Point(1416, -584), new Point(1416, -584), 
		new Point(1416, -584), new Point(1472, -440), new Point(1472, -440),
		new Point(1472, -440), new Point(1472, -440), new Point(1504, -296), 
		new Point(1504, -296), new Point(1504, -296), new Point(1504, -296),
		new Point(1528, -152), new Point(1528, -152), new Point(1528, -152),
		new Point(1528, -152), new Point(1536, 0), new Point(1536, 0), 
		new Point(1536, 0)
	};
	
	private double[][] atan2 = new double[Utils.COMBAT_FIELD_HEIGHT + 1][Utils.COMBAT_FIELD_WIDTH + 1];
	
	private double[][] dist = new double[Utils.COMBAT_FIELD_WIDTH + 1][Utils.COMBAT_FIELD_HEIGHT + 1];
	
	private double[] sin = new double[(int)Math.ceil(Math.PI / 3.99 * 64000)];
	
	private double[] astSin = new double[Utils.MAX_TURN_ANGLES];
	
	private double[] astCos = new double[Utils.MAX_TURN_ANGLES];
	
	private double[][] preparationDirections = {
		{NW, NW, NN, NN, NN, NN, NE, NE},
		{NW, NW, NN, NN, NN, NN, NE, NE},
		{WW, WW, NW, NN, NN, NE, EE, EE},
		{WW, WW, WW, NW, NE, EE, EE, EE},
		{WW, WW, WW, SW, SE, EE, EE, EE},
		{WW, WW, SW, SS, SS, SE, EE, EE},
		{SW, SW, SS, SS, SS, SS, SE, SE},
		{SW, SW, SS, SS, SS, SS, SE, SE}
	};
	
	public Tables()
	{	
		// sin / cos functions from heise forum :)
		for(int i = 0; i < Utils.MAX_TURN_ANGLES; i++)
		{
			astSin[i] = Math.round(127.0 * Math.sin(i * Math.PI / 128.0));
			astCos[i] = Math.round(127.0 * Math.cos(i * Math.PI / 128.0));	
		}
		
		// Shot base direction with 0 ship movement
		for(int i = 0; i < Utils.MAX_TURN_ANGLES; i++)
		{
			double x = Math.floor(astCos[i] / 2.0);
			double y = Math.floor(astSin[i] / 2.0);		
			shotBaseDirections[i] = new Point2D.Double(x / 8.0, y / 8.0);
		}
		// Shot base offset relative to ship position
		for(int i = 0; i < Utils.MAX_TURN_ANGLES; i++)
		{
			double x = 2 * Math.floor(astCos[i] / 2.0) + Math.floor(Math.floor(astCos[i] / 2.0 ) / 2.0);
			double y = 2 * Math.floor(astSin[i] / 2.0) + Math.floor(Math.floor(astSin[i] / 2.0 ) / 2.0);			
			shotOffsets[i] = new Point2D.Double(x / 8.0, y / 8.0);
		}
		
		// Large atan2 table for angle calculation
		for(int i = 0; i < Utils.COMBAT_FIELD_HEIGHT + 1; i++)
		{
			for(int j = 0; j < Utils.COMBAT_FIELD_WIDTH + 1; j++)
			{
				atan2[i][j] = Math.atan2(i - Utils.COMBAT_FIELD_CENTER_Y, j - Utils.COMBAT_FIELD_CENTER_X);
			}			
		}
		
		// Large sqrt table for distance calculation
		for(int i = 0; i < Utils.COMBAT_FIELD_WIDTH + 1; i++)
		{
			for(int j = 0; j < Utils.COMBAT_FIELD_HEIGHT + 1; j++)
			{
				int x = (i - Utils.COMBAT_FIELD_CENTER_X) * (i - Utils.COMBAT_FIELD_CENTER_X);
				int y = (j - Utils.COMBAT_FIELD_CENTER_Y) * (j - Utils.COMBAT_FIELD_CENTER_Y);
				dist[i][j] = Math.sqrt(x + y);
			}			
		}
		
		// Large sin table for deviation calculation		
		for(int i = 0; i < sin.length; i++) 
		{
			sin[i] = Math.sin(i / 64000.0);
		}
	}
	
	public double getPreparationDirection(int x, int y)
	{	
		int i = 0;
		int j = 0;
		i = (x * 8) / Utils.COMBAT_FIELD_WIDTH ;
		j = ((Utils.COMBAT_FIELD_HEIGHT + Utils.COMBAT_FIELD_OFFSET_Y - y) * 8) / Utils.COMBAT_FIELD_HEIGHT ;
		return preparationDirections[Math.min(7,j)][Math.min(7,i)];
	}
	
	public Point2D.Double getShotBaseDirection(int index)
	{
		return shotBaseDirections[index];
	}
	
	public Point2D.Double getShotOffset(int index)
	{
		return shotOffsets[index];
	}
	
	public double getShotSpeed(int index)
	{
		return dist[(int)(shotBaseDirections[index].x * 8) + Utils.COMBAT_FIELD_CENTER_X][(int)(shotBaseDirections[index].y * 8) + Utils.COMBAT_FIELD_CENTER_Y] / 8.0;
	}
	
	public double getSpeed(double directionX, double directionY)
	{
		return dist[(int)(directionX * 8) + Utils.COMBAT_FIELD_CENTER_X][(int)(directionY * 8) + Utils.COMBAT_FIELD_CENTER_Y] / 8.0;
	}
	
	public double getAngle(int index)
	{
		return atan2[(int)(shotBaseDirections[index].y * 8) + Utils.COMBAT_FIELD_CENTER_Y][(int)(shotBaseDirections[index].x * 8) + Utils.COMBAT_FIELD_CENTER_X];
	}
	
	public double getAngle(double directionX, double directionY)
	{
		return atan2[(int)(directionY * 8) + Utils.COMBAT_FIELD_CENTER_Y][(int)(directionX * 8) + Utils.COMBAT_FIELD_CENTER_X];
	}
	
	public Point getDirection(int index)
	{
		return directions[index];
	}
	
	public double dist(int x, int y)
	{
		return dist[x + Utils.COMBAT_FIELD_CENTER_X][y + Utils.COMBAT_FIELD_CENTER_Y];
	}
	
	public double atan2(int y, int x)
	{
		return atan2[y + Utils.COMBAT_FIELD_CENTER_Y][x + Utils.COMBAT_FIELD_CENTER_X];
	}	
	
	public double sin(double a)
	{
		return sin[(int)Math.round(a * 64000)];
	}
	
	public double astSin(int index)
	{
		return astSin[index];
	}
	
	public double astCos(int index)
	{
		return astCos[index];
	}
}
