package objects;

import helpers.CombatHeuristics;


public class Asteroid extends TargetObject {
	
	public static final int LARGE_SIZE = 64;
	
	public static final int MEDIUM_SIZE = 32;
	
	public static final int SMALL_SIZE = 16;

	protected int type;
	
	protected PreAsteroid child;
	
	public Asteroid(int x, int y, int type, int scale) {
		super(x, y);
		this.type = type;
		this.scale = scale;
		child = null;
		switch(scale)
		{
		case LARGE_SCALE:
			width = LARGE_SIZE;
			height = LARGE_SIZE;
			break;
		case MEDIUM_SCALE:
			width = MEDIUM_SIZE;
			height = MEDIUM_SIZE;
			break;
		case SMALL_SCALE:
			width = SMALL_SIZE;
			height = SMALL_SIZE;
			break;
		}
	}
	
	public boolean hasChild()
	{
		return child != null;
	}
	
	public PreAsteroid getChild()
	{
		return child;
	}
	
	public void createChild(double distance, int timeToHit)
	{
		if(child == null)
		{
			child = new PreAsteroid(posX, posY, -1, 14, timeToHit + CombatHeuristics.getPrecisionDelay(distance, null));
		}
	}
	
	public void update(int newX, int newY, int frameDif) {
		super.update(newX, newY, frameDif);
		if(child != null)
		{	
			if(numTargeted > 0)
			{
				child.update(newX, newY, frameDif);	
			} else {
				child.destroy();
				child = null;
			}
		}
	}
	
	public void destroy()
	{
		super.destroy();
		if(child != null)
		{
			child.destroy();
			child = null;
		}
	}
	
	public String toString()
	{
		String result = "Asteroid #%d {%d, %d / %.3f, %.3f / %d, %d}";
		return String.format(result, id, posX, posY, moveX, moveY, type, scale);		
	}
	
	public boolean matches(int otherX, int otherY, int otherType, int otherScale, int frameDif) {
		if(type == otherType && scale == otherScale)
		{
			return super.matches(otherX, otherY, frameDif);
		}
		return false; 
	}
	
	public int getMaximumSpeed()
	{
		switch(scale)
		{
		case 0:
			return 2;
		case 15:
			return 4;
		case 14:
			return 4;
		}
		return 4;
	}
}
