package gui;

import java.awt.Dimension;
import java.awt.event.ActionListener;

import javax.swing.JPanel;

public class MainPanel extends JPanel {
	
	private static final long serialVersionUID = 1L;

	public StatusPanel statusPanel;
	
	public ControlPanel controlPanel;
	
	public CombatEventPanel combatPanel;
	
	public StatisticsPanel statisticsPanel; 
	
	public MainPanel(ActionListener listener)
	{
		super();
		statusPanel = new StatusPanel();		
		controlPanel = new ControlPanel(listener);		
		combatPanel = new CombatEventPanel();
		statisticsPanel = new StatisticsPanel();
		add(statusPanel);
		add(controlPanel);
		add(combatPanel);
		add(statisticsPanel);		
		Dimension d1 = statusPanel.getPreferredSize();
		Dimension d2 = controlPanel.getPreferredSize();
		Dimension d3 = combatPanel.getPreferredSize();
		Dimension d4 = statisticsPanel.getPreferredSize();
		int w1 = Math.max(d1.width, d3.width);
		int w2 = Math.max(d2.width, d4.width);
		int h1 = Math.max(d1.height, d2.height);
		int h2 = Math.max(d3.height, d4.height);
		statusPanel.setPreferredSize(new Dimension(w1, h1));
		controlPanel.setPreferredSize(new Dimension(w2, h1));
		combatPanel.setPreferredSize(new Dimension(w1, h2));
		statisticsPanel.setPreferredSize(new Dimension(w2, h2));	
		setPreferredSize(new Dimension(w1+ w2 + 15, h1 + h2 + 15));
	}
}
