package gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ControlPanel extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	private JButton serverButton;
	
	private JButton startButton;	
	
	private JCheckBox autoStartBox;
	
	private JCheckBox autoStopBox;

	public ControlPanel(ActionListener listener)
	{
		super();
		setBorder(new TitledBorder(new EtchedBorder() , "Control"));
		setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		serverButton = createControlButton("Select Server", listener);
		add(Box.createRigidArea(new Dimension(0, 5)));
		startButton = createControlButton("Activate Bot", listener);		
		autoStartBox = createCheckBox("Activate and start automaticly", true, listener);
		autoStopBox = createCheckBox("Automatic deactivation after 5 min", true, listener);
	}
	
	public boolean isServerButtonClicked(ActionEvent e) {
		return e.getSource() == serverButton;
	}
	
	public boolean isStartButtonClicked(ActionEvent e) {
		return e.getSource() == startButton;
	}
	
	public boolean isAutoStartBoxToggled(ActionEvent e) {
		return e.getSource() == autoStartBox;
	}
		
	public boolean isAutoStopBoxToggled(ActionEvent e) {
		return e.getSource() == autoStopBox;
	}
	
	public void updateButtons(boolean started)
	{
		if(started) {
			startButton.setText("Deactivate Bot");			
		} else {
			startButton.setText("Activate Bot");
		}
	}
	
	public void updateAutoStart(boolean autoStart)
	{
		autoStartBox.setSelected(autoStart);
	}
	
	public void updateAutoStop(boolean autoStop)
	{
		autoStopBox.setSelected(autoStop);
	}
	
	public JCheckBox createCheckBox(String text, boolean checked, ActionListener listener)
	{
		JCheckBox result = new JCheckBox(text, checked);
		result.addActionListener(listener);
		result.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(result);
		return result;
	}
	
	public JButton createControlButton(String text, ActionListener listener)
	{
		JButton result = new JButton(text);
		result.addActionListener(listener);
		result.setAlignmentX(Component.LEFT_ALIGNMENT);
		result.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
		add(result);
		return result;
	}
}
