package gui;

import helpers.CombatMessages;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class CombatEventPanel extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	public static final int EVENT_LOG_SIZE = 8;
	
	private ImageIcon[] combatEventImages = new ImageIcon[EVENT_LOG_SIZE];
	
	private String[] combatEventTexts = new String[EVENT_LOG_SIZE];
	
	int index = 0;
	
	private DefaultTableModel combatEventModel = new DefaultTableModel()
	{
		
		private static final long serialVersionUID = 1L;
		
		public Class<?> getColumnClass(int columnIndex) {
			switch(columnIndex)
			{
			case 0: return ImageIcon.class;
			case 1: return String.class;
			}
			return null;
		}

		public int getColumnCount() {
			return 2;
		}

		public String getColumnName(int columnIndex) {
			return null;
		}

		public int getRowCount() {
			return EVENT_LOG_SIZE;
		}

		public Object getValueAt(int rowIndex, int columnIndex) {
			int indexResult = index;
			for(int i = 0; i < rowIndex; i++)
			{
				--indexResult;
				if(indexResult < 0)
				{
					indexResult = EVENT_LOG_SIZE - 1;
				}
			}
			switch(columnIndex)
			{
			case 0: return combatEventImages[indexResult];
			case 1: return combatEventTexts[indexResult];
			}
			return null;
		}

		public boolean isCellEditable(int rowIndex, int columnIndex) {
			return false;
		}

		public void setValueAt(Object aValue, int rowIndex, int columnIndex) { 		
		}
	};
	
	private TableCellRenderer imageRenderer = new TableCellRenderer()
	{
		private JLabel imageRenderLabel = new JLabel();
		
		private JLabel textRenderLabel = new JLabel();

		public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
			if(value instanceof Image)
			{
				imageRenderLabel.setIcon((ImageIcon)value);
				return imageRenderLabel;
			} else if(value instanceof String) {
				if(row == 0)
				{
					textRenderLabel.setBackground(Color.BLUE);
					textRenderLabel.setForeground(Color.YELLOW);
				} else {
					textRenderLabel.setBackground(Color.WHITE);
					textRenderLabel.setForeground(Color.BLACK);					
				}				
				textRenderLabel.setText(value.toString());
				textRenderLabel.setOpaque(true);
				textRenderLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
				return textRenderLabel;
			}
			return null;
		}
		
	};

	public CombatEventPanel()
	{
		super();
		setBorder(new TitledBorder(new EtchedBorder() , "Combat Events"));
		setLayout(new BorderLayout());
		createCombatEventList(combatEventModel);
	}
	
	public void resetCombatEventList()
	{
		for(int i = 0; i < EVENT_LOG_SIZE; i++)
		{
			combatEventImages[i] = null;
			combatEventTexts[i] =  null;
		}
		index = 0;
	}
	
	public void updateCombatEventList(int time, int message)
	{	
		++index;
		if(index >= EVENT_LOG_SIZE)
		{
			index = 0;
		}
		combatEventImages[index] = CombatMessages.IMAGES[message];
		combatEventTexts[index] =  Integer.toString(time)+ " : "+CombatMessages.MESSAGES[message];
		combatEventModel.fireTableDataChanged();	
	}
	
	public JTable createCombatEventList(TableModel model)
	{
		JTable result = new JTable(model);
		result.setEnabled(false);
		result.setRowHeight(32);
		result.getColumnModel().getColumn(0).setMaxWidth(32);
		result.getColumnModel().getColumn(1).setMinWidth(250);
		result.setDefaultRenderer(Object.class, imageRenderer);
		result.setBorder(new EmptyBorder(5, 5, 5, 5));
		result.setAlignmentX(Component.LEFT_ALIGNMENT);
		add(result, BorderLayout.CENTER);
		return result;
	}
}
