/*
 * Decompiled with CFR 0.152.
 */
package structures;

import objects.CombatObject;
import objects.Ship;
import utils.Utils;

public class TargetInformation {
    public double distance = 0.0;
    public double angle = 0.0;
    public double angleDif = 0.0;
    public int difX = 0;
    public int difY = 0;

    public void setInfo(Ship ship, CombatObject object) {
        this.difX = Utils.getXDif(ship.getPosX(), object.getPosX());
        this.difY = Utils.getYDif(ship.getPosY(), object.getPosY());
        this.distance = Utils.TABLES.dist(this.difX, this.difY);
        this.angle = Utils.TABLES.atan2(this.difY, this.difX);
        this.angleDif = Utils.getAngleDif(ship.getMovementAngle(), this.angle);
    }

    public void setInfo(TargetInformation other) {
        this.distance = other.distance;
        this.angle = other.angle;
        this.angleDif = other.angleDif;
        this.difX = other.difX;
        this.difY = other.difY;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TargetInformation[difX=");
        buf.append(this.difX);
        buf.append(", difY=");
        buf.append(this.difY);
        buf.append(", dist=");
        buf.append(this.distance);
        buf.append(", angle=");
        buf.append(this.angle);
        buf.append(", angleDif=");
        buf.append(this.angleDif);
        buf.append("]");
        return buf.toString();
    }
}

