/*
 * Decompiled with CFR 0.152.
 */
package objects;

import helpers.CombatStatistics;
import objects.CombatObject;
import objects.Ship;
import objects.Shootable;
import objects.TargetObject;

public class Shot
extends CombatObject
implements Shootable {
    protected CombatObject owner;
    protected TargetObject target;
    protected int timeToLive;
    protected int timeToHit;
    protected boolean hasMissed = false;

    public Shot(int x, int y, CombatObject owner, TargetObject target, int frame) {
        super(x, y);
        this.owner = owner;
        this.scale = -1;
        this.width = 2;
        this.height = 2;
        this.timeToLive = 68;
        this.timeToHit = 68;
        if (target != null) {
            this.target = target;
            target.onFiredUpon(this);
        }
        if (owner instanceof Ship) {
            ((Ship)owner).onTorpedoFired(this);
        }
    }

    @Override
    public void update(int newX, int newY, int frameDif) {
        super.update(newX, newY, frameDif);
        this.timeToLive -= frameDif;
        this.timeToHit -= frameDif;
        if (this.timeToHit == -2 && !this.hasMissed && this.target != null) {
            this.hasMissed = true;
            this.target.onMissed(this);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.target != null && !this.hasMissed) {
            this.hasMissed = true;
            this.target.onMissed(this);
        }
        if (this.owner instanceof Ship && this.timeToLive < 1) {
            ++CombatStatistics.SHOTS_MISSED;
        }
        this.timeToLive = 0;
        this.timeToHit = 0;
    }

    @Override
    public void setTimeToDestination(int hitTime) {
        this.timeToHit = hitTime;
    }

    @Override
    public int getTimeToDestination() {
        if (this.timeToHit < -1) {
            return Math.max(0, this.timeToLive);
        }
        return Math.max(0, this.timeToHit);
    }

    public void reAssignTarget(TargetObject newTarget, int hitTime) {
        if (this.target != null) {
            this.target.onMissed(this);
        }
        this.target = newTarget;
        this.timeToHit = hitTime;
        if (this.target != null) {
            this.target.onTargeted();
            this.target.onFiredUpon(this);
        }
    }

    public TargetObject getTarget() {
        return this.target;
    }

    public CombatObject getOwner() {
        return this.owner;
    }

    @Override
    public String toString() {
        String result = "Shot #%d {%d, %d / %.3f, %.3f / %s, %s / %d}";
        if (this.owner instanceof Ship) {
            return String.format(result, this.id, this.posX, this.posY, this.moveX, this.moveY, "Ship", this.target, this.movePrecision);
        }
        return String.format(result, this.id, this.posX, this.posY, this.moveX, this.moveY, "Saucer", this.target, this.movePrecision);
    }

    @Override
    public int getMaximumSpeed() {
        return 10;
    }
}

