/*
 * Decompiled with CFR 0.152.
 */
package objects;

import helpers.CombatStatistics;
import java.awt.Point;
import objects.CombatObject;
import objects.PreShot;
import objects.Shootable;
import objects.Shot;
import utils.Utils;

public class Ship
extends CombatObject {
    protected int dirX;
    protected int dirY;
    protected int angle;
    protected double vX = 0.0;
    protected double vY = 0.0;
    protected double posXv;
    protected double posYv;
    private Shootable[] torpedos = new Shootable[4];
    private int lastTriggeredTorpedo = -1;
    private int lastTriggeredTorpedoTime = -1;
    private long awayCount;

    public Ship(int x, int y, int dirX, int dirY) {
        super(x, y);
        this.posXv = x;
        this.posYv = y;
        this.dirX = dirY;
        this.dirY = dirY;
        this.angle = 0;
        this.isAlive = false;
        this.width = 26;
        this.height = 22;
        this.prepareTorpedos();
        this.awayCount = 0L;
    }

    public boolean isLost() {
        return this.awayCount > 47L;
    }

    public boolean isMoving() {
        return Math.abs(this.moveX) >= 0.125 || Math.abs(this.moveY) >= 0.125;
    }

    @Override
    public void spawn(int x, int y) {
        super.spawn(x, y);
        this.posXv = x;
        this.posYv = y;
        this.vX = 0.0;
        this.vY = 0.0;
        if (this.isLost()) {
            this.prepareTorpedos();
        }
        this.awayCount = 0L;
    }

    public void onTorpedoTriggered(int hitTime) {
        int i = 0;
        while (i < 4) {
            if (!this.torpedos[i].isAlive()) {
                this.torpedos[i] = new PreShot(hitTime);
                this.lastTriggeredTorpedo = i;
                this.lastTriggeredTorpedoTime = CombatStatistics.TIME;
                return;
            }
            ++i;
        }
    }

    public void onTorpedoFired(Shot torpedo) {
        if (this.lastTriggeredTorpedo > -1) {
            torpedo.setTimeToDestination(this.torpedos[this.lastTriggeredTorpedo].getTimeToDestination() - 2);
            this.torpedos[this.lastTriggeredTorpedo] = torpedo;
            this.lastTriggeredTorpedo = -1;
        }
    }

    public boolean isTorpedoReady() {
        int i = 0;
        while (i < 4) {
            if (!this.torpedos[i].isAlive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getAvailableTorpedos() {
        int result = 0;
        int i = 0;
        while (i < 4) {
            if (!this.torpedos[i].isAlive()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public Shootable getFastestTorpedo() {
        Shootable result = null;
        int fastest = Integer.MAX_VALUE;
        int i = 0;
        while (i < 4) {
            int ttd = this.torpedos[i].getTimeToDestination();
            if (this.torpedos[i].isAlive() && ttd < fastest) {
                fastest = ttd;
                result = this.torpedos[i];
            }
            ++i;
        }
        return result;
    }

    public int getTimeToNextTorpedo() {
        int result = Integer.MAX_VALUE;
        int i = 0;
        while (i < 4) {
            int ttd = this.torpedos[i].getTimeToDestination();
            if (ttd < result) {
                result = ttd;
            }
            ++i;
        }
        return result;
    }

    public void prepareTorpedos() {
        int i = 0;
        while (i < 4) {
            this.torpedos[i] = new PreShot(0, false);
            ++i;
        }
    }

    @Override
    public String toString() {
        String result = "Ship #%d {%d, %d / %.3f, %.3f / %d}";
        return String.format(result, this.id, this.posX, this.posY, this.moveX, this.moveY, this.angle);
    }

    public int getAngleIndex() {
        return this.angle;
    }

    @Override
    public double getMovementAngle() {
        return Utils.TABLES.getAngle(this.angle);
    }

    public void updateAway(int frameDif) {
        this.awayCount += (long)frameDif;
    }

    @Override
    public void update(int newX, int newY, int frameDif) {
        this.posX = newX;
        this.posY = newY;
        if (this.lastTriggeredTorpedo > -1 && CombatStatistics.TIME - this.lastTriggeredTorpedoTime > 2) {
            this.torpedos[this.lastTriggeredTorpedo].destroy();
            this.lastTriggeredTorpedo = -1;
        }
    }

    @Override
    public int getRadius() {
        return Math.max(this.width, this.height) / 2;
    }

    public double getSpeedX() {
        return this.vX;
    }

    public double getSpeedY() {
        return this.vY;
    }

    public void updateMovement() {
        this.moveX = Math.floor(this.vX) / 8.0;
        this.moveY = Math.floor(this.vY) / 8.0;
        this.posXv += this.moveX;
        this.posYv += this.moveY;
    }

    public void performAcceleration() {
        if (Math.abs(this.vX) < 64.0) {
            this.vX += Utils.TABLES.astCos(this.angle) / 128.0;
        }
        if (Math.abs(this.vY) < 64.0) {
            this.vY += Utils.TABLES.astSin(this.angle) / 128.0;
        }
        this.updateMovement();
    }

    public void performDeceleration() {
        if (this.vX > 0.0) {
            this.vX = Math.max(0.0, this.vX - Math.floor(this.vX) / 128.0 - 0.00390625);
        } else if (this.vX < 0.0) {
            this.vX = Math.min(0.0, this.vX - Math.floor(this.vX) / 128.0);
        }
        if (this.vY > 0.0) {
            this.vY = Math.max(0.0, this.vY - Math.floor(this.vY) / 128.0 - 0.00390625);
        } else if (this.vY < 0.0) {
            this.vY = Math.min(0.0, this.vY - Math.floor(this.vY) / 128.0);
        }
        this.updateMovement();
    }

    public void performTurnLeft() {
        this.angle = Utils.incByteAngle(this.angle);
        Point directionCheck = Utils.TABLES.getDirection(this.angle);
        if (directionCheck.x != this.dirX) {
            while (directionCheck.x != this.dirX || directionCheck.y != this.dirY) {
                this.angle = Utils.incByteAngle(this.angle);
                directionCheck = Utils.TABLES.getDirection(this.angle);
            }
        }
    }

    public void performTurnRight() {
        this.angle = Utils.decByteAngle(this.angle);
        Point directionCheck = Utils.TABLES.getDirection(this.angle);
        if (directionCheck.x != this.dirX) {
            while (directionCheck.x != this.dirX || directionCheck.y != this.dirY) {
                this.angle = Utils.decByteAngle(this.angle);
                directionCheck = Utils.TABLES.getDirection(this.angle);
            }
        }
    }

    public void setDirection(int directionX, int directionY) {
        this.dirX = directionX;
        this.dirY = directionY;
    }

    public int getDirectionX() {
        return this.dirX;
    }

    public int getDirectionY() {
        return this.dirY;
    }

    @Override
    public int getMaximumSpeed() {
        return 8;
    }
}

