/*
 * Decompiled with CFR 0.152.
 */
package objects;

import java.awt.Rectangle;
import utils.Utils;

public abstract class CombatObject {
    public static final int NO_SCALE = -1;
    public static final int LARGE_SCALE = 0;
    public static final int MEDIUM_SCALE = 15;
    public static final int SMALL_SCALE = 14;
    protected static int RUNNING_ID = 0;
    protected int posX;
    protected int posY;
    protected double moveX;
    protected double moveY;
    protected int id;
    protected int width;
    protected int height;
    protected int scale;
    protected int movePrecision;
    protected boolean isMovementPrecise;
    protected boolean isAlive;
    protected int pos0X;
    protected int pos0Y;

    public CombatObject(int x, int y) {
        this.pos0X = x;
        this.pos0Y = y;
        this.posX = x;
        this.posY = y;
        this.moveX = 0.0;
        this.moveY = 0.0;
        this.id = RUNNING_ID++;
        this.movePrecision = 0;
        this.isMovementPrecise = false;
        this.width = 0;
        this.height = 0;
        this.scale = 0;
        this.isAlive = true;
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        String result = "Combat Object #%d {%d, %d / %.3f, %.3f}";
        return String.format(result, this.id, this.posX, this.posY, this.moveX, this.moveY);
    }

    public boolean isMovementPrecise() {
        return this.isMovementPrecise;
    }

    public int getMovementPrecision() {
        if (this.isMovementPrecise) {
            return 8;
        }
        return this.movePrecision;
    }

    public boolean matches(int otherX, int otherY, int frameDif) {
        int maxDist;
        int distY;
        int distX;
        if (this.isMovementPrecise || this.movePrecision > 0) {
            distX = (int)Utils.getXDist(otherX, (double)this.pos0X + this.moveX * (double)(this.movePrecision + frameDif));
            distY = (int)Utils.getYDist(otherY, (double)this.pos0Y + this.moveY * (double)(this.movePrecision + frameDif));
            maxDist = this.isMovementPrecise ? 0 : (int)Math.ceil((double)this.getMaximumSpeed() / (double)(this.getMovementPrecision() + 1));
        } else {
            distX = (int)Utils.getXDist(otherX, this.posX);
            distY = (int)Utils.getYDist(otherY, this.posY);
            maxDist = this.getMaximumSpeed() * frameDif;
        }
        return distX <= maxDist && distY <= maxDist;
    }

    public void update(int newX, int newY, int frameDif) {
        this.movePrecision += frameDif;
        if (this.movePrecision % 8 == 0) {
            this.movePrecision = 0;
        }
        if (!this.isMovementPrecise) {
            if (this.movePrecision == 0) {
                this.moveX = (double)Utils.getXDif(this.pos0X, newX) / 8.0;
                this.moveY = (double)Utils.getYDif(this.pos0Y, newY) / 8.0;
                this.isMovementPrecise = true;
            } else {
                this.moveX = (double)Utils.getXDif(this.pos0X, newX) / (double)this.movePrecision;
                this.moveY = (double)Utils.getYDif(this.pos0Y, newY) / (double)this.movePrecision;
            }
        }
        if (this.movePrecision == 0) {
            this.pos0X = newX;
            this.pos0Y = newY;
        }
        this.posX = newX;
        this.posY = newY;
    }

    public int getRadius() {
        return (this.width + this.height) / 4;
    }

    public double getSpeed() {
        return Utils.TABLES.getSpeed(this.moveX, this.moveY);
    }

    public double getMovementAngle() {
        return Utils.TABLES.getAngle(this.moveX, this.moveY);
    }

    public double getMovementX() {
        return this.moveX;
    }

    public double getMovementY() {
        return this.moveY;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getID() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.posX - this.width / 2, this.posY - this.height / 2, this.width, this.height);
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void spawn(int x, int y) {
        this.pos0X = x;
        this.pos0Y = y;
        this.posX = x;
        this.posY = y;
        this.moveX = 0.0;
        this.moveY = 0.0;
        this.movePrecision = 0;
        this.isMovementPrecise = false;
        this.isAlive = true;
    }

    public void destroy() {
        this.isAlive = false;
    }

    public abstract int getMaximumSpeed();
}

