/*
 * Decompiled with CFR 0.152.
 */
package io;

import helpers.CombatHeuristics;
import helpers.CombatMessages;
import helpers.CombatStatistics;
import io.CombatControl;
import java.util.LinkedList;
import java.util.ListIterator;
import objects.Asteroid;
import objects.Saucer;
import objects.Ship;
import objects.Shot;
import objects.TargetObject;
import utils.Utils;

public class CombatState {
    public static final int MAX_ASTEROIDS = 26;
    public static final int MAX_SHOTS = 6;
    private Ship ship;
    private Saucer saucer;
    private TargetObject nextTarget;
    private LinkedList<Asteroid> asteroids = new LinkedList();
    private LinkedList<Shot> shots = new LinkedList();
    private LinkedList<Shot> pendingShots = new LinkedList();
    private int packetCount;
    private int packetDif;
    private int ships;
    private boolean isIngame;
    private boolean isValid;
    private boolean isMovementPhase;
    private boolean areAsteroidsVisible;

    public CombatState() {
        this.ship = new Ship(0, 0, 0, 0);
        this.reset();
    }

    private Shot createShot(int x, int y) {
        double shipDist = Double.MAX_VALUE;
        double saucerDist = Double.MAX_VALUE;
        if (this.isShipAlive()) {
            shipDist = Utils.getDistSquare(x, y, this.ship.getPosX(), this.ship.getPosY());
        }
        if (this.isSaucerAlive()) {
            saucerDist = Utils.getDistSquare(x, y, this.saucer.getPosX(), this.saucer.getPosY());
        }
        Shot newShot = null;
        if (shipDist < saucerDist) {
            newShot = new Shot(x, y, this.ship, this.nextTarget, this.packetCount);
            ++CombatStatistics.SHOTS_FIRED;
            this.nextTarget = null;
        } else {
            newShot = new Shot(x, y, this.saucer, null, this.packetCount);
        }
        return newShot;
    }

    private int createWord(byte lo, byte hi) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    public void fireFlag(TargetObject target, int hitTime) {
        this.nextTarget = target;
        this.ship.onTorpedoTriggered(hitTime);
        this.nextTarget.onTargeted();
    }

    public LinkedList<Asteroid> getAsteroids() {
        return this.asteroids;
    }

    public int getAsteroidNumber() {
        return this.asteroids.size();
    }

    public boolean areTargetsLeft() {
        for (Asteroid curAsteroid : this.asteroids) {
            if (curAsteroid.getTargetedStatus() != 0) continue;
            return true;
        }
        return false;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int getPacketDif() {
        return this.packetDif;
    }

    public Saucer getSaucer() {
        return this.saucer;
    }

    public Ship getShip() {
        return this.ship;
    }

    public int getShipsLeft() {
        return this.ships;
    }

    public LinkedList<Shot> getShots() {
        return this.shots;
    }

    public boolean isSaucerAlive() {
        return this.saucer != null;
    }

    public boolean isShipAlive() {
        return this.ship.isAlive();
    }

    public boolean isIngame() {
        return this.isIngame;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isMovementPhase() {
        return this.isMovementPhase;
    }

    public boolean isSectorEmpty() {
        return this.asteroids.isEmpty() && this.saucer == null;
    }

    private void matchAsteroid(ListIterator<Asteroid> curAsteroid, int x, int y, int type, int scale) {
        if (curAsteroid.hasNext()) {
            Asteroid required = curAsteroid.next();
            if (required.matches(x, y, type, scale, this.packetDif)) {
                required.update(x, y, this.packetDif);
                return;
            }
            int delCount = 0;
            while (curAsteroid.hasNext() && delCount < 4) {
                Asteroid sufficient = curAsteroid.next();
                if (sufficient.matches(x, y, type, scale, this.packetDif)) {
                    sufficient.update(x, y, this.packetDif);
                    Asteroid delAsteroid = curAsteroid.previous();
                    while (delAsteroid != required) {
                        delAsteroid = curAsteroid.previous();
                        delAsteroid.destroy();
                        this.freeShots(delAsteroid);
                        curAsteroid.remove();
                    }
                    curAsteroid.next();
                    return;
                }
                ++delCount;
            }
            while (curAsteroid.previous() != required) {
            }
            Asteroid newAsteroid = new Asteroid(x, y, type, scale);
            curAsteroid.add(newAsteroid);
        } else {
            Asteroid newAsteroid = new Asteroid(x, y, type, scale);
            curAsteroid.add(newAsteroid);
        }
    }

    private void matchPacketCount(int id) {
        if (this.isValid) {
            if (this.packetCount > id) {
                this.packetCount -= 256;
            }
            this.packetDif = id - this.packetCount;
            if (this.packetDif > 1) {
                CombatStatistics.PACKET_LOSS += this.packetDif - 1;
            }
        }
        this.packetCount = id;
        this.isValid = true;
    }

    private void matchSaucer(int x, int y, int scale) {
        if (!this.isSaucerAlive()) {
            CombatMessages.verbose(2);
            this.saucer = new Saucer(x, y, scale);
        } else if (this.saucer.matches(x, y, this.packetDif)) {
            this.saucer.update(x, y, this.packetDif);
        } else {
            this.saucer.reMatch(x, y, this.packetDif);
        }
    }

    private void matchShip(int x, int y, int dirX, int dirY) {
        if (!this.isShipAlive()) {
            this.ship.spawn(x, y);
        } else {
            this.ship.update(x, y, this.packetDif);
        }
        this.ship.setDirection(dirX, dirY);
    }

    /*
     * Unable to fully structure code
     */
    private void matchShot(ListIterator<Shot> curShot, int x, int y) {
        block4: {
            block3: {
                if (!curShot.hasNext()) break block3;
                required = curShot.next();
                if (!required.matches(x, y, this.packetDif)) ** GOTO lbl18
                required.update(x, y, this.packetDif);
                return;
lbl-1000:
                // 1 sources

                {
                    sufficient = curShot.next();
                    if (!sufficient.matches(x, y, this.packetDif)) continue;
                    sufficient.update(x, y, this.packetDif);
                    delShot = curShot.previous();
                    while (delShot != required) {
                        delShot = curShot.previous();
                        delShot.destroy();
                        curShot.remove();
                    }
                    curShot.next();
                    return;
lbl18:
                    // 2 sources

                    ** while (curShot.hasNext())
                }
lbl19:
                // 2 sources

                while (curShot.previous() != required) {
                }
                curShot.add(this.createShot(x, y));
                break block4;
            }
            curShot.add(this.createShot(x, y));
        }
    }

    private void freeShots(TargetObject target) {
        this.pendingShots.addAll(target.getShotsFiredUpon());
    }

    public boolean isLastTargetLeft() {
        int numTargets = 0;
        for (Asteroid curAsteroid : this.asteroids) {
            if (curAsteroid.getTargetedStatus() == 0 && ++numTargets > 1) break;
        }
        return numTargets == 1;
    }

    private void reAssignShots() {
        for (Shot curShot : this.pendingShots) {
            if (!curShot.isAlive()) continue;
            curShot.setTimeToDestination(-1);
            for (Asteroid curAsteroid : this.asteroids) {
                double angleToTarget;
                double angleDif;
                double time;
                double moveAngle = curShot.getMovementAngle();
                int xDif = Utils.getXDif(curShot.getPosX(), curAsteroid.getPosX());
                int yDif = Utils.getYDif(curShot.getPosY(), curAsteroid.getPosY());
                double dist = Utils.TABLES.dist(xDif, yDif);
                switch (curAsteroid.getScale()) {
                    case 0: {
                        time = dist / curShot.getSpeed() - 3.0;
                        break;
                    }
                    case 15: {
                        time = dist / curShot.getSpeed() - 1.0;
                        break;
                    }
                    default: {
                        time = dist / curShot.getSpeed();
                    }
                }
                if (!(time < (double)curShot.getTimeToDestination()) || !((angleDif = Math.abs(Utils.getAngleDif(angleToTarget = Utils.TABLES.atan2(yDif, xDif), moveAngle))) < 0.7853981633974483) || !(Utils.TABLES.sin(angleDif) * dist < CombatHeuristics.getHitZone(curAsteroid))) continue;
                curShot.reAssignTarget(curAsteroid, (int)Math.round(time));
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" #");
        result.append(this.packetCount);
        result.append(" Skipped: ");
        result.append(this.packetDif);
        result.append("\n\nShip: ");
        result.append(this.ship);
        result.append("\nShips: ");
        result.append(this.ships);
        result.append("\nSaucer: ");
        result.append(this.saucer);
        result.append("\n\nShots: ");
        for (Shot curShot : this.shots) {
            result.append("\n" + curShot);
        }
        result.append("\n\nAsteroids: ");
        for (Asteroid curAsteroid : this.asteroids) {
            result.append("\n" + curAsteroid);
        }
        return result.toString();
    }

    void reset() {
        if (this.isSaucerAlive()) {
            this.saucer.destroy();
        }
        this.saucer = null;
        this.nextTarget = null;
        for (Asteroid curAsteroid : this.asteroids) {
            curAsteroid.destroy();
        }
        this.asteroids.clear();
        this.shots.clear();
        this.pendingShots.clear();
        this.packetCount = 0;
        this.packetDif = 0;
        this.ships = 3;
        this.isIngame = false;
        this.isValid = false;
        this.isMovementPhase = false;
        this.areAsteroidsVisible = false;
        this.ship.prepareTorpedos();
        this.ship.destroy();
    }

    void update(byte[] data) {
        ListIterator<Asteroid> curAsteroid = this.asteroids.listIterator();
        ListIterator<Shot> curShot = this.shots.listIterator();
        int curY = 0;
        int curX = 0;
        int curScale = 0;
        int dirX = 0;
        int dirY = 0;
        int vz = 0;
        int v1x = 0;
        int v1y = 0;
        int shipdetect = 0;
        boolean saucerDetected = false;
        boolean doExit = false;
        boolean readScore = true;
        boolean isExplosionExisting = false;
        boolean ingameDetected = true;
        String scoreStr = "";
        int shipsLeft = 0;
        int i = 2;
        this.pendingShots.clear();
        switch (data[1]) {
            case -30: {
                this.isMovementPhase = false;
                break;
            }
            case -32: {
                this.isMovementPhase = true;
                break;
            }
            default: {
                this.isIngame = false;
                this.isValid = false;
                return;
            }
        }
        this.matchPacketCount(data[1024] & 0xFF);
        while (!doExit) {
            int word = this.createWord(data[i], data[i + 1]);
            int opCode = word >> 12;
            block4 : switch (opCode) {
                case 10: {
                    curY = word & 0x3FF;
                    word = this.createWord(data[i += 2], data[i + 1]);
                    curX = word & 0x3FF;
                    curScale = word >> 12;
                    break;
                }
                case 11: {
                    doExit = true;
                    break;
                }
                case 12: {
                    switch (word & 0xFFF) {
                        case 2176: 
                        case 2198: 
                        case 2229: 
                        case 2256: {
                            isExplosionExisting = true;
                            break;
                        }
                        case 2291: {
                            this.matchAsteroid(curAsteroid, curX, curY, 1, curScale);
                            break;
                        }
                        case 2303: {
                            this.matchAsteroid(curAsteroid, curX, curY, 2, curScale);
                            break;
                        }
                        case 2317: {
                            this.matchAsteroid(curAsteroid, curX, curY, 3, curScale);
                            break;
                        }
                        case 2330: {
                            this.matchAsteroid(curAsteroid, curX, curY, 4, curScale);
                            break;
                        }
                        case 2345: {
                            saucerDetected = true;
                            this.matchSaucer(curX, curY, curScale);
                            break;
                        }
                        case 2669: {
                            readScore = false;
                            if (!scoreStr.isEmpty()) {
                                int newScore = Integer.parseInt(scoreStr);
                                CombatStatistics.setScore(newScore);
                            }
                            ++shipsLeft;
                            break;
                        }
                        case 2781: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "0";
                            break;
                        }
                        case 2862: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "1";
                            break;
                        }
                        case 2866: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "2";
                            break;
                        }
                        case 2874: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "3";
                            break;
                        }
                        case 2881: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "4";
                            break;
                        }
                        case 2888: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "5";
                            break;
                        }
                        case 2895: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "6";
                            break;
                        }
                        case 2902: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "7";
                            break;
                        }
                        case 2907: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "8";
                            break;
                        }
                        case 2915: {
                            if (!readScore) break block4;
                            scoreStr = String.valueOf(scoreStr) + "9";
                            break;
                        }
                        case 2715: {
                            ingameDetected = false;
                            readScore = false;
                            break;
                        }
                        case 2811: {
                            ingameDetected = false;
                            readScore = false;
                            break;
                        }
                    }
                    break;
                }
                case 13: {
                    doExit = true;
                    break;
                }
                case 14: {
                    doExit = true;
                    break;
                }
                case 15: {
                    break;
                }
                default: {
                    dirY = word & 0x3FF;
                    if ((word & 0x400) != 0) {
                        dirY = -dirY;
                    }
                    word = this.createWord(data[i += 2], data[i + 1]);
                    dirX = word & 0x3FF;
                    if ((word & 0x400) != 0) {
                        dirX = -dirX;
                    }
                    vz = word >> 12;
                    if (dirX == 0 && dirY == 0 && vz == 15) {
                        this.matchShot(curShot, curX, curY);
                        break;
                    }
                    if (opCode != 6 || vz != 12 || dirX == 0 || dirY == 0) break;
                    switch (shipdetect) {
                        case 0: {
                            v1x = dirX;
                            v1y = dirY;
                            ++shipdetect;
                            break block4;
                        }
                        case 1: {
                            this.matchShip(curX, curY, v1x - dirX, v1y - dirY);
                            ++shipdetect;
                        }
                    }
                }
            }
            if ((i += 2) <= 1022) continue;
            doExit = true;
        }
        if (shipdetect != 2) {
            if (this.isShipAlive()) {
                this.ship.destroy();
            }
            this.ship.updateAway(this.packetDif);
        }
        if (!saucerDetected && this.isSaucerAlive()) {
            CombatMessages.verbose(5);
            CombatStatistics.setSaucerDestroyed();
            if (!this.areAsteroidsVisible) {
                CombatStatistics.setSectorFinished();
                CombatMessages.verbose(0);
            }
            this.saucer.destroy();
            this.saucer = null;
        }
        while (curAsteroid.hasNext()) {
            Asteroid a = (Asteroid)curAsteroid.next();
            a.destroy();
            this.freeShots(a);
            curAsteroid.remove();
        }
        while (curShot.hasNext()) {
            Shot s = (Shot)curShot.next();
            s.destroy();
            curShot.remove();
        }
        this.reAssignShots();
        if (this.areAsteroidsVisible) {
            if (!isExplosionExisting && this.asteroids.isEmpty()) {
                this.areAsteroidsVisible = false;
                if (this.saucer == null) {
                    CombatStatistics.setSectorFinished();
                    CombatMessages.verbose(0);
                }
            }
        } else if (!this.asteroids.isEmpty()) {
            this.areAsteroidsVisible = true;
            CombatStatistics.SECTOR_START_TIME = CombatStatistics.TIME;
            CombatMessages.verbose(1);
        }
        this.ships = shipsLeft;
        if (shipsLeft == 0) {
            ingameDetected = false;
        }
        if (ingameDetected) {
            if (!this.isIngame) {
                this.isIngame = true;
                CombatStatistics.setNewGameStarted();
            }
        } else {
            this.isIngame = false;
        }
    }

    void update(CombatControl control) {
        if (this.isShipAlive()) {
            int i = 0;
            while (i < this.packetDif) {
                if (control.hasTurnedLeft()) {
                    this.ship.performTurnLeft();
                } else if (control.hasTurnedRight()) {
                    this.ship.performTurnRight();
                }
                if (this.isMovementPhase) {
                    if (control.hasAccelerated()) {
                        this.ship.performAcceleration();
                    } else {
                        this.ship.performDeceleration();
                    }
                } else {
                    this.ship.updateMovement();
                }
                ++i;
            }
        }
    }
}

