/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class StatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int STATE_ERROR = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_RUNNING = 3;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("mm:ss");
    private Date time = new Date();
    private JLabel[] timeLabels;
    private JLabel[] frameLabels;
    private JLabel[] lossLabels;
    private JLabel[] stateLabels;
    private JLabel[] serverLabels;
    private JLabel[] portLabels;

    public StatusPanel() {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Status"));
        int lWidth = 45;
        int vWidth = 125;
        this.setLayout(new BoxLayout(this, 3));
        this.timeLabels = this.createLabelPair("Time:", lWidth, "00:00", vWidth);
        this.frameLabels = this.createLabelPair("Frame:", lWidth, "00001", vWidth);
        this.lossLabels = this.createLabelPair("Loss:", lWidth, "000", vWidth);
        this.stateLabels = this.createLabelPair("State:", lWidth, "Waiting", vWidth);
        this.stateLabels[1].setForeground(Color.ORANGE.darker());
        this.serverLabels = this.createLabelPair("Server:", lWidth, "localhost", vWidth);
        this.portLabels = this.createLabelPair("Port:", lWidth, "1979", vWidth);
    }

    public void updateTime(long refTime) {
        this.time.setTime(refTime * 100L / 6L);
        this.timeLabels[1].setText(this.timeFormat.format(this.time));
    }

    public void updateFrame(int frame) {
        String frameFormat = "%05d";
        this.frameLabels[1].setText(String.format(frameFormat, frame));
    }

    public void updateLoss(int loss) {
        String frameFormat = "%03d";
        this.lossLabels[1].setText(String.format(frameFormat, loss));
    }

    public void updateConnection(String server, int port) {
        this.serverLabels[1].setText(server);
        this.portLabels[1].setText(Integer.toString(port));
    }

    public void updateState(int state) {
        switch (state) {
            case 0: {
                this.stateLabels[1].setForeground(Color.RED);
                this.stateLabels[1].setText("Disconnected");
                break;
            }
            case 1: {
                this.stateLabels[1].setForeground(Color.ORANGE.darker());
                this.stateLabels[1].setText("Waiting");
                break;
            }
            case 2: {
                this.stateLabels[1].setForeground(Color.GREEN.darker());
                this.stateLabels[1].setText("Connected");
                break;
            }
            case 3: {
                this.stateLabels[1].setForeground(Color.BLUE);
                this.stateLabels[1].setText("Running");
                break;
            }
            default: {
                this.stateLabels[1].setForeground(Color.BLACK);
                this.stateLabels[1].setText("Undefined");
            }
        }
    }

    public JLabel[] createLabelPair(String label, int lWidth, String value, int vWidth) {
        JPanel result = new JPanel();
        JLabel[] labels = new JLabel[2];
        labels[0] = new JLabel(label);
        Dimension prefSize = labels[0].getPreferredSize();
        labels[0].setPreferredSize(new Dimension(lWidth, prefSize.height));
        labels[0].setAlignmentX(0.0f);
        labels[1] = new JLabel(value);
        prefSize = labels[1].getPreferredSize();
        labels[1].setPreferredSize(new Dimension(vWidth, prefSize.height));
        result.setLayout(new FlowLayout(3, 5, 0));
        result.setAlignmentX(0.0f);
        result.add(labels[0]);
        result.add(labels[1]);
        this.add(result);
        return labels;
    }
}

