/*
 * Decompiled with CFR 0.152.
 */
import gui.MainFrame;
import gui.MainPanel;
import helpers.CombatHeuristics;
import helpers.CombatMessages;
import helpers.CombatStatistics;
import io.CombatAI;
import io.CombatConnection;
import io.CombatControl;
import io.CombatState;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import objects.Asteroid;
import objects.CombatObject;
import objects.PreAsteroid;
import objects.Saucer;
import objects.Ship;
import objects.Shot;
import objects.TargetObject;
import structures.TargetConfiguration;
import structures.TargetInformation;
import utils.Tables;
import utils.Utils;

public class EarthDefenseBot
implements CombatAI {
    public static final String WINDOW_TITLE = "Earth Defense Bot v.0.5.1";
    private MainFrame mainFrame;
    private MainPanel mainPanel;
    private CombatConnection connection;
    private Thread updateGUIThread;
    private TargetConfiguration curTarget = new TargetConfiguration();
    private LinkedList<CombatObject> vicinity = new LinkedList();
    private LinkedList<CombatObject> colliding = new LinkedList();
    private long lastShotTime = Long.MAX_VALUE;
    private boolean isShipLost = false;
    private double maxEvasionSpeed = 8.0;
    private boolean isStartingAutonomous = true;
    private boolean isStoppingAutonomous = true;
    private boolean isActivated = false;
    private boolean isDataDirty = false;
    private boolean forceTargetSwitch = false;
    private Point[] strategicPositions = new Point[]{new Point(148, 276), new Point(875, 276), new Point(148, 747), new Point(875, 747)};
    private Runnable updateGUICycle = new Runnable(){

        @Override
        public void run() {
            while (EarthDefenseBot.this.isActivated) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                EarthDefenseBot.this.updateStatus();
                EarthDefenseBot.this.mainPanel.repaint();
                EarthDefenseBot.this.isDataDirty = true;
            }
        }
    };
    public ActionListener controlListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((EarthDefenseBot)EarthDefenseBot.this).mainPanel.controlPanel.isServerButtonClicked(e)) {
                Object newServer = JOptionPane.showInputDialog(EarthDefenseBot.this.mainFrame, "Please enter the new server IP: ", "Select Server", 3, null, null, EarthDefenseBot.this.connection);
                if (newServer != null) {
                    EarthDefenseBot.this.setActivated(false);
                    EarthDefenseBot.this.connection.selectHost(newServer.toString());
                }
            } else if (((EarthDefenseBot)EarthDefenseBot.this).mainPanel.controlPanel.isStartButtonClicked(e)) {
                EarthDefenseBot.this.toggleActivated();
            } else if (((EarthDefenseBot)EarthDefenseBot.this).mainPanel.controlPanel.isAutoStartBoxToggled(e)) {
                EarthDefenseBot.this.isStartingAutonomous = !EarthDefenseBot.this.isStartingAutonomous;
            } else if (((EarthDefenseBot)EarthDefenseBot.this).mainPanel.controlPanel.isAutoStopBoxToggled(e)) {
                EarthDefenseBot.this.isStoppingAutonomous = !EarthDefenseBot.this.isStoppingAutonomous;
            }
        }
    };

    public static void main(String[] arguments) {
        EarthDefenseBot edb = new EarthDefenseBot(arguments);
        edb.show();
    }

    public EarthDefenseBot(String[] args) {
        Utils.init();
        this.mainPanel = new MainPanel(this.controlListener);
        this.mainFrame = new MainFrame("/icon.gif", WINDOW_TITLE, this.mainPanel);
        CombatMessages.setGUIOutput(this.mainPanel.combatPanel);
        String host = "127.0.0.1";
        if (args.length > 0) {
            host = args[0];
        }
        int port = 1979;
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        this.connection = new CombatConnection(host, port, this);
        this.connection.setGUIOutput(this.mainPanel.statusPanel);
        this.connection.startCommunication();
    }

    public boolean approximateTarget(TargetConfiguration config, CombatState state, CombatControl control) {
        this.calculateTurnTime(config, config.info, control);
        config.shootTime = 0;
        config.postWaitTime = 0;
        int[] timeTaken = new int[10];
        int i = 0;
        int invalidCount = 0;
        boolean isConverging = true;
        boolean isFinished = false;
        do {
            int lastAngleIndex = config.angleIndex;
            timeTaken[i] = config.getTimeTaken();
            config.preCalculate(timeTaken[i], state, control, false);
            this.calculateTurnTime(config, config.preCalc, control);
            this.calculateShootTime(config, config.preCalc, control);
            int angleIndexDif = Utils.getAngleIndexDif(config.angleIndex, lastAngleIndex);
            int j = i - 2;
            while (j > 0) {
                if (timeTaken[i] == timeTaken[j]) {
                    isConverging = false;
                    break;
                }
                --j;
            }
            if (!isConverging) {
                int timeSum = timeTaken[i];
                int numTimes = 1;
                int j2 = i - 1;
                while (j2 > 0 && timeTaken[j2] != timeTaken[i]) {
                    timeSum += timeTaken[j2];
                    ++numTimes;
                    --j2;
                }
                if (timeSum % numTimes == 0) {
                    timeTaken[i] = timeSum / numTimes;
                } else {
                    double crossProduct = (double)config.info.difX * config.object.getMovementY() - (double)config.info.difY * config.object.getMovementX();
                    if (Utils.getAngleDif(state.getShip().getMovementAngle(), config.info.angle) < 0.0) {
                        crossProduct *= -1.0;
                    }
                    timeTaken[i] = crossProduct < 0.0 ? timeSum / numTimes + 1 : timeSum / numTimes;
                }
                config.preCalculate(timeTaken[i], state, control, false);
                this.calculateTurnTime(config, config.preCalc, control);
                this.calculateShootTime(config, config.preCalc, control);
                timeTaken[i] = config.getTimeTaken();
                config.preCalculate(timeTaken[i], state, control, true);
            }
            invalidCount = !config.isValid ? ++invalidCount : 0;
            isFinished = invalidCount == 2 || i == 9 || i > 0 && angleIndexDif == 0 && timeTaken[i] == timeTaken[i - 1];
            ++i;
        } while (!isFinished && isConverging);
        if (config.isValid) {
            if (config.object.isMovementPrecise() && !state.getShip().isMoving()) {
                i = 0;
                config.preCalc.angleDif = Utils.getAngleDif(Utils.TABLES.getAngle(config.angleIndex), config.preCalc.angle);
                if (!CombatHeuristics.isTargetHittable(config, config.preCalc)) {
                    config.postWaitTime = config.turnTime - config.preWaitTime;
                    do {
                        ++config.postWaitTime;
                        config.preCalculate(config.getWaitTime() + config.shootTime, state, control, false);
                        this.calculateTurnTime(config, config.preCalc, control);
                        this.calculateShootTime(config, config.preCalc, control);
                        config.preCalc.angleDif = Utils.getAngleDif(Utils.TABLES.getAngle(config.angleIndex), config.preCalc.angle);
                    } while (++i < 10 && !CombatHeuristics.isTargetHittable(config, config.preCalc));
                }
                config.preCalculate(Math.max(config.getWaitTime(), config.turnTime) + config.shootTime, state, control, true);
                config.isDifficult = i >= 10;
            }
            return true;
        }
        return false;
    }

    public void aquireTarget(CombatState state, CombatControl control, boolean firstInterpretation) {
        Ship ship = state.getShip();
        Saucer saucer = state.getSaucer();
        double bestRating = Double.MAX_VALUE;
        TargetConfiguration config = new TargetConfiguration();
        this.curTarget.object = null;
        this.curTarget.isDifficult = false;
        this.forceTargetSwitch = false;
        int asteroidNum = state.getAsteroidNumber();
        for (Asteroid curAsteroid : state.getAsteroids()) {
            config.calculate(ship, curAsteroid);
            if (firstInterpretation) {
                this.checkCollisionStatus(config, false);
            }
            if (curAsteroid.getTargetedStatus() == 0) {
                config.preWaitTime = CombatHeuristics.getPrecisionDelay(config.info.distance, curAsteroid) + 1;
                if (!this.approximateTarget(config, state, control)) continue;
                config.prioritization = CombatHeuristics.getCollidingPrioritization(config);
                if (!config.isBetterThan(bestRating)) continue;
                bestRating = config.getRating();
                this.curTarget.setConfig(config);
                continue;
            }
            if (!curAsteroid.hasChild()) continue;
            PreAsteroid child = curAsteroid.getChild();
            config.calculate(ship, child);
            config.preWaitTime = child.getTimeToSpawn() + 1;
            if (!this.approximateTarget(config, state, control) || !config.isBetterThan(bestRating)) continue;
            bestRating = config.getRating();
            this.curTarget.setConfig(config);
        }
        if (state.isSaucerAlive()) {
            config.calculate(ship, saucer);
            if (firstInterpretation) {
                this.checkCollisionStatus(config, saucer.getScale() == 14);
            }
            if (saucer.getTargetedStatus() == 0 && this.approximateTarget(config, state, control)) {
                config.prioritization = CombatHeuristics.getSaucerPrioritization(state, config, saucer, asteroidNum);
                if (config.isBetterThan(bestRating)) {
                    bestRating = config.getRating();
                    this.curTarget.setConfig(config);
                }
            }
        }
    }

    public void calculateShootTime(TargetConfiguration c, TargetInformation i, CombatControl control) {
        c.shootTime = (int)Math.round(i.distance / Utils.TABLES.getShotSpeed(c.angleIndex));
        if (control.willFire()) {
            c.shootTime += 2;
        } else {
            c.shootTime += Math.max(2 - Math.max(c.getWaitTime(), c.turnTime), 1);
            if (control.isFiring()) {
                ++c.shootTime;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void calculateTurnTime(TargetConfiguration c, TargetInformation i, CombatControl control) {
        block20: {
            block21: {
                block18: {
                    block19: {
                        c.turnTime = 0;
                        startIndex = c.ship.getAngleIndex();
                        if (control.isTurningLeft()) {
                            ++c.turnTime;
                            startIndex = Utils.incByteAngle(startIndex);
                        } else if (control.isTurningRight()) {
                            ++c.turnTime;
                            startIndex = Utils.decByteAngle(startIndex);
                        }
                        i.angleDif = Utils.getAngleDif(Utils.TABLES.getAngle(startIndex), i.angle);
                        nextIndex = startIndex;
                        if (!(i.angleDif > 0.0)) break block18;
                        if (!(i.angle < 0.0)) ** GOTO lbl21
                        while (Utils.TABLES.getAngle(nextIndex) > 0.0) {
                            ++c.turnTime;
                            nextIndex = Utils.incByteAngle(nextIndex);
                        }
                        break block19;
lbl-1000:
                        // 1 sources

                        {
                            ++c.turnTime;
                            nextIndex = Utils.incByteAngle(nextIndex);
lbl21:
                            // 2 sources

                            ** while (Utils.TABLES.getAngle((int)nextIndex) < 0.0)
                        }
                    }
                    while (!Utils.isAngleReachedCCW(Utils.TABLES.getAngle(nextIndex), i.angle)) {
                        ++c.turnTime;
                        nextIndex = Utils.incByteAngle(nextIndex);
                    }
                    difNext = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(nextIndex), i.angle));
                    c.angleIndex = Utils.decByteAngle(nextIndex);
                    difLast = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(c.angleIndex), i.angle));
                    if (difNext > difLast) {
                        --c.turnTime;
                    } else {
                        c.angleIndex = nextIndex;
                    }
                    if (c.angleIndex != startIndex) {
                        nextIndex = Utils.decByteAngle(c.angleIndex);
                        difLast = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(nextIndex), i.angle));
                        hitZone = CombatHeuristics.getImprovedHitZone(c.object);
                        deviationLast = Utils.TABLES.sin(difLast) * i.distance;
                        if (deviationLast < hitZone) {
                            --c.turnTime;
                            c.angleIndex = nextIndex;
                        }
                    }
                    break block20;
                }
                if (!(i.angle > 0.0)) ** GOTO lbl52
                while (Utils.TABLES.getAngle(nextIndex) < 0.0) {
                    ++c.turnTime;
                    nextIndex = Utils.decByteAngle(nextIndex);
                }
                break block21;
lbl-1000:
                // 1 sources

                {
                    ++c.turnTime;
                    nextIndex = Utils.decByteAngle(nextIndex);
lbl52:
                    // 2 sources

                    ** while (Utils.TABLES.getAngle((int)nextIndex) > 0.0)
                }
            }
            while (!Utils.isAngleReachedCW(Utils.TABLES.getAngle(nextIndex), i.angle)) {
                ++c.turnTime;
                nextIndex = Utils.decByteAngle(nextIndex);
            }
            difNext = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(nextIndex), i.angle));
            c.angleIndex = Utils.incByteAngle(nextIndex);
            difLast = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(c.angleIndex), i.angle));
            if (difNext > difLast) {
                --c.turnTime;
            } else {
                c.angleIndex = nextIndex;
            }
            if (c.angleIndex != startIndex) {
                nextIndex = Utils.incByteAngle(c.angleIndex);
                difLast = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(nextIndex), i.angle));
                hitZone = CombatHeuristics.getImprovedHitZone(c.object);
                deviationLast = Utils.TABLES.sin(difLast) * i.distance;
                if (deviationLast < hitZone) {
                    --c.turnTime;
                    c.angleIndex = nextIndex;
                }
            }
        }
        if (c.turnTime > 0 && !control.isTurningLeft() && !control.isTurningRight()) {
            ++c.turnTime;
        }
    }

    public void checkCollisionStatus(TargetConfiguration config, boolean isSmallSaucer) {
        if (config.info.distance - (double)config.object.getRadius() < 50.0) {
            this.vicinity.add(config.object);
        }
        config.collisionTime = Utils.willCollideWithin(config.ship, config.object, 60);
        if (!isSmallSaucer && config.object.getTargetedStatus() == 0 && config.collisionTime < 60 && Math.abs(config.info.angleDif) > 1.427996660722633) {
            this.colliding.add(config.object);
            this.maxEvasionSpeed = Math.max(this.maxEvasionSpeed, config.info.angleDif / 1.427996660722633 * 8.0);
        }
    }

    public void followTarget(CombatState state, TargetObject targetObject, CombatControl control, boolean firstInterpretation) {
        double bestRating = this.curTarget.getRating();
        this.curTarget.reCalculate();
        TargetConfiguration config = new TargetConfiguration();
        Ship ship = state.getShip();
        Saucer saucer = state.getSaucer();
        boolean newTarget = false;
        int asteroidNum = state.getAsteroidNumber();
        for (Asteroid curAsteroid : state.getAsteroids()) {
            config.calculate(ship, curAsteroid);
            if (firstInterpretation) {
                this.checkCollisionStatus(config, false);
            }
            if (curAsteroid.getTargetedStatus() != 0 || !CombatHeuristics.isTargetSwitchReasonable(targetObject, config)) continue;
            config.preWaitTime = CombatHeuristics.getPrecisionDelay(config.info.distance, curAsteroid) + 1;
            if (!this.approximateTarget(config, state, control)) continue;
            config.prioritization = CombatHeuristics.getCollidingPrioritization(config);
            if (!config.isBetterThan(bestRating) && targetObject.getID() != -1) continue;
            bestRating = config.getRating();
            this.curTarget.setConfig(config);
            newTarget = true;
        }
        if (state.isSaucerAlive()) {
            config.calculate(ship, saucer);
            if (firstInterpretation) {
                this.checkCollisionStatus(config, saucer.getScale() == 14);
            }
            if (saucer.getTargetedStatus() == 0 && this.approximateTarget(config, state, control)) {
                config.prioritization = CombatHeuristics.getSaucerPrioritization(state, config, saucer, asteroidNum);
                if (config.isBetterThan(bestRating)) {
                    bestRating = config.getRating();
                    this.curTarget.setConfig(config);
                    newTarget = true;
                }
            }
        }
        if (newTarget) {
            ++CombatStatistics.TARGET_COUNT;
            this.lastShotTime = Long.MAX_VALUE;
        }
    }

    @Override
    public void handleState(CombatState state, CombatControl control) {
        if (state.isIngame()) {
            Ship ship = state.getShip();
            this.updateStatistics(state);
            this.colliding.clear();
            this.vicinity.clear();
            if (ship.isAlive() && !control.isWarping()) {
                if (this.isShipLost) {
                    CombatMessages.verbose(7);
                    this.isShipLost = false;
                }
                if (this.curTarget.object == null || !this.curTarget.object.isAlive()) {
                    this.forceTargetSwitch = true;
                }
                boolean reinterprete = false;
                if (this.forceTargetSwitch || CombatHeuristics.isMaxShotCountReached(this.curTarget.object)) {
                    if (CombatHeuristics.willSpawnChildren(this.curTarget.object, state)) {
                        ((Asteroid)this.curTarget.object).createChild(this.curTarget.preCalc.distance, (int)Math.round(this.curTarget.preCalc.distance / Utils.TABLES.getShotSpeed(this.curTarget.angleIndex)));
                    }
                    this.aquireTarget(state, control, true);
                    if (this.curTarget.object != null) {
                        ++CombatStatistics.TARGET_COUNT;
                        if (this.curTarget.object instanceof Saucer) {
                            CombatMessages.verbose(3);
                        } else if (!state.isSaucerAlive()) {
                            CombatMessages.verbose(8);
                        }
                        this.lastShotTime = Long.MAX_VALUE;
                    }
                } else {
                    this.curTarget.passTime(state.getPacketDif());
                    this.followTarget(state, this.curTarget.object, control, true);
                }
                if (this.curTarget.object != null) {
                    if (this.approximateTarget(this.curTarget, state, control)) {
                        if (this.curTarget.turnTime > 1) {
                            if (this.curTarget.preCalc.angleDif > 0.0) {
                                control.turnLeft();
                            } else {
                                control.turnRight();
                            }
                        } else if (ship.isTorpedoReady() && this.curTarget.isReadyToFire(state)) {
                            if (!control.willFire() && !control.isFiring() && CombatHeuristics.isTargetHittable(this.curTarget, this.curTarget.preCalc)) {
                                control.fire();
                                this.lastShotTime = CombatStatistics.TIME;
                                state.fireFlag(this.curTarget.object, 2 + (int)Math.round(this.curTarget.preCalc.distance / Utils.TABLES.getShotSpeed(this.curTarget.angleIndex)));
                                if (CombatHeuristics.isMaxShotCountReached(this.curTarget.object)) {
                                    reinterprete = true;
                                }
                            }
                        } else if ((long)CombatStatistics.TIME - this.lastShotTime > 3L) {
                            this.forceTargetSwitch = true;
                            reinterprete = true;
                        }
                        if ((long)CombatStatistics.TIME - this.lastShotTime > 6L) {
                            this.forceTargetSwitch = true;
                            reinterprete = true;
                        }
                    } else {
                        this.forceTargetSwitch = true;
                        reinterprete = true;
                    }
                    if (reinterprete) {
                        this.reinterpretState(state, control);
                    }
                } else {
                    this.prepareForNextSector(ship, control);
                }
                if (this.checkEmergencyStatus(state, control) && !control.isWarping()) {
                    CombatMessages.verbose(9);
                    control.hyperspace();
                    this.forceTargetSwitch = true;
                    ++CombatStatistics.ESCAPES;
                }
                if (state.isMovementPhase()) {
                    this.move(state, control);
                }
            } else {
                this.forceTargetSwitch = true;
                if (!this.isShipLost && ship.isLost()) {
                    CombatMessages.verbose(6);
                    this.isShipLost = true;
                    ++CombatStatistics.DEATHS;
                    CombatStatistics.exaggerateSaucerDelay();
                }
                CombatStatistics.increaseSaucerDelay();
                ++CombatStatistics.IDLE_TIME;
            }
            if (this.isStoppingAutonomous && CombatStatistics.TIME > 17999) {
                this.setActivated(false);
            }
        } else if (this.isStartingAutonomous && !control.isStarting()) {
            control.start();
        }
    }

    @Override
    public synchronized boolean isActivated() {
        return this.isActivated;
    }

    public boolean checkEmergencyStatus(CombatState state, CombatControl control) {
        Ship ship = state.getShip();
        for (Shot curShot : state.getShots()) {
            int difY;
            if (curShot.getOwner() == ship) continue;
            int difX = Utils.getXDif(ship.getPosX(), curShot.getPosX());
            double distance = Utils.TABLES.dist(difX, difY = Utils.getYDif(ship.getPosY(), curShot.getPosY()));
            if (distance - (double)curShot.getRadius() < 50.0) {
                CombatMessages.verbose(4);
                this.vicinity.add(curShot);
            }
            double angle = Utils.TABLES.atan2(difY, difX);
            double angleDif = Math.abs(Utils.getAngleDif(ship.getMovementAngle(), angle));
            int collisionTime = Utils.willCollideWithin(ship, curShot, 60);
            if (collisionTime >= 60 || !(Math.abs(angleDif - 1.5707963267948966) < 1.0471975511965976)) continue;
            this.colliding.add(curShot);
        }
        for (CombatObject curObject : this.vicinity) {
            if (curObject instanceof TargetObject) {
                TargetObject curTargetObject = (TargetObject)curObject;
                if (control.isFiring() && curTargetObject.getTargetedStatus() > 0 || curTargetObject.getFiredUponStatus() > 0) continue;
            }
            if (!Utils.willCollideIn(ship, curObject, 2)) continue;
            return true;
        }
        return false;
    }

    public void move(CombatState state, CombatControl control) {
        Ship ship = state.getShip();
        int shipSpeed = (int)Math.ceil(ship.getSpeed() * 8.0);
        if (!control.isAccelerating()) {
            double minDist = Double.MAX_VALUE;
            int minX = 0;
            int minY = 0;
            int i = 0;
            while (i < 4) {
                int y;
                int x = Utils.getXDif(ship.getPosX(), this.strategicPositions[i].x);
                if (Utils.TABLES.dist(x, y = Utils.getYDif(ship.getPosY(), this.strategicPositions[i].y)) < minDist) {
                    minDist = Utils.TABLES.dist(x, y);
                    minX = x;
                    minY = y;
                }
                ++i;
            }
            double goalAngle = Utils.TABLES.atan2(minY, minX);
            int futureShipAngle = ship.getAngleIndex();
            if (control.isTurningLeft()) {
                futureShipAngle = Utils.incByteAngle(futureShipAngle);
            } else if (control.isTurningRight()) {
                futureShipAngle = Utils.decByteAngle(futureShipAngle);
            }
            double angleDif = Math.abs(Utils.getAngleDif(Utils.TABLES.getAngle(futureShipAngle), goalAngle));
            if (shipSpeed < 8 && minDist > (double)Tables.SPEED_BORDERS[shipSpeed] && angleDif < 0.2991993003418851) {
                control.accelerate();
            }
        }
        if (!control.isAccelerating()) {
            this.colliding.remove(this.curTarget.object);
            if ((double)shipSpeed < this.maxEvasionSpeed && !this.colliding.isEmpty()) {
                control.accelerate();
            }
            this.maxEvasionSpeed = 8.0;
        }
        if (!control.isAccelerating() && this.curTarget.isDifficult && shipSpeed < 2 && Math.abs(this.curTarget.preCalc.angleDif) > 0.7853981633974483) {
            control.accelerate();
        }
    }

    public void prepareForNextSector(Ship ship, CombatControl control) {
        double fuzzy;
        double turnAngle = Utils.TABLES.getPreparationDirection(ship.getPosX(), ship.getPosY());
        double angleDif = Utils.getAngleDif(ship.getMovementAngle(), turnAngle);
        if (angleDif > (fuzzy = 0.15707963267948966)) {
            control.turnLeft();
        } else if (angleDif < -fuzzy) {
            control.turnRight();
        }
    }

    public void reinterpretState(CombatState state, CombatControl control) {
        if (this.curTarget.object == null || !this.curTarget.object.isAlive()) {
            this.forceTargetSwitch = true;
        }
        Ship ship = state.getShip();
        if (this.forceTargetSwitch || CombatHeuristics.isMaxShotCountReached(this.curTarget.object)) {
            if (CombatHeuristics.willSpawnChildren(this.curTarget.object, state)) {
                ((Asteroid)this.curTarget.object).createChild(this.curTarget.preCalc.distance, (int)Math.round(this.curTarget.preCalc.distance / Utils.TABLES.getShotSpeed(this.curTarget.angleIndex)));
            }
            this.aquireTarget(state, control, false);
            if (this.curTarget.object != null) {
                ++CombatStatistics.TARGET_COUNT;
                this.lastShotTime = Long.MAX_VALUE;
            }
        } else {
            this.followTarget(state, this.curTarget.object, control, false);
        }
        if (this.curTarget.object != null) {
            if (this.approximateTarget(this.curTarget, state, control)) {
                if (this.curTarget.turnTime > 1) {
                    if (this.curTarget.preCalc.angleDif > 0.0) {
                        control.turnLeft();
                    } else {
                        control.turnRight();
                    }
                } else if (ship.isTorpedoReady() && this.curTarget.isReadyToFire(state)) {
                    if (!control.willFire() && !control.isFiring() && CombatHeuristics.isTargetHittable(this.curTarget, this.curTarget.preCalc)) {
                        control.fire();
                        this.lastShotTime = CombatStatistics.TIME;
                        state.fireFlag(this.curTarget.object, 2 + (int)Math.round(this.curTarget.preCalc.distance / Utils.TABLES.getShotSpeed(this.curTarget.angleIndex)));
                    }
                } else if ((long)CombatStatistics.TIME - this.lastShotTime > 3L) {
                    this.forceTargetSwitch = true;
                }
                if ((long)CombatStatistics.TIME - this.lastShotTime > 6L) {
                    this.forceTargetSwitch = true;
                }
            } else {
                this.forceTargetSwitch = true;
            }
        } else {
            this.prepareForNextSector(ship, control);
        }
    }

    @Override
    public void reset() {
        this.setActivated(false);
    }

    public synchronized void setActivated(boolean activated) {
        if (activated != this.isActivated) {
            this.isActivated = activated;
            this.mainFrame.setIgnoreRepaint(this.isActivated);
            this.mainPanel.controlPanel.updateButtons(activated);
            this.connection.updateStatus();
            if (activated) {
                this.isDataDirty = true;
                this.lastShotTime = Long.MAX_VALUE;
                this.isShipLost = false;
                this.maxEvasionSpeed = 8.0;
                this.forceTargetSwitch = true;
                this.curTarget.object = null;
                CombatStatistics.reset();
                CombatMessages.reset();
                this.mainPanel.combatPanel.resetCombatEventList();
                this.updateGUIThread = new Thread(this.updateGUICycle);
                this.updateGUIThread.setName("Time Thread");
                this.updateGUIThread.setPriority(1);
                this.updateGUIThread.start();
            } else {
                try {
                    this.updateGUIThread.interrupt();
                    this.updateGUIThread.join();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                CombatStatistics.dumpToFile();
                System.gc();
            }
        }
    }

    public void show() {
        this.mainFrame.pack();
        this.mainFrame.centerOnScreen();
        this.mainFrame.setVisible(true);
    }

    public synchronized void toggleActivated() {
        this.setActivated(!this.isActivated);
    }

    public void updateStatistics(CombatState state) {
        CombatStatistics.TIME += state.getPacketDif();
        if (this.isDataDirty) {
            this.mainPanel.statisticsPanel.updateStatus(CombatStatistics.getScore(), CombatStatistics.SPACE_SECTOR, state.getAsteroidNumber());
            this.mainPanel.statisticsPanel.updateActions(CombatStatistics.SHOTS_FIRED, CombatStatistics.DEATHS, CombatStatistics.ESCAPES, CombatStatistics.getGlobalSaucerCount());
            this.mainPanel.statisticsPanel.updateRatings(CombatStatistics.getTargetRate(), CombatStatistics.getShootingRate(), CombatStatistics.getHitRate(), CombatStatistics.getActivityRate());
            this.isDataDirty = false;
        }
    }

    public void updateStatus() {
        this.mainPanel.statusPanel.updateTime(CombatStatistics.TIME);
        this.mainPanel.statusPanel.updateFrame(CombatStatistics.TIME);
        this.mainPanel.statusPanel.updateLoss(CombatStatistics.PACKET_LOSS);
    }

    @Override
    public void watchState(CombatState state, CombatControl control) {
        if (this.isStartingAutonomous && !state.isIngame()) {
            this.setActivated(true);
        }
    }
}

