unit U_KiZ;

interface
uses konstanten;
type Tki= record
           reihenfolge:arrayofinteger;
           asteroid:arrayofinteger;
           werte:arrayofinteger;
           schuss:array[0..3]of integer;
           winkel:integer;
           zeit:integer;
           punkte:integer;
end;

type TKiZ = class(TObject)
  private
    k:TKi;
    procedure next(const k:TKi);
    procedure quicksortMin(an,en:integer);
    procedure quicksortMax(an,en:integer);
    function teste_ziel:boolean;
  protected
  public
    min:integer;
    Reihenfolge:arrayofinteger;
    Reihenfolge_new:arrayofinteger;
    optimiere_ende,optimiere_Attrappe:boolean;
    autoschuss,optimiere_Richtung:boolean;
    constructor Create;
    destructor Destroy; override;
    procedure Idle;
    procedure Go;
    procedure DatenBegin;
    procedure DatenEnd;

    function  berechne:boolean;
    procedure add(const nr:integer;werte:integer=0);
    procedure clear;
    procedure sortMin;
    procedure sortMax;
  end;


implementation
Uses Tools,U_Spiel,U_Asteroid_Manager,U_Asteroid,U_Key,U_Mame,U_Schiff,U_Schuss_Manager,U_UfoSchuss_Manager,U_UfoSchuss,U_Schuss,
     math,unit1,U_KI_Manager, StrUtils, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
     Dialogs, StdCtrls,  ExtCtrls,Sockets,SyncObjs;


constructor TKiZ.Create;
begin
  inherited Create;

end;

destructor TKiZ.Destroy;
begin

  inherited Destroy;
end;

procedure TKiZ.DatenBegin;
begin

end;

procedure TKiZ.DatenEnd;
begin

end;

procedure TKiz.next(const k:TKi);
var nr,re:integer;
    a:TKi;
    i,j,winkel,schuss,flug,sm,abschuss,wait,p:integer;
begin
  if mame.Daten<>0 then exit;
  if k.zeit>900 then exit;
  if k.punkte>=min then exit;
  if (length(k.asteroid)=0) then begin
     p:=k.punkte;
     if optimiere_ende then begin sm:=k.schuss[0];for j:=1 to 3 do if k.schuss[j]>sm then sm:=k.Schuss[j];if sm>0 then inc(p,sm);end;
     if (length(k.reihenfolge)>0)and(p<min) then begin
        min:=p;
        reihenfolge_new:=copyarray(k.reihenfolge);
     end;
     exit;
  end;

  for i:=0 to length(k.asteroid)-1 do begin
      a:=k;
      a.asteroid:=copyarray(k.asteroid);
      a.reihenfolge:=copyarray(k.reihenfolge);

      nr:=a.asteroid[i];

      re:=length(a.reihenfolge);
      setlength(a.reihenfolge,re+1);
      a.reihenfolge[re]:=nr;

      a.asteroid[i]:=a.asteroid[length(a.asteroid)-1];
      setlength(a.asteroid,length(a.asteroid)-1);
      sm:=a.schuss[0];for j:=1 to 3 do if a.schuss[j]<sm then sm:=a.Schuss[j];

      repeat
        winkel:=Asteroid.Asteroid[nr].Schuss_richtungs_vorhersage(a.winkel,a.zeit,schuss,flug,wait);

        abschuss:=schuss-flug;if abschuss<1 then abschuss:=1;
        inc(a.zeit,abschuss);
        inc(a.punkte,abschuss);
        // UFO
        if not optimiere_ende then begin
           for j:=0 to length(a.asteroid)-1 do if a.asteroid[j]=0 then inc(a.punkte,abschuss);
           if nr=0 then inc(a.punkte,abschuss);
        end;

        // Attrappen
//        if (optimiere_Attrappe)and(Asteroid.Asteroid[nr].Atyp=Typ_Attrappe)and(length(Asteroid.Asteroid[nr].Zeit)-70<Asteroid.Asteroid[nr].alter+a.zeit) then inc(a.punkte,1000);

        a.winkel:=winkel;
        for j:=0 to 3 do dec(a.schuss[j],abschuss);
        dec(sm,abschuss);
      until (sm<=0)or (schuss<0);

      // Kollision
      for j:=0 to length(a.asteroid)-1 do if (asteroid.Asteroid[a.asteroid[j]].Kollision>=0)and(asteroid.Asteroid[a.asteroid[j]].Kollision<=a.zeit+HyperspaceTest+asteroid.Asteroid[nr].groesse shr 1)then inc(a.punkte,10000);
      if (asteroid.Asteroid[nr].Kollision>=0)and(asteroid.Asteroid[nr].Kollision<=a.zeit+HyperspaceTest+asteroid.Asteroid[nr].groesse shr 1)then inc(a.punkte,10000);

      for j:=0 to 3 do if a.schuss[j]<1 then begin a.schuss[j]:=flug;break;end;
      next(a);
      if mame.Daten<>0 then exit;
  end;
end;


function TKiZ.berechne:boolean;
var i,j:integer;
begin
  result:=false;
  setlength(reihenfolge_new,0);

  if length(k.asteroid)<1 then exit;
  if length(k.asteroid)=1 then begin
     reihenfolge:=copyarray(k.asteroid);
     exit;
  end;

  // lade Daten
  setlength(k.reihenfolge,0);
  for i:=0 to 3 do k.schuss[i]:=-1;
  j:=0;for i:=0 to schuss.Max do if schuss.Schuss[i].Active then if j<4 then begin k.schuss[j]:=Schuss.Schuss[i].schritte;inc(j);end;
  k.winkel:=schiff.winkel;
  k.zeit:=0;
  k.punkte:=0;
  min:=2000000000;

  // begin
  next(k);
  if mame.Daten<>0 then exit;


  // Reihenfolge ermittelt
  if length(reihenfolge_new)>=1 then begin
     reihenfolge:=copyarray(reihenfolge_new);
     result:=true;
  end;
end;

procedure TKiZ.Clear;
begin
 setlength(k.asteroid,0);
 setlength(k.werte,0);
 optimiere_ende:=false;
 optimiere_Attrappe:=false;

end;

procedure TKiZ.add(const nr:integer;werte:integer=0);
var l,i:integer;
begin
  l:=length(k.asteroid);

  if nr<0 then exit;
  if not asteroid.Asteroid[nr].Active then exit;
  if asteroid.Asteroid[nr].SchussCounter>0 then exit;
  if length(asteroid.Asteroid[nr].zeit)<asteroid.Asteroid[nr].alter+1000 then asteroid.Asteroid[nr].setVorhersage(asteroid.Asteroid[nr].alter+1100);
  if length(asteroid.Asteroid[nr].zeit)<asteroid.Asteroid[nr].alter+1000 then exit;

  for i:=0 to l-1 do if nr=k.asteroid[i] then exit;

  setlength(k.asteroid,l+1);
  setlength(k.werte,l+1);
  k.asteroid[l]:=nr;
  k.werte[l]:=werte;
end;

procedure TKiZ.quicksortMin(an,en:integer);
var aa,ee:integer;
    m:integer;
    s:integer;
begin
  if en<an then exit;
  aa:=an;ee:=en;
  m:=k.werte[(an+en) shr 1];
  repeat
    while k.werte[an]<m do inc(an);
    while k.werte[en]>m do dec(en);
    if an<=en then begin
       s:=k.werte[an];k.werte[an]:=k.werte[en];k.werte[en]:=s;
       s:=k.asteroid[an];k.asteroid[an]:=k.asteroid[en];k.asteroid[en]:=s;
       inc(an);dec(en);
    end;
  until an>en;
  if en>aa then quicksortMin(aa,en);
  if an<ee then quicksortMin(an,ee);
end;


procedure TKiZ.sortMin;
begin
  if length(k.asteroid)<2 then exit;
  quicksortMin(0,length(k.asteroid)-1);
end;

procedure TKiZ.quicksortMax(an,en:integer);
var aa,ee:integer;
    m:integer;
    s:integer;
begin
  if en<an then exit;
  aa:=an;ee:=en;
  m:=k.werte[(an+en) shr 1];
  repeat
    while k.werte[an]>m do inc(an);
    while k.werte[en]<m do dec(en);
    if an<=en then begin
       s:=k.werte[an];k.werte[an]:=k.werte[en];k.werte[en]:=s;
       s:=k.asteroid[an];k.asteroid[an]:=k.asteroid[en];k.asteroid[en]:=s;
       inc(an);dec(en);
    end;
  until an>en;
  if en>aa then quicksortMax(aa,en);
  if an<ee then quicksortMax(an,ee);
end;


procedure TKiZ.sortMax;
begin
  if length(k.asteroid)<2 then exit;
  quicksortMax(0,length(k.asteroid)-1);
end;



procedure TKiZ.Idle;
var i:integer;
begin
  if (spiel.IdleCounter<>13)or(not schiff.detect) then exit;

  // letzten 4 kleinen
  if (asteroid.xanz<=4)and(asteroid.xanz>=1)and(spiel.levelZeit>200) then begin
     clear;
     for i:=1 to asteroid.Max do add(i,asteroid.Asteroid[i].groesse);
     sortMax;
     if (length(k.asteroid)>=1)and(length(k.asteroid)<=4)and(asteroid.Asteroid[k.asteroid[0]].groesse=asteroid_klein) then begin
        optimiere_ende:=true;
        if berechne then begin
           autoschuss:=false;
           optimiere_Richtung:=false;
           exit;
        end;
     end;
  end;
  if Mame.Daten<>0 then exit;


  // Kollison
  clear;
  for i:=0 to asteroid.Max do if (asteroid.Asteroid[i].active)and(asteroid.Asteroid[i].Treffer_Schritte<70)and(asteroid.Asteroid[i].Kollision>0)and(asteroid.Asteroid[i].Kollision<100) then add(i,asteroid.Asteroid[i].Kollision);
  if (length(k.asteroid)>=1) then begin
     for i:=0 to asteroid.Max do if (asteroid.Asteroid[i].active)and(asteroid.Asteroid[i].Treffer_Schritte<200)and(asteroid.Asteroid[i].Kollision>0)and(asteroid.Asteroid[i].Kollision<2000) then add(i,asteroid.Asteroid[i].Kollision);
     if (asteroid.Asteroid[0].active)and(asteroid.Asteroid[0].Treffer_Schritte<100)and(asteroid.Asteroid[0].groesse=Ufo_Klein) then add(0,40);
     if (length(k.asteroid)>4) then begin sortMin;setlength(k.asteroid,4);end;
     if berechne then begin
        autoschuss:=false;
        optimiere_Richtung:=false;
        exit;
     end;
   end;
  if Mame.Daten<>0 then exit;

  // Attrappen
  clear;
  for i:=0 to asteroid.Max do if (asteroid.Asteroid[i].atyp=Typ_attrappe)and(length(asteroid.Asteroid[i].Zeit)-70>asteroid.Asteroid[i].alter+asteroid.Asteroid[i].Treffer_Schuss) then add(i,asteroid.Asteroid[i].Treffer_Schuss);
  if (length(k.asteroid)>=1) then begin
     if (length(k.asteroid)>4) then begin sortMin;setlength(k.asteroid,4);end;
//     optimiere_Attrappe:=true;
      if berechne then begin
         autoschuss:=true;
         optimiere_Richtung:=true;
         exit;
      end;
  end;
  if Mame.Daten<>0 then exit;



 // letzten 4 Groen und Mittleren
  if (asteroid.xanz<=8)and(asteroid.xanz>=1)and(spiel.levelZeit>200) then begin
     clear;
     for i:=0 to asteroid.Max do if asteroid.Asteroid[i].groesse<>asteroid_klein then add(i,asteroid.Asteroid[i].groesse);
     if (length(k.asteroid)>=1)and(length(k.asteroid)<=4) then begin
        if length(k.asteroid)>4 then begin sortMax;setlength(k.asteroid,4);end;
        if berechne then begin
           autoschuss:=true;
           optimiere_Richtung:=true;
           exit;
        end;
     end;
  end;
  if Mame.Daten<>0 then exit;
{}
{ // letzten 4 Groen
 if (asteroid.xanz<=20)and(asteroid.xanz>=1)and(spiel.levelZeit>200) then begin
     clear;
     for i:=0 to asteroid.Max do if asteroid.Asteroid[i].groesse=asteroid_gross then add(i,asteroid.Asteroid[i].groesse);
     if (length(k.asteroid)>=1)and(length(k.asteroid)<=4) then begin
        if length(k.asteroid)>4 then begin sortMax;setlength(k.asteroid,4);end;
        if berechne then begin
           autoschuss:=true;
           optimiere_Richtung:=true;
           exit;
        end;
     end;
  end;
  if Mame.Daten<>0 then exit;
{}
    // letzten 5 kleinen
  if (asteroid.xanz=5)and(spiel.levelZeit>300) then begin
     clear;
     for i:=1 to asteroid.Max do add(i,asteroid.Asteroid[i].groesse);
     sortMax;
     if (length(k.asteroid)=5)and(asteroid.Asteroid[k.asteroid[0]].groesse=asteroid_klein) then begin
        optimiere_ende:=true;
        if berechne then begin
           autoschuss:=false;
           optimiere_Richtung:=false;
           exit;
        end;
     end;
  end;
  if Mame.Daten<>0 then exit;

{}

end;



function TKiZ.teste_ziel:boolean;
var i:integer;
begin
  if length(Reihenfolge)<1 then begin result:=false;exit;end;
  while (not asteroid.Asteroid[reihenfolge[0]].Active)or(asteroid.Asteroid[reihenfolge[0]].SchussCounter>0)or(asteroid.Asteroid[reihenfolge[0]].Treffer_Schritte>300)or(spiel.spielzeit+asteroid.asteroid[reihenfolge[0]].Treffer_schritte>spieldauer) do begin
      for i:=0 to length(reihenfolge)-2 do reihenfolge[i]:=reihenfolge[i+1];
      setlength(reihenfolge,length(reihenfolge)-1);
      if length(reihenfolge)<1 then begin result:=false;exit;end;
  end;
  result:=true;
end;

procedure TKiZ.Go;
var i:integer;
begin

  if not teste_ziel then exit;

  i:=reihenfolge[0];
  if i>=0 then begin
     ki.optimiere_Richtung:=optimiere_Richtung;
     ki.AutoSchuss:=autoschuss;
     if 4-schuss.anz>length(reihenfolge) then ki.AutoSchuss:=true;
     ki.ziel:=i;
  end;

end;

end.
