unit U_Asteroid;
interface
uses konstanten;

type TAsteroid = class(TObject)
  private
    procedure teste_Hyperspace;
    procedure Kollision_Ausweichrichtung_Vorhersage;
    procedure Kollisionsvorhersage;
    procedure setVorhersageUFO(max:integer);
    function SetMaxVorhersage(const max:integer):integer;
  protected
  public
var Active:boolean;
    detect:boolean;
    xx,yy,x0,y0,winkel,alter,groesse,id:integer;
    Atyp:Ttyp;
    SchussCounter,schussbegin:Integer;
    attrappe_Lebensdauer:integer;

    Treffer_Winkel,Treffer_Schritte,Treffer_Flug,Treffer_Wait,Treffer_Schuss:integer;
    Kollision,Kollision_Ausweichrichtung:integer;
    Zeit:array of TXY;
    constructor Create(const aID:integer);
    destructor Destroy; override;
    procedure Idle;
    procedure setVorhersage(max:integer;const testMaxVorhersage:boolean=true);
    procedure DatenBegin;
    procedure DatenEnde;
    procedure DatenNeu(const x,y,g:integer;const typ:TTyp);
    procedure DatenAdd(const x,y,g:integer;const typ:TTyp);
    procedure DatenUFO(const x,y,g:integer;const typ:TTyp);
    function DatenSuche(const x,y,g:integer;const typ:TTyp):boolean;
    procedure berechne_Treffer_Daten;
    function Schuss_richtungs_vorhersage(var schritte,flug,wait:integer):integer;overload;
    function Schuss_richtungs_vorhersage(const sw,plus:integer;var schritte,flug,wait:integer):integer;overload;

  end;

function OptimiereX(const x:integer):integer;inline;
function OptimiereY(const y:integer):integer;inline;
function isTreffer(const x1,y1,x2,y2,groesse:integer):boolean;inline

implementation
Uses Tools,U_Spiel,U_Key,U_Mame,U_Schiff,U_Schuss_Manager,U_UfoSchuss_Manager,U_Schuss,U_UfoSchuss,unit1,SysUtils,
      Windows, Messages,  Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;


constructor TAsteroid.Create(const aID:integer);
begin
  inherited Create;
  active:=false;
  id:=aid;
  setlength(zeit,0);
end;

destructor TAsteroid.Destroy;
begin

  inherited Destroy;
end;




procedure TAsteroid.Idle;
var i:integer;
    gef:boolean;
begin
  // Idle 0
  if (Mame.Daten=0)and(Spiel.IdleCounter=0)and(length(zeit)<alter+200) then setVorhersage(alter+260);

  // Idle 1
  if (Mame.Daten=0)and(Spiel.IdleCounter=1)and(length(zeit)<500)  then setVorhersage(520);

  // Idle3 berprfe Schuss
  if (Mame.Daten=0)and(Spiel.IdleCounter=3)and(schusscounter>0) then begin
     gef:=false;
     for i:=0 to schuss.Max do if (schuss.Schuss[i].Active)and(schuss.Schuss[i].obj=id)then begin gef:=true;break;end;
     if not gef then schusscounter:=-1; // schuss nicht gefunden
  end;





end;


procedure TAsteroid.Kollision_Ausweichrichtung_Vorhersage;
var i:integer;
begin
  for i:=alter to length(Zeit)-1 do
      if berechne_abstand2(Schiff.xx,schiff.yy,Zeit[i].x,Zeit[i].y)<=10*10 then exit;
  Kollision_Ausweichrichtung:=berechne_richtung_winkel(schiff.xx,schiff.yy,xx,yy);
end;




procedure TAsteroid.teste_Hyperspace;
begin
  if (Kollision>=0)and(Kollision<=HyperspaceTest+1) then begin key.HyperSpace;log('','Asteroid: HyperSpace ');exit;end;
end;

procedure TAsteroid.Kollisionsvorhersage;
var a,i,g2,s2:integer;
begin
  Kollision:=-1;
  Kollision_Ausweichrichtung:=-1;
  if not schiff.detect then exit;
  g2:=sqr(round(Groesse*1.15)+1);
  s2:=sqr(Schiff.Groesse);
  for i:=0 to 200 do begin
      if alter+i>=length(Zeit) then exit;
      a:=berechne_abstand2(Schiff.xx,schiff.yy,Zeit[alter+i].x,Zeit[alter+i].y)-g2;
      if a<=s2 then begin Kollision:=i;exit;end;
  end;
end;

function OptimiereX(const x:integer):integer;inline;
begin
  result:=x;
  while result<-512 do inc(result,1024);
  while result>=512 do dec(result,1024);
end;

function OptimiereY(const y:integer):integer;inline;
begin
  result:=y;
  while result<-384 do inc(result,768);
  while result>=384 do dec(result,768);
end;

function isTreffer(const x1,y1,x2,y2,groesse:integer):boolean;inline
var dx,dy:integer;
begin
  dy:=abs(optimiereY(y2-y1));
  dx:=abs(optimiereX(x2-x1));
  case groesse of
       Asteroid_Klein:  if (dy<=10)and(dx<=10)and(dx+dy<=15) then result:=true else result:=false;
       Asteroid_Mittel: if (dy<=17)and(dx<=17)and(dx+dy<=26) then result:=true else result:=false;
       Asteroid_Gross:  if (dy<=32)and(dx<=32)and(dx+dy<=48) then result:=true else result:=false;
       UFO_Klein:       if (dy<=10)and(dx<=10)and(dx+dy<=15) then result:=true else result:=false;
       UFO_Gross:       if (dy<=17)and(dx<=17)and(dx+dy<=26) then result:=true else result:=false;
       else             result:=sqr(dx)+sqr(dy)<sqr(groesse);
  end;
end;

procedure ermittel_SR_Xa_Xe(const SR:TSRZeile;const x,groesse:integer;var xa,xe:integer);
var A,E,h,ende:integer;
begin
  ende:=SR[SR_length].x;
  xa:=0;
  XE:=ende;
  if XE<2 then exit;
  A:=optimiereX(x-groesse+1);
  E:=optimiereX(x+groesse-1);
  if E<A then begin
// Berechnung mit berlauf
     h:=ende;
     while h>1 do begin
           h:=(h+1)shr 1;
           if (XA+h<=ende)and(SR[XA+h].x<a) then inc(XA,h);
     end;
     if (XA<ende)and(SR[XA].x<a) then inc(XA);

     h:=Xa;
     XE:=0;
     while h>1 do begin
        h:=(h+1)shr 1;
        if (XE+h<=ende)and(SR[XE+h].x<=e) then inc(XE,h);
     end;
     if (xe<ende)and(SR[Xe+1].x<=e) then inc(Xe);
     if (xe>0)and(SR[Xe].x>e) then dec(Xe);
     if (xa<xe) then xe:=-1;
     exit;
  end;

// richtige Berechnung
  h:=ende;
  while h>1 do begin
        h:=(h+1)shr 1;
        if (XA+h<=ende)and(SR[XA+h].x<a) then inc(XA,h);
  end;
  if (XA<ende)and(SR[XA].x<a) then inc(XA);

  h:=ende-Xa;
  XE:=XA;
  while h>1 do begin
        h:=(h+1)shr 1;
        if (XE+h<=ende)and(SR[XE+h].x<=e) then inc(XE,h);
  end;
  if (xe<ende)and(SR[Xe+1].x<=e) then inc(Xe);
  if SR[Xe].x>e then dec(Xe);
  if (xa>xe) then xe:=-1;
end;

function TAsteroid.Schuss_richtungs_vorhersage(const sw,plus:integer;var schritte,flug,wait:integer):integer;
var sx,sy,x,y,yy,z,schritt,alt:integer;
    xa,xe:integer;
    sr:^TSRZeile;
begin
  result:=sw;
  schritte:=500;
  flug:=0;
  wait:=500;

  sx:=Schiff.xx;
  sy:=Schiff.yy;
  for schritt:=0 to SR_Schritte-1 do begin
      alt:=alter+Schritt+plus+1;
      if alt>=length(Zeit) then exit;
      x:=Optimierex(Zeit[alt].x-sx);
      y:=Optimierey(Zeit[alt].y-sy);
      sr:=@SRTabelle[sw,schritt];
      ermittel_SR_Xa_Xe(sr^,x,groesse,xa,xe);

      if (xe>=0)and(xe>=xa) then begin // richtige Berechnung
         for z:=xa to xe do
             if isTreffer(x,y,SR[z].x,SR[z].y,groesse) then {treffer} begin schritte:=schritt;flug:=SR[z].flug;wait:=SR[z].wait;result:=SR[z].winkel;exit;end;
      end else
      if (xe>=0)and(xe<xa) then begin // Berechnung mit berlauf
         for z:=xa to SR[SR_length].x do
             if isTreffer(x,y,SR[z].x,SR[z].y,groesse) then {treffer} begin schritte:=schritt;flug:=SR[z].flug;wait:=SR[z].wait;result:=SR[z].winkel;exit;end;
         for z:=0 to xe do
             if isTreffer(x,y,SR[z].x,SR[z].y,groesse) then {treffer} begin schritte:=schritt;flug:=SR[z].flug;wait:=SR[z].wait;result:=SR[z].winkel;exit;end;
      end;
  end;
end;

function TAsteroid.Schuss_richtungs_vorhersage(var schritte,flug,wait:integer):integer;
begin
  result:=Schuss_richtungs_vorhersage(schiff.winkel,0,schritte,flug,wait);
end;


// ******** Trefferberechnung ******************************************
//     Treffer_Winkel,Treffer_Schritte,Treffer_Flug:integer;
procedure TAsteroid.berechne_Treffer_Daten;
begin
  if (not schiff.detect)or(schusscounter>0) then exit;
  Treffer_Winkel:=Schuss_richtungs_vorhersage(Treffer_Schritte,Treffer_Flug,Treffer_Wait);
  Treffer_Schuss:=Treffer_Schritte-Treffer_Flug;;
end;


procedure TAsteroid.setVorhersageUFO(max:integer);
var i:integer;
    dx,dy,start:integer;
begin
  if alter<1 then begin max:=2;dx:=0;dy:=0;end else begin
     dx:=Optimierex(Zeit[alter].x-Zeit[alter-1].x);
     dy:=Optimierey(Zeit[alter].y-zeit[alter-1].y);
  end;
  start:=length(zeit);
  setlength(zeit,max+1);
  for i:=start to max do begin
      zeit[i].x:=Optimierex(zeit[i-1].x+dx);
      zeit[i].y:=Optimierey(zeit[i-1].y+dy);
  end;
end;


function TAsteroid.SetMaxVorhersage(const max:integer):integer;
begin

  case alter of
       0..0:   result:=alter+2;
       1..3:   result:=alter+6;
       4..7:   result:=alter+20;
       8..9999:result:=alter+1300;
       else    result:=alter+2;
  end;
  if (groesse=Asteroid_Gross)and(alter<8) then result:=120;
  if ATyp=Typ_Attrappe then result:=200;
  if max<result then result:=max;
end;

procedure TAsteroid.setVorhersage(max:integer;const testMaxVorhersage:boolean=true);
var i:integer;
    dx,dy,start:integer;
begin
  if Atyp=Typ_UFO then begin setVorhersageUFO(max);exit;end;
  if testMaxVorhersage then max:=SetMaxVorhersage(max);
  if max<length(Zeit) then exit;

  start:=length(Zeit);
  setlength(zeit,max+1);
  if alter=0 then begin
     for i:=start to max do  begin
         Zeit[i].x:=XX;
         Zeit[i].y:=YY;
     end;
     exit;
  end;
  if alter>=8 then begin
     dx:=Optimierex(Zeit[alter].x-Zeit[alter-8].x);
     dy:=Optimierey(Zeit[alter].y-Zeit[alter-8].y);
     for i:=start to max do  begin
         Zeit[i].x:=OptimiereX(Zeit[i-8].x+dx);
         Zeit[i].y:=OptimiereY(Zeit[i-8].y+dy);
     end;
     exit;
  end;
  if alter<8 then begin
     dx:=Optimierex(Zeit[alter].x-Zeit[0].x);
     dy:=Optimierey(Zeit[alter].y-Zeit[0].y);
     for i:=start to max do  begin
         Zeit[i].x:=OptimiereX(xx+dx*(i-alter) div alter);
         Zeit[i].y:=OptimiereY(yy+dy*(i-alter) div alter);
      end;
  end;
end;


procedure TAsteroid.DatenBegin;
begin
  detect:=false;
  dec(SchussCounter,MameLatenz);
  if (alter+MameLatenz>=length(Zeit))and(ATyp<>Typ_Attrappe) then setVorhersage(alter+MameLatenz,false);
  inc(alter,MameLatenz);
  dec(attrappe_Lebensdauer,MameLatenz);
end;




procedure TAsteroid.DatenEnde;
begin
  if ATyp=Typ_Attrappe then begin
     if attrappe_Lebensdauer>0 then begin detect:=true;berechne_Treffer_Daten;end
                               else active:=false;
     exit;
  end;
  if not detect then begin active:=false;exit;end;
  if not schiff.detect then exit;

  Kollisionsvorhersage;
  teste_Hyperspace;
  berechne_Treffer_Daten;
end;

procedure TAsteroid.DatenNeu(const x,y,g:integer;const typ:TTyp);
begin
  detect:=true;
  active:=true;
  alter:=0;
  xx:=x;
  yy:=y;
  groesse:=g;
  Atyp:=typ;
  Kollision:=-1;
  SchussCounter:=-1;
  setlength(zeit,1);
  Zeit[0].x:=x;
  Zeit[0].y:=y;

  if (abs(spiel.levelZeit-165)<10)and(g=Asteroid_gross) then begin
     log('..\daten\level\neu_'+inttostr(spiel.level)+'.txt',inttostr(x)+';'+inttostr(y));
  end;



end;

procedure TAsteroid.DatenAdd(const x,y,g:integer;const typ:TTyp);
var i:integer;
begin
  detect:=true;
  xx:=x;
  yy:=y;
  if (Zeit[alter].x<>x)or(Zeit[alter].y<>y) then begin
     Zeit[alter].x:=x;
     Zeit[alter].y:=y;
     if MameLatenz>1 then for i:=1 to MameLatenz-1 do begin
        Zeit[alter-i].x:=x-i*(x-Zeit[alter-MameLatenz].x)div MameLatenz;
        Zeit[alter-i].y:=y-i*(y-Zeit[alter-MameLatenz].y)div MameLatenz;
     end;
     setlength(Zeit,alter+1);
  end;
  if length(Zeit)<alter+100 then setVorhersage(alter+120);
end;


function test_abstand(const x,y,xx,yy,a:integer):boolean;inline;
begin
  result:=abs(optimiereX(x-xx))+abs(optimiereY(y-yy))<=a;
end;

function TAsteroid.DatenSuche(const x,y,g:integer;const typ:TTyp):boolean;
var xx,yy:integer;
begin
  if (g<>groesse)or(Atyp<>typ) then begin result:=false;exit;end;
  xx:=Zeit[alter].x;
  yy:=Zeit[alter].y;
  if (x=xx)and(y=yy)then begin result:=true;exit;end;

  if alter<=1 then begin
     if test_abstand(x,y,xx,yy,10) then begin result:=true;exit;end;
  end else begin
     if test_abstand(x,y,xx,yy,3) then begin result:=true;exit;end;
  end;
  result:=false;
end;

procedure TAsteroid.DatenUFO(const x,y,g:integer;const typ:TTyp);
begin
      if (active)and(schusscounter>0)and(length(Zeit)>alter)and((Zeit[alter].x<>x)or(Zeit[alter].y<>y)) then schusscounter:=-1; // bei neuer richtung schusscounter zurcksetzen
      if Active then DatenAdd(x,y,g,typ) // UFO ist bereits da
                else DatenNeu(x,y,g,typ); // Neu
end;







end.
