// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Harald Boegeholz / Rammi
//
// Copyright Notice:   (c) Original C++ code: Harald Boegeholz (c't)
//                     (c) Java port: 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;

/**
 *  Sample player quite similar to the one programmed by Harald Boegeholz.
 *
 *  It does not use threading, but instead calculates everything in the frameReceived() method and so
 *  runs in the communication thread. Usually it's preferable to make the calculations in an own thread,
 *  so the communication thread is just doing communication.
 *
 *  Meanwhile I added the enhancement thrust is no longer pressed if no target is available.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class SampleAsteroidPlayer
  implements FrameListener,
             GameData
{
	
  private static int distenceFactor = 3000;
  private static int rotationFactor = 30;
  private static int AstBulletFactor= 2000000;
  private static int directionToShotDM = 500;
  private static int directionToShot = 20000;
  private static int directionToShotSave = 5000;
  private static int maxTargetDistence = 800;
  private static int ufoPrioFactor = 50000;
  private static int minBulletsOnSceen = 0;
  private static int safeAsteroidFactor = 0;
  private static int bulletSpeed = 8;
  private static int bulletLifeTime = 70;
  private static int hyperDirectionMin = 3000;
  private static int hyperDirectionMax = 100000;
  private static int hyperBullets = 3;
  private static int hyperSizeMin = 31;
  private static int hyperSizeMax = 34;
  private static int bulletSeekSize = 11;
  private static int bulletSeekFactor = 8;
  private static double shipWinkel = 4.21875;
  private static boolean ufoCamping= false;
  private static int scoreToCamp = 30000;
	
  /** Switch between shooting and not shooting. */
  private boolean shot;
  /** The communication object. */
  private Communication com;

  /**
   *  Constructor.
   *  @param com communications object for key sending
   */
  public SampleAsteroidPlayer(Communication com)
  {
    this.com = com;
    com.setFramePreparer(new FramePreparerSequence(new SimpleVelocityPreparer(),
                                                   new ScoreFixer()));
    com.addFrameListener(new HallOfFameFiller(com, "bo"));
  }

  /**
   *  Called each time a frame is received.
   *
   *  <b>ATTENTION:</b> this is called from the communication thread!
   *  Implementing classes must be aware of this and take care by synchronization or similar!
   *  @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    if (frame != null) {
      // this is basically Harald's algorithm
      SpaceShip ship = frame.getSpaceShip();
      
      boolean doShot= true;
      int direction=-1;
      int unsignedDirection=-1;
      int frameInFuture=-1;
      
      if (ship != null) {
        MovingGameObject target = findNearestTarget(ship, frame);
        if (target == null) {
          if(!ufoCamping || frame.getScore() < scoreToCamp)
          {
	          if (frame.getTargetCount() > 0) {
	            com.pushButton(BUTTON_THRUST);
	          }
	          else
	          {
	        	  com.pushButton(BUTTON_LEFT);
	        	  doShot = false;
	          }
          }
          else
          {
        	  doShot = false;
          }
        }
        else {
          
          
          frameInFuture = 1; //ship.getSquaredDistance(target)/distenceFactor;
        	
          Point delta = ship.getDelta(target);
          
          MovingGameObject nearestObject= findRealNearestTarget(ship,frame);
          
          Point delta2;
          if(nearestObject!=null)
        	  delta2= ship.getDelta(nearestObject);
          else
        	  delta2= delta;
          
          int dist2 = delta2.x*delta2.x + delta2.y*delta2.y;

          
          //System.out.println("0)"+delta.x+":"+delta.y);

          while(delta.x*delta.x+delta.y*delta.y > (bulletSpeed*frameInFuture+bulletSpeed/2)*(bulletSpeed*frameInFuture+bulletSpeed/2) && frameInFuture<bulletLifeTime)
          {
        	delta = ship.getDelta(target,frameInFuture);
            //System.out.println(frameInFuture+")"+delta.x+":"+delta.y+":"+delta.x+":"+delta.y);
        	frameInFuture++;
          }        	  

          //System.out.println(target.getVxd()+":"+target.getVyd()+"|"+target.getVelocityX()+":"+target.getVelocityY());
          
          //System.out.println(frameInFuture+":"+delta.getX()*delta.getY()+":"+ship.getSquaredDistance(delta));
        
          direction= ship.getDirX() * delta.y - ship.getDirY() * delta.x;
          unsignedDirection= direction < 0 ? -direction : direction;
          
          
          MovingGameObject enemyBullet= findNearestBullet(ship, frame);
          Point enemyBulletDelta;
          int enemyBulletDist=-1;
          if(enemyBullet != null)
          {
        	  enemyBulletDelta= ship.getDelta(enemyBullet);
        	  enemyBulletDist= enemyBulletDelta.x*enemyBulletDelta.x+enemyBulletDelta.y*enemyBulletDelta.y;
          }
          
/*          
          if (    dist2 < hyperSizeMin*hyperSizeMin
        		  ||
        		  enemyBulletDist!=-1 && enemyBulletDist < (hyperSizeMin*hyperSizeMin)
        		  //(dist2 < hyperSizeMin*hyperSizeMin && ( unsignedDirection > hyperDirectionMin || frame.getBulletCount() > hyperBullets ) )
        		  //||
        		  //(dist2 < hyperSizeMax*hyperSizeMax && unsignedDirection > hyperDirectionMax)
        	 )
          {
            com.pushButton(BUTTON_HYPERSPACE);
          }
*/
    	  /* HyperSpace detection */
    	  if(
    			  needHyperSpace(ship,frame)
    			  ||
    			  (enemyBulletDist!=-1 && enemyBulletDist < (hyperSizeMin*hyperSizeMin))
    		)
    	  {
              com.pushButton(BUTTON_HYPERSPACE);
              return;
    	  } // Ende Hyperspace

          else {
        	  
        	  
        	  //  (atan(delta) - atan(directin)) * 180/pi 
            if( unsignedDirection > directionToShot )
              doShot = false;
            
            if( unsignedDirection > directionToShotDM || !shot )
            {
                if (direction > 0) {
                    com.pushButton(BUTTON_LEFT);
                  }
                  else {
                    com.pushButton(BUTTON_RIGHT);
                  }
            }

          }
        }
        if( frame.getBulletCount() < minBulletsOnSceen )
            doShot = true;
        
        if( !doShot && shot )
            shot = false;
        
        
/*        if(shot && unsignedDirection < directionToShotSave && unsignedDirection != -1)
        {

        	for (Asteroid ast: frame.getAsteroids()) {
        		
        		if( ast.x == target.x && ast.y == target.y && ast.getSize() == target.getSize())
        		{
        			//System.out.println("-"+target.getMyBulletLifeTime());
        			ast.setMyBulletLifeTime(frameInFuture);
        			break;
        		}
        		
        	}

            //System.out.println("-"+target.getMyBulletLifeTime());
        }
*/        
        
        
        com.setButton(BUTTON_FIRE, shot);
        shot = !shot;
      }
    }
  }

  /**
   *  Find the nearest target. Everything farer away than 400 pixel is considered to be in infinity.
   *  @param ship ship info
   *  @param info frame info
   *  @return nearest target or <code>null</code> if there is no target near enough
   */
  private static MovingGameObject findNearestTarget(SpaceShip ship, FrameInfo info)
  {
	    
	if( ufoCamping && info.getAsteroidCount() == 1 && info.getScore() > scoreToCamp)
		return info.getUfo();;

	
    MovingGameObject nearest = null;
    int minDist2 = maxTargetDistence*maxTargetDistence;
    for (Asteroid ast: info.getAsteroids()) {
    	
      Point delta = ship.getDelta(ast);
      int rotationNeed = (int)(ship.getDirX() * delta.y - ship.getDirY() * delta.x)/rotationFactor;    
      if(rotationNeed<0)
  	    rotationNeed *= -1;
      
      int dist2 = ship.getSquaredDistance(ast) - ast.getSquaredSize() + rotationNeed;
      
      if(ship.getSquaredDistance(ast) > ship.getSquaredDistanceInNextFrame(ast))
        dist2 += safeAsteroidFactor;
      

      MovingGameObject enemyBullet= findNearestBullet(ast, info);
      Point enemyBulletDelta;
      int enemyBulletDist=-1;
      
      
    		  
      /*if(enemyBullet != null)
      {
    	  enemyBulletDelta= ast.getDelta(enemyBullet);
    	  enemyBulletDist= enemyBulletDelta.x*enemyBulletDelta.x+enemyBulletDelta.y*enemyBulletDelta.y;
      }
      */
      int frameInFuture= 1;
      
      if( enemyBullet != null /*&& ast.getSize() == 8*/ )
      {
    	  enemyBulletDelta =  ast.getDelta(enemyBullet);
    	  enemyBulletDist= enemyBulletDelta.x*enemyBulletDelta.x+enemyBulletDelta.y*enemyBulletDelta.y;
    	  
          while(enemyBulletDist > ((bulletSeekSize+(ast.getSize()/bulletSeekFactor))*(bulletSeekSize+(ast.getSize()/bulletSeekFactor))) && frameInFuture<bulletLifeTime)
          {
        	enemyBulletDelta =  ast.getDelta(enemyBullet,frameInFuture);
        	enemyBulletDist= enemyBulletDelta.x*enemyBulletDelta.x+enemyBulletDelta.y*enemyBulletDelta.y;
            //System.out.println(frameInFuture+")"+delta.x+":"+delta.y+":"+delta.x+":"+delta.y);
        	frameInFuture++;
          }      
          
          //System.out.println(enemyBulletDist);
          
          if(enemyBulletDist!=-1 && ufoCamping && info.getAsteroidCount() > 2 && enemyBulletDist < ((bulletSeekSize+(ast.getSize()/bulletSeekFactor))*(bulletSeekSize+(ast.getSize()/bulletSeekFactor))) )
          {
        	dist2+= AstBulletFactor;
        	//System.out.println("Found!");
          }
      }

      
      if (dist2 < minDist2) {
        minDist2 = dist2;
        nearest  = ast;
      }
    }
    
    Ufo ufo = info.getUfo();
    if (ufo != null) {
      int dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize() - ufoPrioFactor;
      if (dist2 < minDist2) {
        nearest  = ufo;
      }
    }
    //System.out.println("Nearest: "+nearest);
    return nearest;
  }
  
  private static MovingGameObject findNearestBullet(SpaceShip ship, FrameInfo info)
  {
    MovingGameObject nearest = null;
    int minDist2 = maxTargetDistence*maxTargetDistence;
    for (Bullet bull: info.getBullets()) {
    	
      Point delta = ship.getDelta(bull);
      Point delta2 = ship.getDelta(bull,1);
      
      if(delta.x*delta.x+delta.y*delta.y > delta2.x*delta2.x+delta2.y*delta2.y )
      {
          int dist2 = ship.getSquaredDistance(bull);
          if (dist2 < minDist2) {
            minDist2 = dist2;
            nearest  = bull;
          }    	  
      }

    }
    return nearest;
  }
  
  private static MovingGameObject findNearestBullet(Asteroid asti, FrameInfo info)
  {
    MovingGameObject nearest = null;
    int minDist2 = maxTargetDistence*maxTargetDistence;
    for (Bullet bull: info.getBullets()) {
    	
      Point delta = asti.getDelta(bull);
      Point delta2 = asti.getDelta(bull,1);
      
      if(delta.x*delta.x+delta.y*delta.y > delta2.x*delta2.x+delta2.y*delta2.y )
      {
          int dist2 = asti.getSquaredDistance(bull);
          if (dist2 < minDist2) {
            minDist2 = dist2;
            nearest  = bull;
          }    	  
      }

    }
    return nearest;
  }
  
  private static MovingGameObject findRealNearestTarget(SpaceShip ship, FrameInfo info)
  {
    MovingGameObject nearest = null;
    int minDist2 = maxTargetDistence*maxTargetDistence;
    for (Asteroid ast: info.getAsteroids()) {
      //int dist2 = ship.getSquaredDistance(ast) - ast.getSquaredSize();
      int dist2 = (int)(Math.pow(Math.sqrt(ship.getSquaredDistance(ast)) - Math.sqrt(ast.getSquaredSize()), 2)); 
      if (dist2 < minDist2) {
        minDist2 = dist2;
        nearest  = ast;
      }
    }
    Ufo ufo = info.getUfo();
    if (ufo != null) {
    //int dist2 = ship.getSquaredDistance(ufo) - ufo.getSquaredSize();
    int dist2 = (int)(Math.pow(Math.sqrt(ship.getSquaredDistance(ufo)) - Math.sqrt(ufo.getSquaredSize()), 2));
    if (dist2 < minDist2) {
        nearest  = ufo;
      }
    }
    //System.out.println("Nearest: "+nearest);
    return nearest;
  }
  /**
   * 
   * @return
   */
  private static boolean needHyperSpace(SpaceShip ship, FrameInfo info)
  {
    for (Asteroid ast: info.getAsteroids()) {
    	if( ship.isOverlappingWith(ast.getBounds(1)) )
    	{
    		return true;
    	}
      }
    for (Bullet bull: info.getBullets()) {
    	if( ship.isOverlappingWith(bull.getBounds(1)) )
    	{
    		return true;
    	}
      }
    Ufo ufo = info.getUfo();
    if (ufo != null) {
    	if( ship.isOverlappingWith(ufo.getBounds(1)) )
    	{
    		return true;
    	}
    }
	return false; 
  }  
}
