/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.TimeLine;
import de.caff.util.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class KeyInfoDisplay
extends JPanel
implements GameData {
    private static final BooleanRenderer KEY_RENDERER = new BooleanRenderer();
    private static final String[] COLUMNS = new String[]{"Ping", "Timestamp (ms)", "Time to Frame (ms)", "<FIRE>", "<HYPER>", "<THRUST>", "<LEFT>", "<RIGHT>", "<START>"};
    private JTable keyTable;

    public KeyInfoDisplay(final TimeLine timeLine) {
        this.setLayout(new BorderLayout());
        this.keyTable = new JTable();
        this.keyTable.setAutoResizeMode(2);
        this.add((Component)new JScrollPane(this.keyTable), "Center");
        this.setMinimumSize(new Dimension(400, 100));
        this.setPreferredSize(this.getMinimumSize());
        this.setFrom(timeLine.getCurrentInfo());
        timeLine.addFrameListener(new FrameListener(){

            @Override
            public void frameReceived(FrameInfo frame) {
                KeyInfoDisplay.this.setFrom(timeLine.getCurrentInfo());
            }
        });
        this.setBorder(BorderFactory.createTitledBorder("Buttons"));
    }

    private void setFrom(FrameKeyInfo info) {
        if (info != null) {
            List<FrameKeyInfo.ButtonInfo> buttons = info.getButtons();
            Object[][] data = new Object[buttons.size()][9];
            int row = 0;
            for (FrameKeyInfo.ButtonInfo buttonInfo : buttons) {
                data[row][0] = Tools.byteToUnsigned(buttonInfo.getPingID());
                data[row][1] = buttonInfo.getTimestamp();
                data[row][2] = buttonInfo.getTimestamp() - info.getFrameInfo().getReceiveTime();
                data[row][3] = buttonInfo.getButtons().isFirePressed();
                data[row][4] = buttonInfo.getButtons().isHyperspacePressed();
                data[row][5] = buttonInfo.getButtons().isThrustPressed();
                data[row][6] = buttonInfo.getButtons().isLeftPressed();
                data[row][7] = buttonInfo.getButtons().isRightPressed();
                data[row][8] = buttonInfo.getButtons().isStartPressed();
                ++row;
            }
            this.keyTable.setModel(new DefaultTableModel(data, COLUMNS));
            int c = 3;
            while (c < COLUMNS.length) {
                this.keyTable.getColumnModel().getColumn(c).setCellRenderer(KEY_RENDERER);
                ++c;
            }
            if (this.keyTable.getAutoResizeMode() != 0) {
                this.keyTable.setAutoResizeMode(0);
                c = 0;
                while (c < COLUMNS.length) {
                    this.keyTable.sizeColumnsToFit(c);
                    ++c;
                }
            }
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }
}

