/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collection;

public abstract class MovingGameObject
extends GameObject {
    protected static final boolean WATCH_VELOCITIES = false;
    private static int minY = Integer.MAX_VALUE;
    private static int maxY = Integer.MIN_VALUE;
    private static final int ARROW_HEAD_SIZE = 8;
    private static final GeneralPath ARROW_HEAD = new GeneralPath();
    private int vx;
    private double vxd;
    private int vy;
    private double vyd;
    private int myLifeTime;
    private int myBulletLifeTime;

    static {
        ARROW_HEAD.moveTo(0.0f, 0.0f);
        ARROW_HEAD.lineTo(-8.0f, 8.0f);
        ARROW_HEAD.lineTo(-8.0f, -8.0f);
        ARROW_HEAD.closePath();
    }

    protected MovingGameObject(int x, int y) {
        super(x, y);
    }

    public Point getCenter() {
        return new Point(this.x, this.y);
    }

    public abstract int getSize();

    public void draw(Graphics2D g) {
        g.setColor(Color.white);
        int size = this.getSize();
        g.drawOval(this.x - size, this.y - size, 2 * size, 2 * size);
        this.drawVelocityVector(g, Color.red);
    }

    public Point getDelta(MovingGameObject obj) {
        int dx = obj.x - this.x;
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = obj.y - this.y;
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return new Point(dx, dy);
    }

    public Point getDelta(MovingGameObject obj, int framesInFuture) {
        int dx = (int)((double)obj.x + obj.getVxd() * (double)framesInFuture - (double)this.x);
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = (int)((double)obj.y + obj.getVyd() * (double)framesInFuture - (double)this.y);
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return new Point(dx, dy);
    }

    public int getSquaredSize() {
        int size = this.getSize();
        return size * size;
    }

    public void setVelocity(int x, int y) {
        this.vx = x;
        this.vy = y;
    }

    public void setVelocity(Point v) {
        this.setVelocity(v.x, v.y);
    }

    public void setVelocityFromDelta(MovingGameObject obj) {
        if (obj != null) {
            this.setVelocity(obj.getDelta(this));
            this.setMyLifeTime(obj.getMyLifeTime());
            this.setVxd(obj.getVxd());
            this.setVyd(obj.getVyd());
            if (this.getMyLifeTime() < 1) {
                this.vxd = this.vx;
                this.vyd = this.vy;
            }
        }
    }

    public void setVelocityDoubles() {
        if (this.myLifeTime > 0) {
            this.vxd = (this.vxd * (double)this.myLifeTime + (double)this.vx) / (double)(this.myLifeTime + 1);
            this.vyd = (this.vyd * (double)this.myLifeTime + (double)this.vy) / (double)(this.myLifeTime + 1);
            ++this.myLifeTime;
        } else {
            this.myLifeTime = 1;
            this.vxd = this.vx;
            this.vyd = this.vy;
        }
    }

    public int getVelocityX() {
        return this.vx;
    }

    public int getVelocityY() {
        return this.vy;
    }

    public Point getVelocity() {
        return new Point(this.vx, this.vy);
    }

    public double getVelocityAngle() {
        return this.vx != 0 || this.vy != 0 ? Math.atan2(this.vy, this.vx) : -Math.PI;
    }

    public boolean hasKnownVelocity() {
        return this.vx != 0 || this.vy != 0;
    }

    protected void drawVelocityVector(Graphics2D g, Color color) {
        if (this.vx != 0 || this.vy != 0) {
            int scale = 16;
            g.setColor(color);
            g.drawLine(this.x, this.y, this.x + scale * this.vx, this.y + scale * this.vy);
            double angle = Math.atan2(this.vy, this.vx);
            AffineTransform at = AffineTransform.getTranslateInstance(this.x + scale * this.vx, this.y + scale * this.vy);
            at.concatenate(AffineTransform.getRotateInstance(angle));
            g.fill(at.createTransformedShape(ARROW_HEAD));
        }
    }

    public Rectangle getBounds(int framesInFuture) {
        Point center = this.hasKnownVelocity() ? new Point(this.x + this.vx * framesInFuture, this.y + this.vy * framesInFuture) : this.getCenter();
        int size = this.getSize();
        return new Rectangle(center.x - size, center.y - size, 2 * size, 2 * size);
    }

    @Override
    public Rectangle getBounds() {
        Point center = this.getCenter();
        int size = this.getSize();
        return new Rectangle(center.x - size, center.y - size, 2 * size, 2 * size);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("Size", this.getSize()));
        props.add(new Property<Rectangle>("Bounds", this.getBounds()));
        props.add(new Property<Point>("Velocity", this.getVelocity()));
        return props;
    }

    public double getVxd() {
        return this.vxd;
    }

    public double getVyd() {
        return this.vyd;
    }

    public void setVxd(double vxd) {
        this.vxd = vxd;
    }

    public void setVyd(double vyd) {
        this.vyd = vyd;
    }

    public int getMyLifeTime() {
        return this.myLifeTime;
    }

    public void setMyLifeTime(int lifeTime) {
        this.myLifeTime = lifeTime;
    }

    public int getMyBulletLifeTime() {
        return this.myBulletLifeTime;
    }

    public void setMyBulletLifeTime(int myBulletLifeTime) {
        this.myBulletLifeTime = myBulletLifeTime;
    }
}

