/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;

public class FrameDisplay
extends JComponent
implements FrameListener,
GameData {
    private FrameInfo frameInfo;
    private AffineTransform trafo;

    public FrameDisplay(int width) {
        Dimension size = new Dimension(width, 3 * width / 4);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        double scaling = (double)width / 1024.0;
        this.trafo = AffineTransform.getTranslateInstance(0.0, -896.0);
        this.trafo.preConcatenate(AffineTransform.getScaleInstance(scaling, -scaling));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        FrameInfo info;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            info = this.frameInfo;
        }
        if (info != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            Text.setFontRenderContext(((Graphics2D)g).getFontRenderContext());
            g2.transform(this.trafo);
            info.draw(g2);
            Point pos = new Point();
            if (!info.isGameRunning()) {
                g.setColor(new Color(255, 255, 0, 128));
                Point2D.Double pos0 = new Point2D.Double(0.0, 0.0);
                Point2D.Double pos1 = new Point2D.Double(0.0, 1.0);
                this.trafo.transform(pos0, pos0);
                this.trafo.transform(pos1, pos1);
                float fontScale = (float)Math.abs(((Point2D)pos0).getY() - ((Point2D)pos1).getY());
                for (Text txt : info.getTexts()) {
                    this.trafo.transform(txt.getLocation(), pos);
                    Font font = txt.getFont();
                    g.setFont(font.deriveFont(fontScale * font.getSize2D()));
                    g.drawString(txt.getText(), pos.x, pos.y);
                }
            }
            g.setColor(new Color(255, 255, 255, 128));
            this.trafo.transform(FrameInfo.SCORE_LOCATION_GAME, pos);
            g.drawString(String.format("%7d", info.getScore()), pos.x, pos.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameReceived(FrameInfo frame) {
        FrameDisplay frameDisplay = this;
        synchronized (frameDisplay) {
            this.frameInfo = frame;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GameObject> pickAt(Point p, int pickRadius) {
        Point min = new Point(p.x - pickRadius, p.y + pickRadius);
        Point max = new Point(p.x + pickRadius, p.y - pickRadius);
        AffineTransform inverse = new AffineTransform(this.trafo);
        try {
            inverse.invert();
            inverse.transform(min, min);
            inverse.transform(max, max);
            Rectangle hitRect = new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y);
            FrameDisplay frameDisplay = this;
            synchronized (frameDisplay) {
                return this.frameInfo.getOverlappingObjects(hitRect);
            }
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    protected AffineTransform getTrafo() {
        return this.trafo;
    }
}

