#ifndef GameState_h_
#define GameState_h_

#include <list>
#include <string>
#include <stdint.h>
#include "FrameData.h"

using namespace std;
class KeysPacket;


// all cooordindates in internal coordinates (= 8*screencoordinates)
class GSObject
{
public:
    GSObject() { clear(); }
    void clear()
    {
	valid = false;
	orig_x = 0;
	orig_y = 0;
	cur_x = 0;
	cur_y = 0;
	vx = 0;
	vy = 0;
	vxvyValid = false;
	vxvyExact = false;
	anglebyte = 0;
	anglebyteValid = false;
	catchdist = 0;
	starttime = 0;
	fromSaucer = false;
	fromSaucerValid = false;
	ship_vx = 0;
	ship_vy = 0;
	type = 0;
	sf = 0; 
	isSaucer = false;
	score = 0;
	ignoreUntil = 0;
    }
    
    // predict one step
    void predictStep(uint32_t timestamp = 0xffffffff);
    
    // main valid flag
    // if this is false the whole container is unused
    bool valid;

    // coordinates of first apperance
    int orig_x;
    int orig_y;
    
    // current coordinates
    int cur_x;
    int cur_y;
    
    // speed vector
    int vx;
    int vy;
    bool vxvyValid; // after 1 frame
    bool vxvyExact; // after 8 frames
    
    // direction of speed vector 0..255
    int anglebyte;
    bool anglebyteValid;
    
    // radius which is sufficient to identify object from frame to frame
    int catchdist; // square of distance in internal coordinates
    
    // time when shot first appears
    uint32_t starttime; 
    
    // true == shot is from saucer
    bool fromSaucer;
    bool fromSaucerValid;

    // only for shots: speed vector of ship at time of start
    int ship_vx;
    int ship_vy;
    
    // only for asteroids:
    
    // outer apperance
    int type;
    
    // scale factor: 0 = gro, 15 = mittel, 14 = klein
    int sf;
    
    bool isSaucer;
    int score;
    string name;
    uint32_t ignoreUntil;
};


class GameState
{
public:
    // public data

    // this state belongs to this time
    uint32_t timestamp; 
    
    // timeout (absolute timestamp of timeout) for certain states
    uint32_t timeout; 
    
    // global game state
    enum 
    { 
	CALIBRATE_ANGLEBYTE_WAIT_FOR_SHIP,
	CALIBRATE_ANGLEBYTE_WAIT_FOR_NO_SHOT,
	CALIBRATE_ANGLEBYTE_FIRE,
	CALIBRATE_ANGLEBYTE_WAIT_FOR_SHOT,
	CALIBRATE_ANGLEBYTE_TRACK,
	TURN,
	WAIT_AND_FIRE,
	WAIT_FOR_TARGET,
	FIGHT 
    } state;
    
    // list of asteroids
    GSObject asteroids[MAX_ASTEROIDS];
    // next asteroid slot to use
    int nextAsteroidIndex;
    
    // list of shots
    GSObject shots[MAX_SHOTS];
    // next shot slot to use
    int nextShotIndex;
    list<int> shotAngles;
    
    // ship
    GSObject ship;

    // saucer
    GSObject saucer;

    // fire logic
    bool fireActive; // true if fire is high
    bool doNotFire;  // true if fire is low during this frame in getKeys()
    
    // more state
    int targetAnglebyte;
    int turnDir; // -3 or +3
    uint32_t targetWait;
    GSObject *target;

    
public:
    // public methods
    GameState();
    void predict(uint32_t newtimestamp);
    void updateFromFrameData(const FrameData &frameData);
    void getKeys(KeysPacket &keysPacket);    

private:
    void predict();
    void predictShots();
    void predictAsteroids();
    void predictShip();
    void predictSaucer();
    void updateShots(const FrameData &frameData);
    void updateAsteroids(const FrameData &frameData);
    void updateShip(const FrameData &frameData);
    void updateSaucer(const FrameData &frameData);
    bool needHyperspace();
    int getFreeShots();
    void setupNext();
    GSObject *findNextTarget();
    bool calcTarget();
    int simDist(int angle, int wait, const GSObject &obj_, int steps);
};




#endif
