package hek.de.hinni.hek.asteroids;


/**
 * The <code>Ship</code> class represents the players space ship.
 * <p>
 * An space ship has a position and an orientation.
 * @see GameStatus
 */
public class Ship extends Position {
	//orientation given screen
	protected Vector orientation;
	//computed by input

	//both variables are checked against each other in case of packet loss
	
	/**
	 * Initializes a new space ship with given position and orientation.
	 *
	 * @param x
	 *        x-coordinate
	 *
	 * @param y
	 *        y-coordinate
	 *
	 * @param dx
	 *        orientation x-component
	 *
	 * @param dy
	 *        orientation y-component
	 */
	public Ship(int x, int y, int dx, int dy, int tick) {
		super(x, y, tick,tick,Integer.MAX_VALUE,
				Position.TYPE.SHIP,MyShip.RADIUS_INNER,MyShip.RADIUS_OUTER,false);
		orientation = new Vector(dx, dy, Float.NaN,Integer.MAX_VALUE,1f);
	}

	/**
	 * Returns the space ships orientation.
	 *
	 * @return the orientation
	 */
	public Vector getOrientation() {
		return orientation;
	}

	/**
	 * Sets the space ships orientation.
	 *
	 * @param orientation
	 * 			the orientation
	 */
	public void setOrientation(Vector orientation) {
		this.orientation = orientation;
	}
	
	
	
	
}
