package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;

//import org.apache.log4j.Logger;

public class MyAsteroid extends MyObject {
	
	public enum SIZE_INNER {
		SMALL(8*8), MIDDLE(16*8), BIG(32*8);
		private int value;
		public int getValue() {
			return value;
		}
		SIZE_INNER(int i) {
			value = i;
		}
	}
	public enum SIZE_OUTER {
		SMALL(10*8), MIDDLE(19*8), BIG(36*8);
		private int value;
		public int getValue() {
			return value;
		}
		SIZE_OUTER(int i) {
			value = i;
		}
	}
	
	public static final float AST_DCERTAINTY_BIG=-(1f/10);
	public static final float AST_DCERTAINTY_MED=-(1f/7);
	public static final float AST_DCERTAINTY_SMALL=-(1f/4);
	
//	public static final Logger logger = Logger.getLogger(MyAsteroid.class);
	private static final Color COLOR = Color.black;
	private static final Color COLOR_PROBABILISTIC = Color.blue;
	
	public static final int MAXBIGASTEROIDS = 26;
	public static final int MAXASTEROIDSPEED = (int)Math.round(Math.sqrt((4*8)*(4*8)+(4*8)*(4*8)));
	
	
	private FireSolution creationEvent; //wann weg?

	

	/**
	 * 
	 * @return 1 = SMALL, 2= MIDDLE, 3 = BIG, Error = -1
	 */
	public int getGroesseID() {
		
		if (getRadius_inner()==SIZE_INNER.SMALL.value) return 1;
		if (getRadius_inner()==SIZE_INNER.MIDDLE.value) return 2;
		if (getRadius_inner()==SIZE_INNER.BIG.value) return 3;
		
		return -1;
	}
	

	public MyAsteroid(Asteroid a) {
		super(a,null,a.getSize_inner(), a.getSize_outer(),true);
		//set default draw color
		setDrawColor(COLOR);
	}
	
	//copy constructor (flat copy)
	public MyAsteroid(MyAsteroid a)
	{
		super(a);
		//flat child copy
		creationEvent = a.creationEvent;
		
	}
	
	/**
	 * drecreses size of the asteroid by one
	 */
	private void decreaseSize()
	{
		if (getGroesseID()==3)
		{
			setRadius_inner(SIZE_INNER.MIDDLE.getValue());
			setRadius_outer(SIZE_OUTER.MIDDLE.getValue());
			return;
		}
		if (getGroesseID()==2)
		{
			setRadius_inner(SIZE_INNER.SMALL.getValue());
			setRadius_outer(SIZE_OUTER.SMALL.getValue());
			return;
		}
	}
	
	//creates a child (ie same dir & pos) 
	//size is decreased, 
	//sets creation event
	//returns null, if there is no child anymore
	public MyAsteroid makeChild(FireSolution f,boolean collidingChild)
	{
		if (!canBreakApart()) return null;
		if (!f.isConsistent())
		{
//			logger.warn("is not consistent "+this.getId()+f);
			return null;
		}
		
		MyAsteroid ret = new MyAsteroid(this);
		
		ret.setNewID();
		
		//decrease size
		ret.decreaseSize();
		
		ret.creationEvent = f;
		
		Position newPos;
		Vector newBew;

		
		if (collidingChild)
		{
			//erzeug ein kind, dass nicht verschwindet und dass mit dem schiff kollidiert
			//lebt ab hittime outer unbegrenzt
			//position ist hittiminner von parent
			//richtung ist richtung schiff bei hittimeinner
			//keine uncertaintiy

			//set the time borders
			Position p = estimatePosition(f.getHitTimeInner());
			Position s = f.getFireState().
							estimatePosition(f.getHitTimeInner());
			
			newPos = new Position(
					p.getX(),
					p.getY(),
					p.getZeitpunkt(),
					f.getHitTimeOuter(),
					Integer.MAX_VALUE,
					Position.TYPE.ASTEROID,
					ret.getRadius_inner(),
					ret.getRadius_outer(),
					false);
	
			
			
			//set certain motion
			
			int dx = s.getX()-p.getX();
			int dy = s.getY()-p.getY();
			int lengthsqr = dx*dx+dy*dy;
			int speedsqr = getBewegung().getSpeedSqr();
			double fak = Math.sqrt(((double)speedsqr)/lengthsqr);
					
			newBew = new Vector(
							(int)Math.ceil(fak*dx),
							(int)Math.ceil(fak*dy),
							0f,
							Integer.MAX_VALUE,
							1f);
			
			
		} else
		{
			
			//set the time borders
			Position p = getPosition();
			
			newPos = new Position(
					p.getX(),
					p.getY(),
					p.getZeitpunkt(),
					f.getHitTimeOuter(),
					Integer.MAX_VALUE,
					Position.TYPE.ASTEROID,
					ret.getRadius_inner(),
					ret.getRadius_outer(),
					false);

			
			//set uncertain motion
			Vector d = getBewegung();

			newBew = new Vector(
							d.getX(),
							d.getY(),
							ret.getDCertainty(),
							f.getHitTimeInner(),
							1f);
		}
		
		ret.setPosition(newPos);
		ret.setBewegungGenau(newBew);
		
//		logger.debug("create Child:"+ret);
		return ret;
	}
	
	
	public boolean canBreakApart() {
		return getGroesseID()==2 || getGroesseID()==3;
	}
	
	
	public boolean isProbabilistic() {
		return creationEvent!=null;
	}
	
	
	
	@Override
	public void draw(Graphics2D g)
	{
		if (isProbabilistic())
		{
			super.setDrawStringWithObject("Child");
		} else
		{
			super.setDrawStringWithObject(null);
		}
		super.draw(g);
	}

	
	public String toString()
	{
		return super.toString()
			+((creationEvent==null)?"":" ,creator(t="+creationEvent.getHitTimeInner()+")="+creationEvent.getTarget().getId());
	}
	
	public MyObject getParent()
	{
		if (creationEvent==null) return null;
		return creationEvent.getTarget();
	}
	
	private float getDCertainty()
	{
		int i = getGroesseID();
		switch(i){
		case 1: return AST_DCERTAINTY_SMALL;
		case 2: return AST_DCERTAINTY_MED;
		case 3: return AST_DCERTAINTY_BIG;
		}
//		logger.warn("error");
		return Float.NaN;
		
	}
	
}
