#ifndef MOVINGOBJECT_GETPOS_SHOTBY_H
#define MOVINGOBJECT_GETPOS_SHOTBY_H

#include "MovingObject.h"
#include "Ship.h"

/**
 *    Returns the future position of a target, taking
 *    into accout speed of target, ship, and shot. The
 *    time required to correct the orientation of the ship
 *    might also be included.
 */

inline
Point MovingObject::getPos_shotBy(Ship &o, bool inclTurnTime) {

    double x = getx();
    double y = gety();
    double vx = x;
    double vy = y;

    int step = o.step;
    /// \todo Fix step by previously pressed keys.

    double a = Ship::stepAngle[step]/180.*M_PI;

    for (int i=0;i<10;i++) {

        /// The target will be at some position relative
        /// to the ship.
        double dx = x-o.getx();
        double dy = y-o.gety();
        FrameStatus::normalize(dx,dy);

        /// Taking into account the drift of the shot,
        /// due to non-zero ship velocity, the target
        /// appears at another relative position.
        double vdx = vx-o.getx();
        double vdy = vy-o.gety();
        FrameStatus::normalize(vdx,vdy);

        /// The shot starts 12 pixels in front of the
        /// ship.
        dx  += Ship::shotXOffs[step];
        dy  += Ship::shotYOffs[step];
        vdx += Ship::shotXOffs[step];
        vdy += Ship::shotYOffs[step];

        /// The orientation of the ship refers to the
        /// ship-relative position.
        double da = atan2(dx,dy)
                   -atan2(Ship::shotUVel[step],Ship::shotVVel[step]);
        FrameStatus::normalize(da);
        int turns = roundd(da/SHIP_ROT);
        int nturns = abs(turns);

        step = (o.step + turns + 256) & 0xff;

        double dist = sqrt(dx*dx+dy*dy);
        double vdist = sqrt(vdx*vdx+vdy*vdy);

        /// The velocity of a shot
        /// from standstill is computed.
        /// Herefor, we aim at the virtual
        /// position.
        double su = vdx/vdist*480;
        double sv = vdy/vdist*480;

        /// Next, the drift due to velocity
        /// of the ship is accounted for.
        double nu = limit480(su+o.getu());
        double nv = limit480(sv+o.getv());

        /// The difference between both is
        /// a virtual drift velocity.
        double mu = nu-su;
        double mv = nv-sv;

        /// When computing the time-to-impact,
        /// the true velocity of the shot, as
        /// well as the true distance, are used.
        double time = dist/sqrt(nu*nu+nv*nv);

        /// As rough measure, turn time is also included.
        if (inclTurnTime) time += nturns/60.;

        /// The virtual position of the target is
        /// computed, taking into account the drift.
        vx = getx()+time*(getu()-mu);
        vy = gety()+time*(getv()-mv);

        /// The true position of the target is
        /// computed, without drift.
        x = getx()+time*getu();
        y = gety()+time*getv();
    }
    return Point((int)vx,(int)vy);
}

#endif
