// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#ifndef __AST_VIEWER_H
#define __AST_VIEWER_H

#include "defines.h"
#include "sceneobject.h"
#include "keyspacket.h"
#include "framepacket.h"
#include "framestatus.h"
#include "gamestatus.h"

class NetworkEngine;

class Viewer
{
public:
	Viewer (SOCKET socket, ADDRESS serverIP, bool batch);
  
public:
	void run       ();
	void iteration ();
  
private:
	void interpretScreen     (const FramePacket &packet, FrameStatus& frame);
  void calculateVelocities (int type, int currentIndex);
 
private:
  void sendReceive       ();
  void updateFrameStatus ();
  void updateGameStatus  ();

protected:
  void          scheduleAction          (const KeysPacket& keys);
  void          removeScheduledActions  ();
  void          forceLeftRightBalance   (unsigned char value);
  unsigned char getLeftRightBalance     ();
  unsigned char getLastLeftRightBalance ();
  
protected:
  virtual void updateAction ();
    
private:
	SOCKET  mSocket;
	ADDRESS mServerIP;

protected:
  bool    mBatch;

public:
  FramePacket mFrame;
  GameStatus  mGame;

public:
  unsigned char     mPrevFrame;
  unsigned long int mPrevFullFrameNumber;
  int               mFrameDelay;
  int               mFrameLoss;
  unsigned long int mLastSaucerFullFrameNumber;
  
private:
  NetworkEngine* mNetworkEngine;
  
public:
  friend class NetworkEngine;
};

#endif

