// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <winsock2.h>

#include "sceneobject.h"

SceneObject::SceneObject () :
  mType          (TYPE_NONE),
  mRadius        (0),
  mVX            (0),
  mVY            (0),
  mX             (0),
  mY             (0),
  mRelX          (0),
  mRelY          (0),
  mTargetX       (NULL),
  mTargetY       (NULL),
  mHasTarget     (NULL),
  mDestructFrame (0),
  mDestructID    (0),
  mDestructVX    (0.0),
  mDestructVY    (0.0)
{
  int i = 0;

  mTargetX   = new int[TARGET_LOOKAHEAD];
  mTargetY   = new int[TARGET_LOOKAHEAD];
  mHasTarget = new bool[TARGET_LOOKAHEAD];
  
  for (i=0; i<TARGET_LOOKAHEAD; ++i)
  {
    mTargetX  [i] = 0;
    mTargetY  [i] = 0;
    mHasTarget[i] = false;
  }
}

SceneObject::~SceneObject ()
{
  delete[] mTargetX;
  delete[] mTargetY;
  delete[] mHasTarget;
}

SceneObject::SceneObject (const SceneObject& other) :
  mType          (other.mType),
  mRadius        (other.mRadius),
  mVX            (other.mVX),
  mVY            (other.mVY),
  mX             (other.mX),
  mY             (other.mY),
  mRelX          (other.mRelX),
  mRelY          (other.mRelY),
  mTargetX       (),
  mTargetY       (),
  mHasTarget     (),
  mDestructFrame (other.mDestructFrame),
  mDestructID    (other.mDestructID),
  mDestructVX    (other.mDestructVX),
  mDestructVY    (other.mDestructVY)
{
  mTargetX   = new int[TARGET_LOOKAHEAD];
  mTargetY   = new int[TARGET_LOOKAHEAD];
  mHasTarget = new bool[TARGET_LOOKAHEAD];

  int i = 0;

  for (i=0; i<TARGET_LOOKAHEAD; ++i)
  {
    mTargetX  [i] = other.mTargetX  [i];
    mTargetY  [i] = other.mTargetY  [i];
    mHasTarget[i] = other.mHasTarget[i];
  }
}

SceneObject& SceneObject::operator= (const SceneObject& other)
{
  mType          = other.mType;
  mRadius        = other.mRadius;
  mVX            = other.mVX;
  mVY            = other.mVY;
  mX             = other.mX;
  mY             = other.mY;
  mRelX          = other.mRelX;
  mRelY          = other.mRelY;
  mDestructFrame = other.mDestructFrame;
  mDestructID    = other.mDestructID;
  mDestructVX    = other.mDestructVX;
  mDestructVY    = other.mDestructVY;

  int i = 0;

  for (i=0; i<TARGET_LOOKAHEAD; ++i)
  {
    mTargetX  [i] = other.mTargetX  [i];
    mTargetY  [i] = other.mTargetY  [i];
    mHasTarget[i] = other.mHasTarget[i];
  }
  
  return (*this);
}

void 
SceneObject::clear ()
{
  mType          = TYPE_NONE;
  mRadius        = 0;
  mVX            = 0;
  mVY            = 0;
  mX             = 0;
  mY             = 0;
  mRelX          = 0;
  mRelY          = 0;
  mDestructFrame = 0;
  mDestructID    = 0;
  mDestructVX    = 0.0;
  mDestructVY    = 0.0;

  int i = 0;

  for (i=0; i<TARGET_LOOKAHEAD; ++i)
  {
    mTargetX  [i] = 0;
    mTargetY  [i] = 0;
    mHasTarget[i] = false;
  }
}

void 
SceneObject::setSaucer (int x, int y, int scale)
{
  this->clear ();

  mType = TYPE_SAUCER;
  
  int xc = x;
  int yc = y;
  int r  = 1;

  if (14 == scale)
  {
    // klein
    r = 10;
  }
  else
  {
    // gross
    r = 20;
  }      

  mRadius = r;
  mX      = xc;
  mY      = yc;
}

void 
SceneObject::setAsteroid (int x, int y, int scale)
{
  this->clear ();
  
  int xc = x;
  int yc = y;
  int r  = 1;

  if (14 == scale)
  {
    // klein
    r = 10;
    mType = TYPE_ASTEROID_S;
  }
  else if (15 == scale)
  {
    // mittel
    r = 20;
    mType = TYPE_ASTEROID_M;
  }
  else
  {
    // gross
    r = 40;
    mType = TYPE_ASTEROID_L;
  }      
  
  mRadius = r;
  mX      = xc;
  mY      = yc;
}

void 
SceneObject::setShot (int x, int y)
{
  this->clear ();

  mType   = TYPE_SHOT;  
  mX      = x;
  mY      = y;
  mRadius = 1;
}

