// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#ifndef __AST_NETWORKENGINE_H
#define __AST_NETWORKENGINE_H

#include "defines.h"
#include "sceneobject.h"
#include "keyspacket.h"
#include "framepacket.h"
#include "framestatus.h"
#include "gamestatus.h"

class Viewer;

class NetworkEngine
{
public:
  NetworkEngine (SOCKET socket, ADDRESS serverIP);
  virtual ~NetworkEngine ();
   
public:
  void          scheduleAction          (const KeysPacket& keys);
  void          removeScheduledActions  ();
  void          getLatestFramePacket    (FramePacket& packetRet, int& frameDelayRet);
  void          forceLeftRightBalance   (unsigned char value);
  unsigned char getLeftRightBalance     ();
  unsigned char getLastLeftRightBalance ();
  
public:
  void sendPacket    ();
  void receivePacket ();
  
public:
  FramePacket mFrame;
  KeysPacket* mActionList;
  int         mActionListStart;
  int         mActionListSize;
  
private:
  SOCKET  mSocket;
  ADDRESS mServerIP;

private:
  unsigned char     mPrevFrame;
  unsigned long int mPrevFullFrameNumber;
  unsigned long int mFullFrameNumber;
  unsigned long int mLastDeliveredFullFrameNumber;
  int               mFrameDelay;
  int               mFrameLoss;
  unsigned char     mPing; 
  unsigned char     mLeftRightBalance;
  unsigned char     mLastLeftRightBalance;
  KeysPacket*       mActionsByPing;
  int*              mReceiveCountsByPing;
  KeysPacket        mPrioAction1;
  KeysPacket        mPrioAction2;
  KeysPacket        mLastAction;
  int               mPrioActionFlag;
};

#endif

