// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#ifndef __AST_DEFINES_H
#define __AST_DEFINES_H

// Misc defines
#define ADDRESS DWORD
#define AST_NOP void ();

// Buffered frames for velocity calculation
// Note: saucervalue lower than common, due to likely velocity changes
#define MAX_REMEMBERED_FRAMES        30
#define MAX_REMEMBERED_FRAMES_SAUCER 10

// Maximum allowed number of objects
#define MAX_PER_GROUP         100
#define MAX_ASTEROIDS_S       100
#define MAX_ASTEROIDS_M        50
#define MAX_ASTEROIDS_L        20
#define MAX_SHOTS              10

#define MAX_SCENE_OBJECTS (MAX_ASTEROIDS_S+MAX_ASTEROIDS_M+MAX_ASTEROIDS_L+MAX_SHOTS+1)

// Types of objects
#define TYPE_NONE       0
#define TYPE_ASTEROID_S 1
#define TYPE_ASTEROID_M 2
#define TYPE_ASTEROID_L 3
#define TYPE_SAUCER     4
#define TYPE_SHOT       5

// Mathematical constants
#define M_PI 3.1415926535897932384626433832795
#define DEG_TO_RAD (2.0 * M_PI / 360.0)

// Games frames per second
#define GAME_FPS 60.0

// Viewport sizes in pixel
#define GAME_WIDTH  1024
#define GAME_HEIGHT  768

// Speed scale for visualization
#define VELO_SCALE 0.3

// (Average) shot speed in pixel/sec
#define SHOT_SPEED 472.0

// Lifetime of a shot in frames and sec
#define SHOT_DURATION_F  (70.0)
#define SHOT_DURATION    (70.0/GAME_FPS)

// Maximum reasonable speed in pixel/sec
#define MAX_SPEED 1000.0

// Offset from ship center to shot-source in pixel
#define SHOT_SOURCE_OFF 20.0

// Ship rotation in degrees/sec
#define ROTATION_SPEED 250.0

// Number of frames to rotate 360 deg
#define ROTATION_COUNT (360.0f / ROTATION_SPEED * GAME_FPS)

// Collision check related
// Note: last-minute tweak of ship-radius from 20 to 17
#define SHIP_RADIUS 17.0
#define MAX_COLL_T 100.0
#define IS_MAX_COLL_T(x) (fabs(MAX_COLL_T-x)<1e-3f)

// Targeting check related
#define TARGET_LOOKAHEAD 50

// Compiler-dependent stuff
#pragma warning(disable:4351)

#endif

