#include "tools.h"
#include <windows.h>
/** parameter
    
		p0 point on line
		v0 head vecotr in length of speed
		maxTime ist the maximal lookup time
		minDist is the minmal distance to the line
		maxResult   -> how mayny results maximal
		resultCount -> how many Results are in return
		resultArray -> the timing values for the hits (float array)
*/
int intersectWrapLinePoint(
				const vecDblC & _p0,
				const vecDblC & _dir,
				const vecDblC & _point,				
				float minDist,
				float maxTime,
				int maxResult,
				int * resultCount,
				float * resultArray)
{
	int dx=1024;
	int dy=768;

	*resultCount=0;

	vecDblC p0Dbl(_p0),dir(_dir),pointDbl(_point);

	// vecScreenPositionMap(p0Dbl);
	// vecScreenPositionMap(pointDbl);
			
	
	vecDblC headNorm(dir.norm(1));
	vecDblC headNormal=headNorm.normale();
	float speed=dir.len();

	if (speed<1e-5)
		return 0;
	vecDblC headSpeedVec=headNorm/speed;			
	


	// printLog("Head %g %g Speed %g\n",head.x(),head.y(),speed);
	
	while(42)
	{
		// clip p0 and p1 on screen ..
		// calc distance of given point	

		float a1,a2;
		
		if (intersectLineCircle(p0Dbl,dir,pointDbl,minDist,a1,a2)>0)
		{
			if (a1>=0 || a2>=0)
			{				
				if (a1<0) 
					a1=0;
				if (a2<0) 
					a2=0;
				resultArray[(*resultCount)*2+0]=a1;
				resultArray[(*resultCount)*2+1]=a2;
				(*resultCount)++;

				if (*resultCount>=maxResult || a2>maxTime)
					break;
			}
		}

		if ((pointDbl-p0Dbl).skalar(headSpeedVec)>maxTime)
			break;

		// now see which is the next index point for us .. there are 8 possible screens

		float dxOff=0;
		float dyOff=0;
		float diOff=1e10;
		
		float pair[16]={dx,0, dx,dy, 0,dy, -dx,dy, -dx,0, -dx,-dy, 0,-dy, dx,-dy };

		for (int i=0;i<8;i++)
		{

			float sk=vecDblC(pair[i*2],pair[i*2+1]).skalar(headNorm);
			if (sk<=1e-5)
				continue;			
			float h=fabs((pointDbl+vecDblC(pair[i*2],pair[i*2+1])-p0Dbl).skalar(headNormal));
			if (h<diOff) { dxOff=pair[i*2];dyOff=pair[i*2+1];diOff=h;}
		}

						
		pointDbl=pointDbl+vecDblC(dxOff,dyOff);
				
	}

	return *resultCount;		
}


/** methode to intersect and return timmings for the intersections */
int intersectWrapLineLineTime(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & dir0,
			const vecDblC & p1,const vecDblC & dir1,
			///
			int maxTime,
			///
			int minDist,
			/// return the coord of hitPoint
			int maxResult,
			/// number of return results
			int * resultCount,
			/// return arry for the times ..
			float * resultArray
			)
{
	
	*resultCount=0;
						
	// we used the so called "gallileo transoformation" to bring the second item in first items coordsystem

	// this is the correction vector for the second item ...
	vecDblC dir1Full=dir1-dir0;

	if (dir1Full.len()<1e-5)
	{
		// the object will not move because the direction vector ads to zero ..
		if ((p0-p1).len()<minDist)
		{
			resultArray[0]=0.0;
			*resultCount=1;
			return 1;
		}
		return 0;
	}
	// so the new second line use p2Dbl as base and head2Full as direction

	// next step is to use this new line to intersect with our now "based" point	
	intersectWrapLinePoint(p1,dir1Full,p0,minDist,maxTime,maxResult,resultCount,resultArray);

	return * resultCount;
}

int intersectLineLine(const vecDblC & p0,const vecDblC & d0,const vecDblC & p1,const vecDblC & d1,float minDist,float & a,float & b)
{
	// setup system
	// p0+a*d0=p1+b*d1
	// a*d0-b*d1=p1-p0

	float u1=d0.x();
	float u2=-d1.x();
	float u3=d0.y();
	float u4=-d1.y();

	float dif=u1*u4-u3*u2;

	if (fabs(dif)<1e-8)
	{
		// no common solution found ..
		vecDblC head=d0;
		vecDblC headNorm=head.norm(1);
		vecDblC headNormale=headNorm.normale();
		vecDblC hVec(p1-p0);
		
		float dist=fabs(headNormale.skalar(hVec));
		if (dist>minDist)
			return 0;
		float off=hVec.skalar(headNorm);
		float sign=d0.skalar(d1)>0.0?-1.0:1.0;

		float v0=d0.len();
		float v1=d1.len();

		float h=(v0+v1*sign);

		if (fabs(h)<1e-8)
			return 0;

		float x=off/h;
		
		if (x<0)
			return 0;

		a=x;
		b=x;
		
		return 1;
	}

	float h1=p1.x()-p0.x();
	float h2=-d1.x();
	float h3=p1.y()-p0.y();
	float h4=-d1.y();
	
	

	a=(h1*h4-h3*h2)/dif;

	float r1=d0.x();
	float r2=h1;
	float r3=d0.y();
	float r4=h3;

	b=(r1*r4-r3*r2)/dif;	

	return 1;
}

void getCorrectOffsets(const vecDblC & d0,const vecDblC & d1,float hd0Len,float hd1Len,float minDist,float & correctAOffset,float & correctBOffset)
{
	float wi;
	if (d0.skalar(d1)<0.0)
		wi=angle(d0,d1*-1.0);	
	else
		wi=angle(d1,d0);

	if (fabs(wi-PI/2.0)>1e-8)
	{
		float ah=minDist*tan(90.0/180*PI-wi);
		float ab=sqrt(ah*ah+minDist*minDist);
		correctBOffset=ab/hd1Len;
		correctAOffset=sqrt(ab*ab-minDist*minDist)/hd0Len;
	}
	else
	{
		correctAOffset=0.0;
		correctBOffset=minDist/hd1Len;
	}
}


int intersectWrapLineLineHitTest(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & dir0,
			///
			const vecDblC & p1,const vecDblC & dir1,
			///
			float hd0Len,float hd1Len,
			///
			float minDist,
			///
			float maxTime,			
			///
			float & limitAInOut,
			float & limitBInOut)
{
	float a,b;
	if (!intersectLineLine(p0,dir0,p1,dir1,minDist,a,b))
		return 0;
	
	// why we allow a offset. If a>b means b is earlier at point but we have to take in notice
	// that we are not a point so we have also additional time for a which is the current minDist
	// mindist is given in length units so we have to change the value to time units
	float offA,offB;
	getCorrectOffsets(dir0,dir1,hd0Len,hd1Len,minDist,offA,offB);

	if (a>b+offB)
	{ 		
		return 0;
	}

	if (a<-offA || b<-offB)
		return 0;

	float off1=a;
	float off2=b;

	if (off1>maxTime || off2>maxTime)
		return 0;

	if (a<limitAInOut)
	{
		limitAInOut=a;
		limitBInOut=b;
	}

	return 1;

}

int intersectWrapLineLineHit(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & dir0,
			///
			const vecDblC & p1,const vecDblC & dir1,			
			///
			float minDist,
			///
			float maxTime,			
			/// per result item are two results !
			int maxResult,
			/// number of return results
			int * resultCount,
			/// return arry for the times ..
			float * resultArray
)
{
	int dx=1024;
	int dy=768;

	*resultCount=0;
	// 
	vecDblC hp0=p0;
	vecDblC hd0=dir0;

	
	float hd0Len=hd0.len();	
	float hd1Len=dir1.len();

	float a=1e10,b=1e10;	
	if (intersectWrapLineLineHitTest(p0,dir0,p1,dir1,hd0Len,hd1Len,minDist,maxTime,a,b))
	{
		resultArray[*resultCount*2+0]=a;
		resultArray[*resultCount*2+1]=b;
		(*resultCount)++;
	}


	vecDblC hp1=p1;
	
	

	for (;42;)
	{
		if (*resultCount>=maxResult)
			break;
		// we are not ready ..				
		float pair[16]={dx,0, dx,dy, 0,dy, -dx,dy, -dx,0, -dx,-dy, 0,-dy, dx,-dy };

		// use transformation .. we take p0 as base ..
		vecDblC head=dir0-dir1;		

		float aBest=1e10;
		float bBest=1e10;

		int anyFound=0;

		vecDblC org=hp1;
		
		for (int i=0;i<8;i++)
		{
			vecDblC off(pair[i*2],pair[i*2+1]);
			float sk=off.skalar(head);
			if (sk<=1e-5)
				continue;	

			vecDblC h=org+off;

			int res=intersectWrapLineLineHitTest(p0,dir0,h,dir1,hd0Len,hd1Len,minDist,maxTime,aBest,bBest);			
			if (res)
			{ anyFound=1;
				hp1=h;
			}
		}

		if (!anyFound)
			break;	

		// add item to lost
		resultArray[*resultCount*2+0]=aBest;
		resultArray[*resultCount*2+1]=bBest;
		(*resultCount)++;

	}
	

	return *resultCount;


}


int intersectWrapLineLineWaitFire(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & d0,
			///
			const vecDblC & p1,const vecDblC & d1,			
			///
			float minDist,
			///
			float maxTime,			
			/// return arry for the times ..
			intersectWrapLineLineWaitFireS * resultArray
)
{
	/// the idee .. use again the transoformation to have only one moving target 
	
	int    localCount;
	float localRes[2];


	vecDblC d1Norm=d1.norm(1);
	
	vecDblC transD=(d0-d1);
	vecDblC transDNorm=transD.norm(1);
	vecDblC transDNormale=transDNorm.normale();

	float d0Len=d0.len();
	float d1Len=d1.len();

	// i dont like the angle calc we use the constructive methode ..


	float wi;
	if (d0.skalar(d1)<0.0)
		wi=angle(d0,d1*-1.0);	
	else
		wi=angle(d1,d0);

	// head to head .. ?
	if (fabs(wi)<1e-8)
	{
		// we handle this here because we would get two many special cases below ..
		float off=fabs((p1-p0).skalar(d0.normale()));
		
		// are they on one line ?
		if (off<minDist)
		{
			float resultArrayDirect[10];
			int    resultCountDirect;
			int		 res=intersectWrapLinePoint(p0,transD,p1,minDist,maxTime,1,&resultCountDirect,resultArrayDirect);
			if (!res)
				return 0;
			
			float off1=resultArrayDirect[0];
			float off2=resultArrayDirect[1];
			// yes we are .. are we against to each other ?
			float side=d0.skalar(d1);
			
			if (side>0)
			{ // we fly behind each other and p0 is faster									
				resultArray[0].startWaitTime=0;
				resultArray[0].startFlyTime =off1;
				resultArray[0].endWaitTime=500*(d0Len-d1Len);
				resultArray[0].endFlyTime =off2+500*(d0Len-d1Len);
			}
			else
			{ // we fly head to head we can wait until he reach us
				resultArray[0].startWaitTime=0;
				resultArray[0].startFlyTime =off1;
				resultArray[0].endWaitTime=((p0-p1).len()-minDist)/(d1Len);
				resultArray[0].endFlyTime =0;
			}
			// return our one and only result
			return 1;
		}
		else
			// we are head to head but the distance does not match ..
			return 0;
	}

	float correctBOffset;
	float correctAOffset;
	if (fabs(wi-PI/2.0)>1e-8)
	{
		float ah=minDist*tan(90.0/180*PI-wi);
		float ab=sqrt(ah*ah+minDist*minDist);
		correctBOffset=ab/d1Len;
		correctAOffset=sqrt(ab*ab-minDist*minDist)/d0Len;
	}
	else
	{
		correctAOffset=0.0;
		correctBOffset=minDist/d1Len;


	}
					
	int    resultCount=0;
	// create the two lines to intersect with our transformed head
	float  resultArrayDirect[10];
	int    resultCountDirect;
	
	if(!intersectWrapLineLineHit(p0,d0,p1,d1,minDist,maxTime,1,&resultCountDirect,resultArrayDirect))	
		return 0;
	
	// now we have the timings for the hit point 
	// a is me and b is target
	float a=resultArrayDirect[0];
	float b=resultArrayDirect[1];
	
	// off if the time diff (means how long can i wait for b if i want to hit the middle)

	float minATime=a-correctAOffset;
	float maxATime=a+correctAOffset;

	if (minATime<0 && maxATime<0)
		return 0;

	float minBTime=b-correctBOffset;
	float maxBTime=b+correctBOffset;

	if (minBTime<0 && maxBTime<0)
		return 0;
	
	// we are against each other .. 	
	float waitAStart,waitAEnd,flyAStart,flyAEnd;
	if (d1.skalar(d0)<0)
	{

		if (minATime<0)
		{
			maxBTime+=minATime*d0Len/d1Len;
			minATime=0;
		}

		if (maxATime<0)
		{
			minBTime+=maxATime*d0Len/d1Len;
			minATime=0;
		}

		waitAStart=minBTime-maxATime;
		waitAEnd =maxBTime-minATime;

		

		if (waitAStart<0 && waitAEnd<0)
			return 0;

		if (waitAStart<0)
		{ waitAStart=0.0;
		  if (!intersectWrapLinePoint(p0,transD,p1,minDist,maxTime,1,&resultCountDirect,resultArrayDirect))
				return 0;
			flyAStart=resultArrayDirect[0];
		}
		else
			flyAStart=maxATime;		
		
		flyAEnd  =minATime;
	}
	else
	{
		if (maxATime<0)
		{
			maxBTime+=maxATime*d0Len/d1Len;
			maxATime=0;
		}
		if (minATime<0)
		{
			minBTime+=minATime*d0Len/d1Len;
			minATime=0;
		}

		waitAStart=minBTime-minATime;
		waitAEnd =maxBTime-maxATime;

		if (waitAStart<0 && waitAEnd<0)
			return 0;
		
		if (waitAStart<0)
		{ waitAStart=0.0;
		  if (!intersectWrapLinePoint(p0,transD,p1,minDist,maxTime,1,&resultCountDirect,resultArrayDirect))
			{
				// we cant hit this object direct
				return 0;
			}
			flyAStart=resultArrayDirect[0];
		}
		else
			flyAStart=minATime;
				
		flyAEnd  =maxATime;
	}
	

	
	

	
	resultArray[0].startWaitTime=waitAStart;
	resultArray[0].startFlyTime=flyAStart;
	resultArray[0].endWaitTime=waitAEnd;
	resultArray[0].endFlyTime=flyAEnd;	

	if (flyAStart<0 || flyAEnd<0)
		fatalError("timings");
	return 1;
		


}	

int intersectLineCircle(const vecDblC & p0,const vecDblC & d0,const vecDblC & m,float rad,vecDblC & a1,vecDblC & a2)
{
  vecDblC u = d0;
	// sanity check: null linie
  float lu = u.len();

	vecDblC uNorm(u.norm(1));
	vecDblC n=p0+uNorm*(m-p0).skalar(uNorm);    
  float d = sqrt((m-n).skalar(m-n));
	float DminusR=d-rad;
	// test if the point distance is larger than radius
  if (DminusR-1e-8>0) 
		return 0;
	
	if (DminusR>0) 
		d=rad;

  if (fabs(d-rad)<1e-8)
	{
		a1=n;
		a2=n;
		return 1;
	}
	// wirklich ausrechnen...
  a1=n-u*sqrt(rad*rad-d*d)/lu;
  a2=n+u*sqrt(rad*rad-d*d)/lu;

	float fa1=(a1-p0).skalar(d0);
	float fa2=(a2-p0).skalar(d0);
	if (fa2<fa1)
	{
		swap(a1,a2);
	}

  return 2;
}

int intersectLineCircle(const vecDblC & p0,const vecDblC & d0,const vecDblC & m,float rad,float & fa1,float & fa2)
{
  vecDblC u = d0;
	
  float lu = u.len();

	vecDblC uNorm(u.norm(1));
	vecDblC n=p0+uNorm*(m-p0).skalar(uNorm);    
  float d = sqrt((m-n).skalar(m-n));
	float DminusR=d-rad;
  if (DminusR-1e-8>0) 
		return 0;
	
	if (DminusR>0) d=rad;

	int ret=0;

	vecDblC a1,a2;

  if (fabs(d-rad)<1e-8)
	{
		a1=n;
		a2=n;
		ret=1;
	}
	else
	{
		// wirklich ausrechnen...
		a1=n-u*sqrt(rad*rad-d*d)/lu;
		a2=n+u*sqrt(rad*rad-d*d)/lu;
		ret=2;
	}

	fa1=(a1-p0).skalar(uNorm)/lu;
	fa2=(a2-p0).skalar(uNorm)/lu;
	if (fa2<fa1)
	{
		swap(a1,a2);
	}

  return ret;
}



/// ctor take current time
timeFrameC::timeFrameC()
{
	 update();
}
	/// return the run time up to this point
long timeFrameC::runTime(int upt)
{
	
	LARGE_INTEGER current,freq;

	QueryPerformanceCounter(&current);
	QueryPerformanceFrequency(&freq);

	float ret=(current.QuadPart-((LARGE_INTEGER*)&startTime)->QuadPart)/float(freq.QuadPart)*10000.0;
	
	if (upt)
		update();
	return ret;
}
	/// update to current time
void timeFrameC::update()
{
	QueryPerformanceCounter((LARGE_INTEGER*)&startTime);
	
}

int intersectWrapLineLineWaitFireS::calcFireTime(float time,unsigned int & fireTime,unsigned int & flyTime)
{
	if (time>ceil(endWaitTime))
		return 0;
	if (time<ceil(startWaitTime))
	{
		// ceil here because we can fire only in the next full frame
		fireTime=ceil(startWaitTime);
		flyTime=ceil(startFlyTime);
		return 1;
	}
	// we are in the range .. again y=mx+t
	float dx=endWaitTime-startWaitTime;
	float dy=endFlyTime-startFlyTime;
	float m=dy/dx;
	float t=startFlyTime-m*startWaitTime;
	float y=m*time+t;
	fireTime=round(time);
	flyTime=round(y);
	return 1;


}

int intersectWrapLineLineWaitFireS::limitFlyTime(float minLimit,float maxLimit)
{	
	if (startFlyTime<=maxLimit && endFlyTime<=maxLimit && startFlyTime>=minLimit && endFlyTime>=minLimit)
		return 1;
	
	if ((startFlyTime>maxLimit && endFlyTime >maxLimit) || (startFlyTime<minLimit && endFlyTime<minLimit))
		return 0;
	
	// we have to break the time down
	// y=mx+t
	// 

	float dx=endWaitTime-startWaitTime;

	if (fabs(dx)<1e-8)
		return 0;

	float dy=endFlyTime-startFlyTime;
	float m=dy/dx;
	float t=startFlyTime-m*startWaitTime;

	
	if (startFlyTime>maxLimit || endFlyTime>maxLimit)
	{
	
		// limit=mx+t
		// x=(limit-t)/m
		float x=(maxLimit-t)/m;

	
		if (startFlyTime>maxLimit)
		{
			startWaitTime=x;
			startFlyTime=maxLimit;
		}
		else
		{
			endWaitTime=x;
			endFlyTime=maxLimit;
		}	
	}

	if (startFlyTime<minLimit || endFlyTime<minLimit)
	{
	
		// limit=mx+t
		// x=(limit-t)/m
		float x=(minLimit-t)/m;

	
		if (startFlyTime<minLimit)
		{
			startWaitTime=x;
			startFlyTime=minLimit;
		}
		else
		{
			endWaitTime=x;
			endFlyTime=minLimit;
		}	
	}

	return 1;
}

#ifdef _DEBUG
void printLog(const char * fmt,...)
{


	va_list argptr;
  va_start(argptr,fmt);

	vprintf(fmt,argptr);
}
#endif