#ifndef INC_PLANHIT
#define INC_PLANHIT

#include "gameobj.h"

/** class to make the hit planing .. */
class planHitC {
	
	/** table for opt ..
	    fly wait fire rot			
	*/
	enum searchMethodBitE { searchRot=1,searchWait=2,searchFly=4,searchWait2=8,searchWait0=16,searchWaitQ=32,searchRot2=64,searchRotQ=128,searchFlyS=256,searchMed=512,searchFly2=1024};
	enum searchMethodE { searchMinHitTime=searchRot | searchWait | searchFly,searchMinFireTime=searchRot | searchWait,searchMinFlyWait=searchWait|searchFly };
	/// enum bit field for lookup
	struct searchOptionS {
		/// default
		searchOptionS() { includeUnpredict=0;waitShotTime=0;method=0;}

		union {			
			int includeUnpredict:1;			
		};
		/// set this field != 0 for usage
		unsigned int waitShotTime;		
		///
		int method;
	};
	

	/// this class manage the hit table for one object
	class hitTableC {
		/// struct for hit storage
		struct hitDataS : public intersectWrapLineLineWaitFireS {
			hitDataS() { updateTime=0;}
			///
			void set(unsigned int time,const intersectWrapLineLineWaitFireS & data)
			{
				updateTime=time;
				intersectWrapLineLineWaitFireS::set(data);				
			}
			/// time when the cache was written
			unsigned int updateTime;			
			
		};
		/// the data for each "next" hit for this object in all possible directions
		hitDataS data[MAX_ANGLE];
		/// calc raw hit data on the given update time base
		int calcHitData(const searchOptionS & option,unsigned int updateTime,const vecIntC & p0,int head,const gameObjC & obj);
		/// get hit data for the given call and returns if there is something possible ..
		int getHitData(const searchOptionS & option,unsigned int updateTime,unsigned int time,const vecIntC & p0,int head,const gameObjC & obj,unsigned int & fireTime,unsigned int & flyTime);
	public:
		/** request the next hit with the given time and start head
		    max rot gives the maximum rotate angle to both sides where we look for the hit
		    return the ret head .. the time to wait on the given head and the flytime of the objcet
		*/
		int requestNextHit(
			const searchOptionS & option,
			unsigned int updateTime,               // the time from last system update
			unsigned int time,										 // the time we want to lookup
			const vecIntC & p0,int head,           // the fire object
			const gameObjC & obj, // the target object
			int maxRot,
			int direction,
			int & retHead,unsigned int & retWaitTime,unsigned int & retFlyTime,int & bestLimit);
		/// request if we can hit the object now
		int requestNowHit(
			const searchOptionS & option,
			unsigned int updateTime,               // the time from last system update
			unsigned int time,										 // the time we want to lookup
			const vecIntC & p0,int head,           // the fire object
			const gameObjC & obj, // the target object
			unsigned int & retWaitTime,unsigned int & retFlyTime);
		/// return hit data on the base information only
		int requestHitData(
			const searchOptionS & option,
			unsigned int updateTime,               // the time from last system update			
			const vecIntC & p0,int head,           // the fire object
			const gameObjC & obj, // the target object
			intersectWrapLineLineWaitFireS & outValue  // the requested information if return value == 1
			)
		{
			if (!calcHitData(option,updateTime,p0,head,obj))
				return 0;
			outValue=data[head];
			return 1;
		}
	};

	
	/// this class will hold object and hit data
	class hitObjC  {		
		/// the stored object
		gameObjC obj;
		/// timer of update
		unsigned int updateTime;		
		///
		hitTableC hitTable;
		///
		unsigned int fired;		
	public:
		/// ctor
		hitObjC() {updateTime=0;fired=0;}
		/// update data from real object list
		void update(unsigned int time,const gameObjC & _obj) 
		{ 			
			obj=_obj;updateTime=time;			
		};		
		///
		unsigned int getUpdateTime() const { return updateTime;}
		///
		gameObjC & getObj() { return obj;}
		///
		unsigned int getKey() const { return obj.getKey();}
		///
		int requestNextHit(const searchOptionS & option,unsigned int time,const vecIntC & pos,int head,int maxRot,int direction,int & retHead,unsigned int & retFireTime,unsigned int & retFlyTime,int & bestLimit)
		{ 
			if (!obj.predict(time))
				return 0;
			return hitTable.requestNextHit(option,updateTime,time,pos,head,obj,maxRot,direction,retHead,retFireTime,retFlyTime,bestLimit);
		}
		///
		int requestNowHit(const searchOptionS &  option,unsigned int time,const vecIntC & pos,int head,unsigned int & retFireTime,unsigned int & retFlyTime)
		{ 
			if (!obj.predict(time))
				return 0;
			return hitTable.requestNowHit(option,updateTime,time,pos,head,obj,retFireTime,retFlyTime);
		}
		///
		int requestHitData(const searchOptionS &  option,const vecIntC & pos,int head,intersectWrapLineLineWaitFireS & outData)
		{ 			
			return hitTable.requestHitData(option,updateTime,pos,head,obj,outData);
		}
		///
		void setFire(unsigned int fireTime)
		{
			fired=fireTime;
		}
		///
		unsigned int getFiredTimeDiff() const 
		{ if (updateTime<fired) return 0;
			return updateTime-fired;
		}
	};
		
	/// recursive call results
	struct recursiveResultS {		
		int listId;
		int head;
		int					 method;
		unsigned int fireTime;
		unsigned int flyTime;
	};
	typedef constArrayT<64,recursiveResultS> recursiveFirePositionsT;
	recursiveFirePositionsT recursiveFirePositions;	
	/// the runtime spaceship to store additional data
	class runtimeSpaceShipC : public spaceShipC {
		///
		struct shotDataS {
			/// ctor
			shotDataS() { tx=0;t0=0;key=0;}
			/// time to die
			unsigned int tx;
			/// time to start
			unsigned int t0;
			///
			unsigned int key;
		};
		/// array for the known shots
		constArrayT<4,shotDataS> shots;		
	public:		
		///
		void updateShotData(unsigned int time)
		{
			for (int i=shots.count()-1;i>=0;i--)
				if (time>shots[i].tx)
					shots.del(i);
		}		
		///
		void adjustTX(unsigned int time)
		{
			for (int i=shots.count()-1;i>=0;i--)
				if (time>shots[i].tx)
					shots[i].tx=time;
		}
		/// 
		void set(const spaceShipC & ship)
		{
			*((spaceShipC*)this)=ship;
		}
		///
		void incShot(unsigned int t0,unsigned int tx,unsigned int key) 
		{ shotDataS shot;shot.t0=t0;shot.tx=tx;shot.key=key;shots.add(shot);	}
		///
		unsigned int nextFireTime(unsigned int time);
		///
		int leftShots() const { return 4-shots.count();}
		///
		void clearShots() { shots.clear();}
		///
		void updateExt(unsigned int time,const vecIntC & pos,int head)
		{	spaceShipC::updateExt(time,pos,head);
		  updateShotData(time);		  
		}		
	};
	
	/// the user ship .. 
	runtimeSpaceShipC spaceShip;
	/// this list holds all object data .. 
	constArrayT<80,hitObjC> objects;
	///
	int getObjectByKey(unsigned int key) const
	{
		for (int i=0;i<objects.count();i++) if (objects[i].getKey()==key) return i;
		return -1;
	}
	///
	gameObjListC            updateObjectList;
	///
	typedef constArrayT<64,int> workListT;	
	///
	int score;
	/// is the time after the next change in the model appears
	unsigned int nextModelChange;
	///
	int firstGenerationMode;
	///
	int targetHead;
	///
	/// unsigned int shotOffsetTime;
	///
	unsigned int updateTime;
	/// maximal astro found
	int astroFullCount;		
	/// last target struct
	struct currentTargetS {
		/// ctor
		currentTargetS() { reset();}
		///
		void reset() { key=0;fireTime=TIME_INFINITE;flyTime=TIME_INFINITE;fireHead=0;}
		/// key of object
		unsigned int key;
		/// when to fire on target
		unsigned int fireTime;
		/// how long will the shot be on the road
		unsigned int flyTime;
		/// on which position we plan to fire
		int          fireHead;
	} currentTarget;

	///
	void markKillShip(int currentTime,const runtimeSpaceShipC & ship,gameObjListC & list);
	void markKillItems(int currentTime,gameObjListC & list);
	/// returns the offset time we have to wait because we cant shot at the moment
	void calcShotOffsetTime(unsigned int time,const gameObjListC & lst);
	/// methode to fully solve a given group of targets (n<5)
	int optNFull(
		const searchOptionS & option, // options is a bit set of the search OptionE
		unsigned int time0,unsigned int time,
		int						* methods,
		int             methodeCount,
		runtimeSpaceShipC ship,
		const workListT & workIds,
		unsigned int & bestTime,
		recursiveFirePositionsT firePositions);
	/// methode to fully solve a given group of targets with the n2 methode (n<10)
	int optN2Full(
		int maxDeep,
		const searchOptionS & option, // options is a bit set of the search OptionE		
		unsigned int time0,unsigned int time,
		int *methods,
		int methodeCount,
		runtimeSpaceShipC ship,
		const workListT & workIds,
		unsigned int & bestTime,
		recursiveFirePositionsT firePositions);
			
	/// return the next target in time from the given position
	int getNextTarget(
		const searchOptionS & option, // options is a bit set of the search OptionE
		unsigned int time,
		const vecIntC & pos,
		int head,
		int direction, // 0 means in both,1 only in positive and -1 only in negative direction search
		const workListT & workIds,
		int					 condObjListNumber,				
		unsigned int condObjTime,
		int          & objListPos,
		unsigned int & retTime,
		unsigned int & retFlyTime,
		int          & retHead)
	{ int res=getNextTargetI(option,time,pos,head,direction,workIds,condObjListNumber,condObjTime,objListPos,retTime,retFlyTime,retHead);
	  if (res)
			objListPos=workIds[objListPos];
		return res;
	}	 
	/// return the next target in time from the given position
	int getFarTarget(
		const searchOptionS & option, // options is a bit set of the search OptionE
		unsigned int time,
		const vecIntC & pos,
		int head,
		int direction, // 0 means in both,1 only in positive and -1 only in negative direction search
		const workListT & workIds,
		int					 condObjListNumber,				
		unsigned int condObjTime,
		int          & objListPos,
		unsigned int & retTime,
		unsigned int & retFlyTime,
		int          & retHead);
	
	/// return the next target in time from the given position but return value in workArray
	int getNextTargetI(
		const searchOptionS & option, // options is a bit set of the search OptionE
		unsigned int time,
		const vecIntC & pos,
		int head,
		int direction, // 0 means in both,1 only in positive and -1 only in negative direction search
		const workListT & workIds,
		int					 condObjListNumber,
		unsigned int condObjTime,
		int          & objListPos,
		unsigned int & retTime,
		unsigned int & retFlyTime,
		int          & retHead);	
	 /** get next object that kills me
	     if found also returns key for this
	 */
	 int getNextKiller(unsigned int time,workListT & workIds);
	 /** add all ufi into the todo list */
	 int addUfo(unsigned int time,workListT & workIds);
	 /// find if a item is direct in my fireline
	 int inFireLine(const searchOptionS & option,unsigned int time,workListT & workIds,int & listPos,unsigned int & retFireTime,unsigned int & retFlyTime);
	 ///
	 int calcDensityField(const searchOptionS & option,unsigned int time,workListT & workIds,int & retHead);
	 ///
	 int testPanic(unsigned int time);
public:
	///
	planHitC() { firstGenerationMode=0;targetHead=0;score=0;}
	/// this methode will bring in the latest data in our system
	void update(unsigned int time,const spaceShipC & ship,int score,const gameObjListC & lst);
	/** this methode will get the optimal kill 
	    it will return the next optimal control codes ..

			headChange =  1 turn left
			headChange = -1 turn right
			fire       = 0 no fire
			fire       > fire and also returns the time to impact
	*/
	void getOptimalKill(unsigned int time,int & headChange,unsigned int  & fireTime,int & panic);
};

#endif
