#ifndef INC_NETCOM
#define INC_NETCOM

#include <winsock2.h>
#include <fstream>
/// class to make network connection
class netComC {	
	SOCKET sd;
	unsigned long server_ip;
	/// playback out
	std::ofstream playbackOut;
	/// if we use a playback file
	std::ifstream playbackIn;
public:
	///
	netComC();
	/// connect to server
	int init(const char * serverName);
	/// send core data
	int send(const char * buffer,unsigned int size);
	/// receive core data
	int receive(char * buffer,unsigned int size);
};

/// special data type
#pragma pack(1)
class framePacketC
{
public:
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class keysPacketC
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	keysPacketC(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


/// here are the methods to send a data packet
inline int sendKeys(netComC & netCom,const keysPacketC & key)    { return netCom.send((const char*)&key,sizeof(key));}
inline int getFramebuffer(netComC & netCom,framePacketC & frame) { return netCom.receive((char*)&frame,sizeof(frame));}


#endif
