/// this methode connecto to the local server (original code)

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>



#include "netcom.h"
#include "tools.h"

netComC::netComC()
{
	// see if we are at home ..	
	playbackIn.open("playback.in",std::ifstream::ios_base::in | std::ofstream::ios_base::binary);

	if (!playbackIn.is_open())
	{
		std::ifstream athome("athome.txt",std::ifstream::ios_base::in);
		if (athome.is_open())
		{
			playbackOut.open("playback.out",std::ofstream::ios_base::out | std::ofstream::ios_base::binary | std::ofstream::ios_base::trunc);
		}
	}
	else
	{
		int offset=0;
		playbackIn.seekg(offset*sizeof(framePacketC));
	}
}

int netComC::init(const char * serverName)
{
	server_ip = inet_addr(serverName);
	if (server_ip == INADDR_NONE)
	{
		fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", serverName);
		exit(1);
	}

	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
		exit(2);
	}

	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sd == INVALID_SOCKET)
	{
		fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
		exit(2);
	}

	unsigned long enable_nonblocking = 1;
	if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
	{
		fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
		exit(1);
	}

	sockaddr_in sa;
	memset(&sa, 0, sizeof sa);
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port = 0;

	if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
	{
		fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
		exit(2);
	}

	return 1;
}


int netComC::send(const char * buffer,unsigned int size)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (size != sendto(sd, (char *)buffer,size, 0, (sockaddr*)&server, sizeof server))
	{
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			return 0;
		}
	}

	return 1;
}

int netComC::receive(char * buffer,unsigned int size)
{
	if (playbackIn.is_open())
	{
		playbackIn.read(buffer,size);
		if (playbackIn.eof())
		{
			fatalError("playback in eof");
		}
		return size;
	}
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		if  (recv(sd,buffer,size, 0)!=size)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			return 0;
		}
		
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));

	if (playbackOut.is_open())
	{
		playbackOut.write(buffer,size);
		playbackOut.flush();
	}
	return 1;
}

keysPacketC::keysPacketC(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;

	
}

void keysPacketC::clear(void)
{
	keys = '@';
}

void keysPacketC::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void keysPacketC::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void keysPacketC::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void keysPacketC::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void keysPacketC::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}
