#ifndef INC_FRAMESCANNER
#define INC_FRAMESCANNER
/// this is at the moment equal to the original sample .. thx to ct 8-)
#include "netcom.h"
#include "tools.h"
#include "gameobj.h"

/// X 0 = data 0
#define GAME_OFFX  (0)
/// the system does return values between 128 and 895 and not the values from 0 to 768
#define GAME_OFFY  (-128)
/// size of screen in X
#define GAME_SIZEX (1024)
/// size of screen in Y 
#define GAME_SIZEY (768)


static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS		 =	10;
static const int MAX_SAUCERS	 =  10;

// int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein


class gameStatusC
{

	gameObjTypeE vsToAstroType(int sf)
	{ switch (sf) {
			case 0 :return objTypeAstroidLarge;
			case 15:return objTypeAstroidMed;
			case 14:return objTypeAstroidSmall;
		};
		fatalError("fatal error");
		return objTypeAstroidLarge; 
	}

	gameObjTypeE vsToSaucerType(int sf)
	{ switch (sf) {
			case 15 :return objTypeSaucerLarge;			
			case 14:return objTypeSaucerSmall;
		};
		fatalError("fatal error");
		return objTypeAstroidLarge; 
	}

public:

	/// ctor
	gameStatusC();


	bool ship_present;  // Schiff sichtbar

	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;

	int points;
			
	constArrayT<MAX_SAUCERS+MAX_ASTEROIDS+MAX_SHOTS,gameObjBaseC>	objects;	
	
	int frameindex;

	void clear(void);	

	void scanFrame(const framePacketC &packet);
};



#endif
