﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AKTGR_Asteroids
{

    class Mathematicus
    {
        public static Boolean vectorGen(FlyingObject newObject, FlyingObject oldObject, int ship_x, int ship_y, Boolean isTarget)
        {
            int max_acc_x = 200;
            int max_acc_y = 100;
            int dx;
            int dxo;
            int dy;
            int dyo;
            int dist;
            int sf;
            Asteroid ast;
            UFO ufo;
            Shot nS;
            Shot oS;
            Boolean fromEnemy;
            dx = (newObject.x - oldObject.x);
            dy = (newObject.y - oldObject.y);
            if (Math.Abs(dx) < max_acc_x && Math.Abs(dy) < max_acc_y)
            {
                newObject.vx = newObject.x + dx;
                newObject.vy = newObject.y + dy;
                newObject.dx = dx;
                newObject.dy = dy;
                newObject.value = Convert.ToInt16(Math.Sqrt((Math.Pow(newObject.dx,2)) +
                                                            (Math.Pow(newObject.dy,2))));
                newObject.angle = calcAngle(newObject.x,newObject.y,newObject.dx,newObject.dy);
            }
            else
            {
               dx = oldObject.dx;
               dy = oldObject.dy;
               newObject.dx = dx;
               newObject.dy = dy;
               newObject.vx = oldObject.vx;
               newObject.vy = oldObject.vy;
               newObject.value = oldObject.value;
               newObject.angle = oldObject.angle;
            }
            fromEnemy = false;
            if (newObject.ObjType == "SHOT")
            {
                nS = (Shot)newObject;
                oS = (Shot)oldObject;
                nS.from_enemy = oS.from_enemy;
                fromEnemy = nS.from_enemy;
            }
            dxo = dx;
            dyo = dy;
            if (isTarget || (newObject.ObjType == "SHOT" && fromEnemy))
            {
                dx = ( newObject.x + (newObject.dx*10)) - ship_x;
                while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
                while (dx > 511) dx -= 1024;
                newObject.ndx = dx;
                dy = ( newObject.y + (newObject.dy*10)) - ship_y;
                while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
                while (dy > 383) dy -= 768;
                newObject.ndy = dy;
                dist = dx * dx + dy * dy;  // Quadrat des Abstands zu diesem Asteroiden
                if (newObject.ObjType == "ASTEROID")
                {
                   ast = (Asteroid)newObject;
                   sf = ast.sf;
                   switch (sf)
                   {	// Abstand um den ungefähren Radius des Asteroiden korrigieren
                       case 0:  // großer Asteroid
                           ast.boundingsize = 40 * 40;
                           dist -= 40 * 40;
                           break;
                       case 15: // mittlerer Asteroid
                           ast.boundingsize = 20 * 20;
                           dist -= 20 * 20;
                           break;
                       case 14: // kleiner Asteroid
                           ast.boundingsize = 8 * 8;
                           dist -= 8 * 8;
                           break;
                   }
                }
                else if (newObject.ObjType == "UFO")
                {
                    ufo = (UFO)newObject;
                    sf = ufo.sf;
                    switch (sf)
                    {	// Abstand um den ungefähren Radius des UFOs korrigieren
                        case 15: // großes UFO
                            ufo.boundingsize = 20 * 12;
                            dist -= 20 * 12;
                            break;
                        case 14: // kleines UFO
                            ufo.boundingsize = 10 * 6;
                            dist -= 10 * 6;
                            break;
                    }
                }
                else
                {
                    dist -= 8 * 8;
                    newObject.boundingsize = 8 * 8;
                }
                newObject.distance = dist;
            }
            if (Math.Abs(dxo) > 0 || Math.Abs(dyo) > 0)
            {
                return ( isTarget );
            }
            else
            {
                return false;
            }
        }

        public static double calcAngle(int x, int y, int dx, int dy)
        {
            double ax;
            double ay;
            double bx;
            double by;
            double angle;
            double z;
            double n;
            ax = 0;
            ay = 10;
            bx = dx;
            by = dy;
            z = (ax * bx) + (ay * by);
            n = Math.Sqrt(Math.Pow(ax, 2) + Math.Pow(ay, 2)) *
                Math.Sqrt(Math.Pow(bx, 2) + Math.Pow(by, 2));
            angle = z / n;
            angle = Math.Acos(angle);
            angle = Math.Round(angle * (180 / Math.PI), 1);
            if (bx < x)
            {
                angle = 360 - angle;
            }
            return angle;
        }

        public static int intersectCircle(int cx, int cy, int radius, int x1, int y1, int x2, int y2, ref int sx, ref int sy)
        {
            int dx;
            int dy;
            double a;
            double b;
            double c;
            double det;
            double t;
            int ix1;
            int ix2;
            int iy1;
            int iy2;

            dx = x2 - x1;
            dy = y2 - y1;

            a = dx * dx + dy * dy;
            b = 2 * (dx * (x1 - cx) + dy * (y1 - cy));
            c = (x1 - cx) * (x1 - cx) + (y1 - cy) * (y1 - cy) - radius * radius;
            
            det = b * b - 4 * a * c;

            if ((a <= 0.0000001) || (det < 0))
            {
                return 0;
            }
            else if (det == 0)
            {
               t = -b / (2 * a);
            //   sx = Convert.ToInt16(x1 + t * dx);
            //   sy = Convert.ToInt16(y1 + t * dy);
               return 1;
            }
            else
            {
                t = (-b + Math.Sqrt(det)) / (2 * a);
                //ix1 = x1 + t * dx;
                //iy1 = y1 + t * dy;
                t = (-b - Math.Sqrt(det)) / (2 * a);
                //ix2 = x1 + t * dx;
                //iy2 = y1 + t * dy;
                return 2;
            }
        }

        public static Boolean intersectLines(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, ref float xi, ref float yi)
        {
            float m1 = (y1 - y0) / (x1 - x0);
            float m2 = (y3 - y2) / (x3 - x2);

            if (m1 > 1e+10F)
                m1 = 1e+10F;
            if (m2 > 1e+10F)
                m2 = 1e+10F;

            float c1 = (y0 - m1 * x0);
            float c2 = (y2 - m2 * x2);

            xi = (c1 - c2) / (m2 - m1);
            yi = m1 * (c2 - c1) / (m1 - m2) + c1;

            return true;
        }
    }
}
