﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AKTGR_Asteroids
{
    public class FramePacket
    {
        public byte[] vectorram = new byte[1026];
        public UInt16[] vectorram2 = new UInt16[513];
        public char frameno;  // wird bei jedem Frame inkrementiert
        public char ping;     // Der Server schickt das letzte empfangene ping-Byte zurück
        public bool GameOver;
        public Exception Exception;


        public FramePacket()
        {
            this.GameOver = false;
            this.Exception = null;
        }

        public FramePacket(bool gameOver)
        {
            this.GameOver = gameOver;
            this.Exception = null;
        }

        public FramePacket(Exception e)
        {
            this.GameOver = true;
            this.Exception = e;
        }

        public FramePacket(bool gameOver, Exception e)
        {
            this.GameOver = gameOver;
            this.Exception = e;
        }

        public static FramePacket FromByteArray(byte[] array)
        {
            FramePacket np = new FramePacket();

            for (int i = 0; i < 513; i++)
            {
                // Damit ich später nicht über einen Pointer auf das Vector-Ram zugreifen
                // muss, kopiere ich die Daten in ein ushort Array um.
                np.vectorram2[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);
                np.vectorram[i] = array[i];
            }

            np.frameno = (char)array[1024];
            np.ping = (char)array[1025];

            return np;
        }
    }
}
