﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.Net.Sockets;

namespace AKTGR_Asteroids
{
    public class Connection
    {
        private const string GameOver = "game over\r\n";
        private const string Busy = @"^busy (?<frames>\d{1,8})\r\n\0*$";
        private const int MaxWait = 5000;

        IPAddress serverIp;
        int serverPort;
        Socket mySocket;

        bool frameReceived = false;

        public Connection()
        {
            byte[] localhost = { 127, 0, 0, 1 };
            this.serverIp = new IPAddress(localhost);
            this.serverPort = 1979;

            this.mySocket = GetSocket();
        }

        public Connection(IPAddress serverIp)
        {
            this.serverIp = serverIp;
            this.serverPort = 1979;

            this.mySocket = GetSocket();
        }

        public Connection(IPAddress serverIp, int serverPort)
        {
            this.serverIp = serverIp;
            this.serverPort = serverPort;

            this.mySocket = GetSocket();
        }

        public void Disconnect()
        {
            this.mySocket.Close();
        }

        private Socket GetSocket()
        {
            EndPoint myLocalEndpoint = new IPEndPoint(IPAddress.Any, 0);

            Socket sd = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

            sd.ReceiveBufferSize = 2048;
            sd.Blocking = false;
            sd.Bind(myLocalEndpoint);

            return sd;
        }

        internal FramePacket ReceivePacket()
        {

            if (mySocket.Available == 0) return null;

            int received = 0;
            string message;
            int framesToWait;

            EndPoint myRemoteEndpoint = new IPEndPoint(serverIp, serverPort);

            byte[] receiveBytes = new byte[mySocket.Available];

            try
            {
                received = mySocket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);
            }
            catch (Exception e)
            {
                return new FramePacket(e);
            }
            if (received < 1026)
            {
                // byte Array in Zeichenkette wandeln
                ASCIIEncoding enc = new ASCIIEncoding();
                message = enc.GetString(receiveBytes);
                // Game Over?
                if (message.StartsWith(GameOver))
                    return new FramePacket(true);
                // serverIp busy?
                Regex pattern = new Regex(Busy);
                Match match = pattern.Match(message);
                if (match.Length > 0)
                {
                    try
                    {
                        framesToWait = Convert.ToInt16(match.Groups["frames"].ToString());
                    }
                    catch (Exception e)
                    {
                        return new FramePacket(e);
                    }
                    if (framesToWait == 0)
                    {
                        framesToWait = 100;
                    }
                    Console.WriteLine("Waiting {0} ms", framesToWait);
                    Thread.Sleep(framesToWait > MaxWait ? MaxWait : framesToWait);
                    return ReceivePacket();
                }
            }

            frameReceived = true;
            return FramePacket.FromByteArray(receiveBytes);
        }



        internal void SendPacket(KeysPacket packet, string name)
        {

            byte[] bytCommand = packet.ToByteArray();

            int pret = mySocket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(serverIp, serverPort));

            if (frameReceived == false)
                SendName(name);
        }

        void SendName(string name)
        {
            // Create a UTF-8 encoding.
            UTF8Encoding utf8 = new UTF8Encoding();

            byte[] bytName = new byte[38]; // all bytes will be 0

            // prefix: ctname (usual key packets are prefixed with ctmame, n versus m!)
            bytName[0] = (byte)'c';
            bytName[1] = (byte)'t';
            bytName[2] = (byte)'n';
            bytName[3] = (byte)'a';
            bytName[4] = (byte)'m';
            bytName[5] = (byte)'e';

            int bytIndex = 6;
            int strIndex = 0;
            while (bytIndex < bytName.Length && strIndex < name.Length)
            {
                // Encode the string.
                Byte[] encodedBytes = utf8.GetBytes(name.Substring(strIndex,1));

                if (encodedBytes.Length <= bytName.Length - bytIndex)
                {
                    for (int i = 0; i < encodedBytes.Length; i++)
                        bytName[bytIndex++] = encodedBytes[i];
                }
                else
                    break;
                strIndex++;
            }

            int pret = mySocket.SendTo(bytName, bytName.Length, SocketFlags.None, new IPEndPoint(serverIp, serverPort));

        }

    }
}
