#include "pilot.h"

extern object_vector check_objects[];
void schedule_pos(check_object_types type, object_vector& pos);

pilot::pilot(KeysPacket& keys, ODAD& radar, ship& theShip, GameStatus& theWorldAroundMe)
:m_keys(keys) //create a reference only this way!
,m_yRadar(radar)
,m_yShip(theShip)
,m_yWorld(theWorldAroundMe)
,m_targetVector(MAX_ASTEROIDS)
,m_closeAsteroids(0)
,m_target_count(0)
{
	frame.act = 0;
	frame.last = 0;

	for (int i=0;i<5;i++)
	{
		key_packet[i].key = c_undef;
		key_packet[i].ping = 255;
	}

	ping_byte=0;
	ping_back=0;
}

void pilot::set_new_course(void)
{
	ping_byte++;
	m_keys.clear();   // alle Tasten loslassen
	static int t,t_last;
	static bool startup=true;

	static dir_t keys[3]={c_undef};

	key_packet[4] = key_packet[3];
	key_packet[3] = key_packet[2];
	key_packet[2] = key_packet[1];
	key_packet[1] = key_packet[0];
	key_packet[0].ping = ping_byte;


	if(m_yShip.is_present)
	{
		static unsigned char i_wbArray=0;

		keys[2] = keys[1];
		keys[1] = keys[0];
#if 0
		static int cnt=0;
		switch (cnt)
		{
		case 0:
			m_keys.left(true);
			keys[0] = c_left;
			cnt++;
			break;
		case 1:
			m_keys.left(true);
			keys[0] = c_left;
			cnt++;
			break;
		default:
			m_keys.right(true);
			keys[0] = c_right;
			cnt=0;
			break;
		}
#endif 

		bool found=false;
		for (int i=0;i<5;i++)
		{
			if (key_packet[i].ping eq ping_back)
			{
				switch (key_packet[i].key)
				{
				case c_left:
					i_wbArray += 3*frame.gone;
					break;
				case c_right:
					i_wbArray -= 3*frame.gone;
					break;
				default:
					break;
				}
				key_packet[i].key = c_undef;
				found = true;
				break;
			}
		}

		//if (keys[2] eq c_left)
		//{
		//	i_wbArray += 3*frame.gone;
		//}
		//if (keys[2] eq c_right)
		//{
		//	i_wbArray -= 3*frame.gone;
		//}

		double visible_angle = get_ship_angle();
		//static double last_visible_angle=0;

		//DWORD
		//	act=frame.act,
		//	gone=frame.gone;
		double
			wbAngle = wbTable[i_wbArray]/10.0;

		if ((visible_angle eq 90.0) or (visible_angle eq 270.0))
		{
			for (int i = 0; i < sizeof(wbTable);i++)
			{
				if (wbTable[i] eq visible_angle*10)
				{
					i_wbArray=i;
					wbAngle = wbTable[i_wbArray]/10.0;
					break;
				}
			}
		}

		//printf ("Angle: %4.1f, wb_angle: %4.1f, key: %s, frame: %d, gone: %d\n", 
		//	visible_angle,
		//	wbAngle,
		//	keys[0]==c_left?"links":"rechts",
		//	act,
		//	gone); 

		if (!i_wbArray)
		{
			//startup=false;
		}

		if (abs(visible_angle - wbAngle) > 4)
		{
			wbAngle=visible_angle;
		}

		m_shipAngle_byWB = wbAngle;

		//if (visible_angle eq last_visible_angle)
		//{

		//}

		//last_visible_angle = visible_angle;
	}

	//if (startup)
	//{
	//	return;
	//}


	if (m_yShip.is_present)
	{
		// Schiff in Richtung auf das nchstgelegene Objekt drehen
		// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
		// ship_dx/y/0 und min_dx/y/0 berechnet
		target closest_asteroid;
		m_yRadar.get_closest_asteroid(m_yShip.pos,closest_asteroid);

		target locked_asteroid;
		m_yRadar.get_locked_asteroid(locked_asteroid);

		m_target_count = 0;
		m_closeAsteroids = 0;
		ZeroMemory(m_sector_cnt,sizeof(m_sector_cnt));
		m_yRadar.getTargets(m_target_count,m_targetVector);
		get_sectors();

		//the final target
		target final_target;

		target saucer;	//enthlt das UFO, wenn vorhanden
		m_yRadar.get_saucer(saucer);
		if (saucer.valid)
		{
			saucer.is_saucer=true;
			m_targetVector[m_target_count] = saucer;
			m_target_count++;
		}//ufo bewerten

		//prefere the locked target
		if (locked_asteroid.valid)
		{
			final_target = locked_asteroid;
		}//prefere the locked target

		//there is no locked target->get a new one
		else
		{
			//get the scales
			for (int i_targets=0; i_targets<m_target_count; i_targets++)
			{
				final_target = m_targetVector[i_targets];

				m_targetVector[i_targets].scale = 
					get_saucer_scale(final_target)	         * 5 /*1.9*/
					+ get_distance_scale(final_target)        * 2.5	/*2*/
					+ get_target_collision_scale(final_target)* 2	/*1*/
					//+ get_sector_scale(final_target)	         * 1.3
					//+ get_angle_scale(final_target)	         * 1.2 
					;
			}//get the scales

			//find the target with the highest scale
			if (m_target_count>0)
			{
				final_target = m_targetVector[0];
				for (int i_targets=1; i_targets<m_target_count; i_targets++)
				{
					if (m_targetVector[i_targets].scale > final_target.scale)
					{
						final_target = m_targetVector[i_targets];
					}
				}
			}//find the target with the highest scale
			//m_yRadar.get_closest_asteroid(m_yShip.pos,final_target);

			//so now try to lock that thing
			m_yRadar.lock_target(final_target);

		}//there is no locked target->get a new one


		schedule_pos(enm_obj_target, final_target.pos);
		schedule_pos(enm_obj_target_dir,(final_target.pos + 
			(final_target.speed / sqrt(final_target.speed.get_length())) * 50.0));

		double smallest_distance = INT_MAX;
		if (closest_asteroid.valid)
		{
			//for hyperspace:
			smallest_distance=sqrt(closest_asteroid.pos.get_distance(m_yShip.pos));
		}

		if (final_target.valid)
		{
			//target hat ein speed in ppms (points per millisecond)
			double time_to_kill=0;
			double distance=0;

			target pos_to_aim = final_target;

			bool some_condition = true;
			const int c_iterations=5;
			int cnt=0;
			double dist[c_iterations]={0};
			double delta_dist[c_iterations]={0};

			//         printf("pos.x: %8.1f  pos.y: %8.1f\n", pos_to_aim.pos.x, pos_to_aim.pos.y);
			pos_to_aim.pos = pos_to_aim.pos - m_yShip.pos;

			while (pos_to_aim.pos.x < -512) pos_to_aim.pos.x += 1024;
			while (pos_to_aim.pos.x > 511) pos_to_aim.pos.x -= 1024;

			while (pos_to_aim.pos.y < -384) pos_to_aim.pos.y += 768;
			while (pos_to_aim.pos.y > 383) pos_to_aim.pos.y -= 768;

			final_target = pos_to_aim;

			while (some_condition)
			{
				distance = sqrt(pos_to_aim.pos.get_length());
				dist[cnt] = distance;
				if(cnt>0)
				{
					delta_dist[cnt] = fabs(dist[cnt-1]-dist[cnt]);
					if (((delta_dist[cnt] > delta_dist[cnt-1]) and (cnt > 2)) or
						(delta_dist[cnt] < 1))
					{
						break;
					}
				}
				else
				{
					delta_dist[cnt] = 0;
				}

				//v=s/t->t=s/v
				//v_schuss: 8 pixel/frame, 60 Frames pro Sekunde
				//			480 pixel pro sekunde->0.48 pixel pro millisekunde
				//TODO: schussgschwindkeit und schiffgeschwindigkeit addieren (geometrisch!)
				time_to_kill = distance / 0.48;
				pos_to_aim.pos.x = final_target.pos.x + (pos_to_aim.speed.x * time_to_kill); 
				pos_to_aim.pos.y = final_target.pos.y + (pos_to_aim.speed.y * time_to_kill); 

				cnt++;
				if (cnt >= c_iterations)
				{
					some_condition = false;
				}

			}

			pos_to_aim.pos = m_yShip.pos + pos_to_aim.pos;

			schedule_pos(enm_obj_aim, pos_to_aim.pos);

			target turn_direction;

			turn_direction.pos.x = pos_to_aim.pos.x;
			turn_direction.pos.y = pos_to_aim.pos.y;
			turn_direction.pos = m_yShip.pos - turn_direction.pos;

			//the cross product will give information about the direction in which we need to turn
			double bogenmass=(m_shipAngle_byWB*PI)/180;
			m_yShip.dir.x = 1536*cos(bogenmass);
			m_yShip.dir.y = 1536*sin(bogenmass);


			double cross_product = 
				m_yShip.dir.x * turn_direction.pos.y - 
				m_yShip.dir.y * turn_direction.pos.x;



			//double target_to_ship=get_target_angle_related_to_ship(pos_to_aim);
			double target_to_ship=get_target_angle_related_to_ship(turn_direction);
			double d_angle = target_to_ship-m_shipAngle_byWB;

#if 0
			pos_to_aim.dir = pos_to_aim.pos - m_yShip.pos;

			double cross_product = 
				m_yShip.dir.x * (m_yShip.pos.y - (pos_to_aim.pos.y + pos_to_aim.dir.y)) - 
				m_yShip.dir.y * (m_yShip.pos.x - (pos_to_aim.pos.x + pos_to_aim.dir.x));
#endif
			//	printf("cross_product: %8.1f distance: %8.1f\n",cross_product,distance);

			if ((cross_product > 0) or (m_target_count == 0))
				//if (d_angle < 0)
			{
				m_keys.right(true);
				keys[0] = c_right;
				key_packet[0].key = c_right;
			}
			else
			{
				m_keys.left(true);
				keys[0] = c_left;
				key_packet[0].key = c_left;
			}

			double vis_angle=get_ship_angle();

			/*printf ("target: %4.1f, wb_angle: %4.1f, vis_angle: %4.1f, key: %s, frame: %d, gone: %d\n", 
			target_to_ship,
			m_shipAngle_byWB,
			vis_angle,
			keys[0]==c_left?"left":"right",
			(DWORD)frame.act,
			(DWORD)frame.gone); */

			//printf("{/*WB:*/%d,/*visible:*/%d}\n",(int)(m_shipAngle_byWB*10),(int)(vis_angle*10));
#ifndef __FINAL__
			printf("%d;%d\n",(int)(m_shipAngle_byWB*10),(int)(vis_angle*10));
#endif //__FINAL__

			/*printf("s_pos:(%4.0f,%4.0f),t_pos:(%4.0f,%4.0f),pta_pos(%4.0f,%4.0f),dist:%5.0f,cross_p:(%6.0f)\n",
			m_yShip.pos.x,
			m_yShip.pos.y,
			closest_asteroid.pos.x,
			closest_asteroid.pos.y,
			pos_to_aim.pos.x,
			pos_to_aim.pos.y,
			distance,
			cross_product);*/

			//insert pilot here, be carefull with your speed
			//m_keys.thrust(true);

			double delta_angle=fabs(get_target_angle_related_to_ship(pos_to_aim)-get_ship_angle());

			if ((t%2 eq 0) and (distance < 600) and ((delta_angle < 1000) or (m_closeAsteroids > 1)))
				//if (((distance < 600) and (t%2==0)) or 
				//	((m_yWorld.saucer_present and (t%2==0))))
			{
				m_keys.fire(true);
			}

			// Flucht, wenn Kollision unausweichlich
			if ((collision_alert(closest_asteroid)) and (t%2 eq 0)) 
			{
				m_keys.hyperspace(true);
			}

			/*			static int max= 0;
			if (distance >= 400 && max < 2) // beschleunigen, wenn nichts in der Nhe
			{
			m_keys.thrust(true);
			max++;
			}
			else
			{
			max -=1;
			if(max < 0)
			max = 20;
			}
			*/
		}

		//if ((t % 2== 0) and (distance < 500*500))  // Feuerknopf drcken, so schnell es geht
		//{
		//	m_keys.fire(true);
		//}
		t_last = t;
		t++;
	}//if (m_yWorld.ship_present)
	else
	{
		//kein Schiff, keine Kekse
	}
}

/**
Die Bewertung eines Ziels erfolgt durch Addition der folgenden Werte
Zieltyp
- ist Asteroid	: 1
- ist UFO		: 3
Zielentfernung
- groe Entfernung		: 1
- mittlere Entfernung	: 2
- kleine Entfernung		: 3
notwendiger Drehwinkel
-  -45... 45	: 6
-  -90... 90	: 4
- -135...135	: 2
- grer 135	: 1
*/

/**
* Zieltyp
* - ist Asteroid	: 1
* - ist UFO		: 2
*/
int pilot::get_saucer_scale(target &item)
{
	if (item.is_saucer)
	{
		return 8;
	}
	else
	{
		return 1;
	}
}

/**
* Zielentfernung
* - sehr groe Entfernung	: 0
* - groe Entfernung		: 1
* - mittlere Entfernung	: 2
* - kleine Entfernung		: 3
*/
int pilot::get_distance_scale(target &item)
{
	double distance=sqrt((item.pos+item.speed*100).get_distance(m_yShip.pos));
	if (distance > 600)
	{
		return 0;
	}
	if (distance > 300)
	{
		return 1;
	}
	if (distance > 200)
	{
		m_closeAsteroids++;
		return 2;
	}
	if (distance > 100)
	{
		return 8;
	}

	return 15;
}


int pilot::get_target_collision_scale(target &item)
{
	int scale = 0;
	object_vector closest_spot;
	double lambda = 0.0;
	double passing_distance = 0.0;
	double obj_size = 3.0;

	if(0 != (m_yShip.pos.x * item.speed.x - m_yShip.pos.y * item.speed.y))
	{
		//m_yShip.pos.x * (item.pos.x + lambda*item.speed.x) + m_yShip.pos.y * (item.pos.y + lambda*item.speed.y);
		//m_yShip.pos.x * item.pos.x + lambda*m_yShip.pos.x * item.speed.x + m_yShip.pos.y * item.pos.y + lambda* m_yShip.pos.y * item.speed.y;
		//-lambda*m_yShip.pos.x * item.speed.x - lambda* m_yShip.pos.y * item.speed.y = m_yShip.pos.x * item.pos.x + m_yShip.pos.y * item.pos.y;
		//-lambda * (m_yShip.pos.x * item.speed.x - m_yShip.pos.y * item.speed.y) = m_yShip.pos.x * item.pos.x + m_yShip.pos.y * item.pos.y;
		lambda = (item.speed.x * item.pos.x + item.speed.y * item.pos.y - m_yShip.pos.x * item.speed.x - m_yShip.pos.y * item.speed.y)
			/
			(item.speed.x * item.speed.x + item.speed.y * item.speed.y)
			;


		closest_spot = (item.pos - item.speed * lambda);
		passing_distance = sqrt(closest_spot.get_distance(m_yShip.pos));
		switch(item.scale)
		{
		case c_smallSized:
			obj_size += 8;
			break;
		case c_mediumSized:
			obj_size += 16;
			break;
		case c_bigSized:
			obj_size += 32;
			break;
		}

		if(passing_distance <= obj_size)
		{
			scale = 50;
		}
	}
	else
	{
		// DO NOTHING HERE
	}

	return scale;
}

/**
* notwendiger Drehwinkel
* -  -45... 45	: 6
* -  -90... 90	: 4
* - -135...135	: 2
* - grer 135	: 1
*/
int pilot::get_angle_scale(target &item)
{
	double angle=fabs(get_target_angle_related_to_ship(item)-get_ship_angle());
	if (angle < 45)
	{
		return 3;
	}
	if (angle < 90)
	{
		return 2;
	}
	if (angle < 135)
	{
		return 1;
	}
	return 0;

}

/**
* 8 Sektoren:
* 0 ist nach rechts,
* dann, entgegem dem Uhrzeigersinn:
* Winkel < 45 Sektor 0
* Winkel < 90 Sektor 1
* Winkel <135 Sektor 2
* Winkel <180 Sektor 3
* Winkel <225 Sektor 4
* Winkel <270 Sektor 5
* Winkel <315 Sektor 6
* Winkel <360 Sektor 7
*/
void pilot::get_sectors()
{
	double angle=0;
	int sector;
	for (int i = 0; i < m_target_count; i++)
	{
		angle = get_target_angle_related_to_ship(m_targetVector[i]);
		angle *= NUM_SECTORS;
		sector = ((int)(angle)) / 360;
		m_targetVector[i].sector = sector*2;
		m_sector_cnt[sector]++;
	}
}

int pilot::get_sector_scale(target &item)
{
	if (item.sector not_eq INT_MAX)
	{
		return m_sector_cnt[item.sector];
	}
	else
	{
		return 0;
	}
}

double pilot::get_ship_angle()
{
	double angle=0;
	double dx=m_yShip.dir.x;
	double dy=m_yShip.dir.y;
	angle = (180.0/PI) * atan(dy / dx);
	if (dx < 0)
	{
		if (dy <= 0)
		{
			angle += 180;
		}
		else
		{
			angle = 180 - fabs(angle);
		}
	}
	else
	{
		if(dy<0)
		{
			angle += 360;
		}
	}

	return angle;
}

double pilot::get_target_angle_related_to_ship(target& item)
{
	double angle=0;
	double dx=item.pos.x - m_yShip.pos.x;
	double dy=item.pos.y - m_yShip.pos.y;

	target turn_direction;

	turn_direction.pos = item.pos - m_yShip.pos;

	int ast_x = turn_direction.pos.x;
	while (ast_x < -512) ast_x += 1024;
	while (ast_x > 511) ast_x -= 1024;

	int ast_y = turn_direction.pos.y;
	while (ast_y < -384) ast_y += 768;
	while (ast_y > 383) ast_y -= 768;

	dx = turn_direction.pos.x = -ast_x;
	dy = turn_direction.pos.y = -ast_y;


	angle = (180.0/PI) * atan(dy / dx);
	if (dx < 0)
	{
		if (dy <= 0)
		{
			angle += 180;
		}
		else
		{
			angle = 180 - fabs(angle);
		}
	}
	else
	{
		if(dy<0)
		{
			angle += 360;
		}
	}
	return angle;
}

bool pilot::collision_alert(target& item)
{
	double danger_range = 500.0;
	double distance = m_yShip.pos.get_distance(item.pos);

	switch(item.scale)
	{
	case c_smallSized:
		danger_range += 8*8;
		break;
	case c_mediumSized:
		danger_range += 16*16;
		break;
	case c_bigSized:
		danger_range += 32*32;
		break;
	}
	return (distance < danger_range);
#if 0
	RECT ship_rect;
	ship_rect.bottom = m_yShip.pos.y - 20;
	ship_rect.top = m_yShip.pos.y + 20;
	ship_rect.left = m_yShip.pos.x - 20;
	ship_rect.right = m_yShip.pos.x + 20;

	RECT item_rect(item.rect);

	int abs_bot_top = abs(ship_rect.bottom-item_rect.top);
	int abs_top_bot = abs(ship_rect.top-item_rect.bottom);
	int abs_lef_rig = abs(ship_rect.left-item_rect.right);
	int abs_rig_lef = abs(ship_rect.right-item_rect.left);

	const int c_collWarnDist = 10;

	if (((abs_bot_top < c_collWarnDist)	and ((abs_lef_rig < c_collWarnDist) or (abs_rig_lef < c_collWarnDist))) or
		((abs_top_bot < c_collWarnDist)	and ((abs_lef_rig < c_collWarnDist) or (abs_rig_lef < c_collWarnDist)))
		)
	{
		return true;
	}
	else
	{
		return false;
	}
#endif
}

void pilot::set (unsigned char frame_no)
{
	frame.gone = frame_no-frame.last;
	frame.last = frame_no;
	frame.act  = frame_no;
}

void pilot::set_ping(unsigned char in_ping)
{
	ping_back=in_ping;


}

unsigned char pilot::get_ping(void)
{
	return key_packet[0].ping;
}