// output.cpp: Gekapselte Ausgabefunktionen
// Matthias Fuchs

#include "output.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#if defined(WINDOWS) || defined(_WIN32)
#include <windows.h>
#endif

void OutputError	 (const char* str)
{
	fprintf (stderr, "Error: %s\n", str);
}

void OutputError2	(const char* format, ...)
{
	char str[1024];

	va_list arglist;
	va_start(arglist, format);

	vsprintf(str, format, arglist);

	va_end(arglist);

	OutputError (str);
}

void OutputWarning  (const char* str)
{
	fprintf (stderr, "Warning: %s\n", str);
}

void OutputWarning2	(const char* format, ...)
{
	char str[1024];

	va_list arglist;
	va_start(arglist, format);

	vsprintf(str, format, arglist);

	va_end(arglist);

	OutputWarning (str);
}

void OutputInfo	  (const char* str)
{
	fprintf (stdout, "%s\n", str);
}

void OutputInfo2	 (const char* format, ...)
{
	char str[1024];

	va_list arglist;
	va_start(arglist, format);

	vsprintf(str, format, arglist);

	va_end(arglist);

	OutputInfo (str);
}

void OutputDebug	 (const char* str)
{
#if defined(WINDOWS) || defined(_WIN32)
	OutputDebugStringA (str);
#else
	fprintf (stderr, "Debug: %s\n", str);
#endif
}

void OutputDebug2	(const char* format, ...)
{
	char str[1024];

	va_list arglist;
	va_start(arglist, format);

	vsprintf(str, format, arglist);

	va_end(arglist);

	OutputDebug (str);
}


