
#ifndef _KONSTANTEN_H
#define _KONSTANTEN_H

#include <vector>
#include "Types\vector2.h"

using std::vector;

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 16;

// Globale Variablen===================
static const int ARTIFICIAL_LATENCY = 8; 
static const int SPEED_AVERAGING = 8;

static const float Pi = 3.1415926535897932384626433832795;
static const float FRAMERATE = 60;
static const float TIMESTEP = 8; 
static const float SHOT_VELOCITY = 8; 
static const float SHOT_OFFSET = 12;
static const float ROTATION_ANGLE = 6 * Pi / (float) 256; // ca. 0.0736
static const float THRUST_FORCE = 0.0625;

static const int SCREEN_MIN_X = 0;
static const int SCREEN_MAX_X = 1023;
static const int SCREEN_MIN_Y = 128;
static const int SCREEN_MAX_Y = 895;

static const int SCREEN_SIZE_X = 1024;
static const int SCREEN_SIZE_Y = 768;
static const Vector2 ScreenSize(SCREEN_SIZE_X, SCREEN_SIZE_Y);
static const Vector2 ScreenMidpoint((SCREEN_MIN_X + SCREEN_MAX_X) / 2, 
									(SCREEN_MIN_Y + SCREEN_MAX_Y) / 2);

const int TYPE_ASTEROID = 10;
const int TYPE_EXPLOSION = 20;
const int TYPE_SAUCER = 30;
const int TYPE_SHIP = 40;
const int TYPE_SHOT = 50;

const int RADIUS_SMALL = 10;
const int RADIUS_SHIP = 16;
const int RADIUS_MEDIUM = 20;
const int RADIUS_BIG = 40;

const int GAMEMODE_ATTACK = 10;
const int GAMEMODE_MOVETOCENTER = 20;
const int GAMEMODE_JIG = 30;
const int GAMEMODE_CALIBRATE = 40;
const int GAMEMODE_TEST = 50;

const int TASK_FIRE = 10;
const int TASK_TURNLEFT = 20;
const int TASK_TURNRIGHT = 30;
const int TASK_HYPERSPACE = 40;
const int TASK_THRUST = 50;
const int TASK_NEWOBJECT = 60;

const int OUTPUT_COL_WIDTH = 15;
const int STATS_REFRESH_RATE = 20;

static const int VIEWSTEP_COUNT = 64;
static const int BAYES_SIZE_BELIEF = 256;

// Schalter ===========================
const bool STATS_ON = false; 


// Utilities ==========================
float normalizeAngle(float f);
float subtractAngles(float f, float fa);
float sgn(float x);


#endif // _KONSTANTEN_H
