package de.curdreinert.asteroids.screenobject;

import de.curdreinert.asteroids.geometry.Vector;

public class Ship extends ScreenObject {

	private Vector viewDirection;

	public Ship(int x, int y, int dx, int dy) {
		super(x, y);
		viewDirection = new Vector(dx, dy);
	}

	public String getName() {
		return "Ship";
	}

	public String toString() {
		return super.toString() + ", facing " + viewDirection.degree();
	}

	public Vector getViewDirection() {
		return viewDirection;
	}
}
