package de.curdreinert.asteroids.base;

public class Statistics {

	private static Statistics current = null;

	public static void start() {
		current = new Statistics();
	}

	public static Statistics getCurrent() {
		return current;
	}

	private long started;

	private long finished = -1;

	private int score;

	private int hyperspaces;

	public Statistics() {
		started = System.currentTimeMillis();
	}

	public void finish(int score) {
		this.score = score;
		finished = System.currentTimeMillis();
	}

	public String toString() {
		String result = "";
		long end = finished;
		if (end == -1) {
			result += "Game going on\n";
			end = System.currentTimeMillis();
		} else {
			result += "Game over.\n";
			result += "Final score: " + score + "\n";
		}
		long delta = end - started;
		result += "Duration: " + (delta / 60000) + ":"
				+ String.format("%02d", (delta / 1000) % 60) + "."
				+ String.format("%03d", delta % 1000) + "\n";
		result += "Hyperspaced: " + hyperspaces + "\n";
		return result;
	}

	public void hyperspacing() {
		hyperspaces++;
	}

}
