using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace ct.Asteroid
{
  public class CTargets
  {
    private static CompareCollisionHit compareCollsionHit = new CompareCollisionHit();
    private static CompareAsteroidGroesse compareAsteroidGroesse = new CompareAsteroidGroesse();
    private static CompareAsteroidEntfernung compareAsteroidEntfernung = new CompareAsteroidEntfernung();
    private static CompareAsteroidHitDrehung compareAsteroidHitDrehung = new CompareAsteroidHitDrehung();

    public static int Internal_counter = 0;
    public static int max_shots = 4;
    public static ArrayList Asteroids = new ArrayList(128);
    public static ArrayList HitList = new ArrayList(128);
    public static Hashtable AsteroidsHash = new Hashtable();
    public static ArrayList Shots = new ArrayList(16);
    public static Hashtable ShotsHash = new Hashtable();
    public static CSaucer Saucer = new CSaucer();
    public static CShip Ship = new CShip();
    public static int serialnummer = 1000;
    public static int Shotnumber = 1000;
    public static int hitSerialnummer = 0;
    public static void setShip ( int x, int y, int dx, int dy, int frameNumber )
    {
      string hashKey;
      hashKey = dx.ToString() + " " + dy.ToString();
      Ship.SetPosition(x, y, frameNumber);
      Ship.Drehung = CDrehung.getDrehung(dx, dy);
      //Console.Write(Ship.Drehung.Nummer.ToString() + ",");
    }
    public static void setSaucer ( int x, int y, int sf, int frameNumber )
    {
      switch (sf)
      {
        case 15: Saucer.groesse = SaucerGroesse.GROSS; break;
        case 14: Saucer.groesse = SaucerGroesse.MITTEL; break;
        default: Saucer.groesse = SaucerGroesse.UNKNOWN; break;
      }
      Saucer.SetPosition(x, y, frameNumber);
    }
    public static void setShot ( int x, int y, int frameNumber, int nummer )
    {
      CPunkt newPosition = new CPunkt(x, y);
      CPunkt newShotPosition;
      CShot tmp_Shot = null;
      double tmpDist, min_Dist = 0x1FFFFF, help_Dist;
      int delta_frame;
      Shots.Sort();
      min_Dist = 5.0;
      #region Shots.Count > nummer
      if (Shots.Count > nummer)
      {
        tmp_Shot = Shots[nummer] as CShot;
        delta_frame = frameNumber - tmp_Shot.AktuellerFrame;
        if (delta_frame < 0) delta_frame += 255;
        newShotPosition = tmp_Shot.Berechneposition(delta_frame);
        if (newShotPosition != null)
        {
          tmpDist = newPosition.Entfernung_XY(newShotPosition);
          if (tmpDist < min_Dist)
          {
            tmp_Shot.SetPosition(x, y, frameNumber);
            checkTarget(tmp_Shot);
            return; // gefunden -> weiter;
          }
        }
        else
        {
          if (tmp_Shot.Fluggeschwindigkeit > 0)
          {
            tmpDist = newPosition.Entfernung_XY(tmp_Shot.Aktuelleposition);
            help_Dist = tmp_Shot.Aktuelleposition.Entfernung_XY(tmp_Shot.Startposition) / tmp_Shot.Flugzeit;
            if (Math.Abs(tmpDist - help_Dist) < min_Dist)
            {
              tmp_Shot.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
          else
          {
            tmpDist = newPosition.Entfernung_XY(tmp_Shot.Startposition);
            if (tmpDist < 12)
            {
              tmp_Shot.SetPosition(x, y, frameNumber);
              return;
            }
          }
        }
        tmp_Shot = null;
      }
      #endregion
      min_Dist = 5.0;
      #region CShot al_shot in Shots mit "newShotPosition"
      foreach (CShot al_shot in Shots)
      {
        delta_frame = frameNumber - al_shot.AktuellerFrame;
        if (delta_frame == 0) continue; //schon gesetzt
        if (delta_frame < 0) delta_frame += 255;
        newShotPosition = al_shot.Berechneposition(delta_frame);
        if (newShotPosition == null) continue; // 
        tmpDist = newPosition.Entfernung_XY(newShotPosition);
        if (tmpDist < min_Dist)
        {
          tmp_Shot = al_shot;
          min_Dist = tmpDist;
        }
      }
      if (tmp_Shot != null)
      {
        tmp_Shot.SetPosition(x, y, frameNumber);
        tmp_Shot.Nummer = nummer;
        return;
      }
      #endregion
      #region CShot al_shot in Shots ohne "newShotPosition"
      foreach (CShot al_shot in Shots)
      {
        delta_frame = frameNumber - al_shot.AktuellerFrame;
        if (delta_frame == 0) continue; //schon gesetzt
        if (delta_frame < 0) delta_frame += 255;
        if (al_shot.Fluggeschwindigkeit > 0)
        {
          if (al_shot.Aktuelleposition != null)
          {
            tmpDist = newPosition.Entfernung_XY(al_shot.Aktuelleposition);
            help_Dist = al_shot.Aktuelleposition.Entfernung_XY(al_shot.Letzteposition) / al_shot.letzte_Flugzeit;
            if (Math.Abs(tmpDist - help_Dist) < min_Dist)
            {
              al_shot.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
          else if (al_shot.Letzteposition != null)
          {
            tmpDist = newPosition.Entfernung_XY(al_shot.Letzteposition);
            min_Dist = al_shot.Letzteposition.Entfernung_XY(al_shot.Startposition);
            if ((tmpDist - min_Dist) < min_Dist)
            {
              al_shot.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
        }
        else
        {
          tmpDist = newPosition.Entfernung_XY(al_shot.Startposition);
          if (tmpDist < 12)
          {
            al_shot.SetPosition(x, y, frameNumber);
            return;
          }
        }
      }
      #endregion
      tmp_Shot = new CShot();
      tmp_Shot.SetPosition(x, y, frameNumber);
      tmp_Shot.Nummer = Shots.Count;
      tmp_Shot.Serialnummer = Shotnumber;
      if (AsteroidsHash.ContainsKey(hitSerialnummer))
      {
        tmp_Shot.Target_Serialnummer = hitSerialnummer;
      }
      Shotnumber++;
      tmp_Shot.type = ShotType.SHIP;
      if (Saucer.Aktuelleposition != null)
      {
        if (newPosition.Entfernung_XY(Ship.Aktuelleposition) > newPosition.Entfernung_XY(Saucer.Aktuelleposition))
        {
          tmp_Shot.type = ShotType.SAUCER;
        }
      }
      Shots.Add(tmp_Shot);
      ShotsHash.Add(tmp_Shot.Serialnummer, tmp_Shot);
      // TargetData.ConsoleWriteLine("[{3}]Neuer Shot({0}): {1:000} - {2:000}", tmp_Shot.type, x, y, tmp_Shot.Nummer);
    }
    public static void setShot_old ( int x, int y, int frameNumber, int nummer )
    {
      CPunkt newPosition = new CPunkt(x, y);
      CPunkt newShotPosition;
      CShot tmp_Shot = null;
      double tmpDist, min_Dist = 0x1FFFFF, help_Dist;
      int delta_frame;
      Shots.Sort();
      min_Dist = 5.0;
      #region Shots.Count > nummer
      if (Shots.Count > nummer)
      {
        tmp_Shot = Shots[nummer] as CShot;
        delta_frame = frameNumber - tmp_Shot.AktuellerFrame;
        if (delta_frame < 0) delta_frame += 255;
        newShotPosition = tmp_Shot.Berechneposition(delta_frame);
        if (newShotPosition != null)
        {
          tmpDist = newPosition.Entfernung_XY(newShotPosition);
          if (tmpDist < min_Dist)
          {
            tmp_Shot.SetPosition(x, y, frameNumber);
            return; // gefunden -> weiter;
          }
        }
        else
        {
          if (tmp_Shot.Fluggeschwindigkeit > 0)
          {
            if (tmp_Shot.Aktuelleposition != null)
            {
              tmpDist = newPosition.Entfernung_XY(tmp_Shot.Aktuelleposition);
              help_Dist = tmp_Shot.Aktuelleposition.Entfernung_XY(tmp_Shot.Startposition) / tmp_Shot.Flugzeit;
              if (Math.Abs(tmpDist - help_Dist) < min_Dist)
              {
                tmp_Shot.SetPosition(x, y, frameNumber);
                return; // gefunden -> weiter;
              }
            }
            else if (tmp_Shot.Letzteposition != null)
            {
              tmpDist = newPosition.Entfernung_XY(tmp_Shot.Letzteposition);
              min_Dist = tmp_Shot.Letzteposition.Entfernung_XY(tmp_Shot.Startposition);
              if ((tmpDist - min_Dist) < min_Dist)
              {
                tmp_Shot.SetPosition(x, y, frameNumber);
                return; // gefunden -> weiter;
              }
            }
          }
          else
          {
            tmpDist = newPosition.Entfernung_XY(tmp_Shot.Startposition);
            if (tmpDist < 12)
            {
              tmp_Shot.SetPosition(x, y, frameNumber);
              return;
            }
          }
        }
        tmp_Shot = null;
      }
      #endregion
      min_Dist = 5.0;
      #region CShot al_shot in Shots mit "newShotPosition"
      foreach (CShot al_shot in Shots)
      {
        delta_frame = frameNumber - al_shot.AktuellerFrame;
        if (delta_frame == 0) continue; //schon gesetzt
        if (delta_frame < 0) delta_frame += 255;
        newShotPosition = al_shot.Berechneposition(delta_frame);
        if (newShotPosition == null) continue; // 
        tmpDist = newPosition.Entfernung_XY(newShotPosition);
        if (tmpDist < min_Dist)
        {
          tmp_Shot = al_shot;
          min_Dist = tmpDist;
        }
      }
      if (tmp_Shot != null)
      {
        tmp_Shot.SetPosition(x, y, frameNumber);
        tmp_Shot.Nummer = nummer;
        return;
      }
      #endregion
      #region CShot al_shot in Shots ohne "newShotPosition"
      foreach (CShot al_shot in Shots)
      {
        delta_frame = frameNumber - al_shot.AktuellerFrame;
        if (delta_frame == 0) continue; //schon gesetzt
        if (delta_frame < 0) delta_frame += 255;
        if (al_shot.Fluggeschwindigkeit > 0)
        {
          if (al_shot.Aktuelleposition != null)
          {
            tmpDist = newPosition.Entfernung_XY(al_shot.Aktuelleposition);
            help_Dist = al_shot.Aktuelleposition.Entfernung_XY(al_shot.Letzteposition) / al_shot.letzte_Flugzeit;
            if (Math.Abs(tmpDist - help_Dist) < min_Dist)
            {
              al_shot.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
          else if (al_shot.Letzteposition != null)
          {
            tmpDist = newPosition.Entfernung_XY(al_shot.Letzteposition);
            min_Dist = al_shot.Letzteposition.Entfernung_XY(al_shot.Startposition);
            if ((tmpDist - min_Dist) < min_Dist)
            {
              al_shot.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
        }
        else
        {
          tmpDist = newPosition.Entfernung_XY(al_shot.Startposition);
          if (tmpDist < 12)
          {
            al_shot.SetPosition(x, y, frameNumber);
            return;
          }
        }
      }
      #endregion
      tmp_Shot = new CShot();
      tmp_Shot.SetPosition(x, y, frameNumber);
      tmp_Shot.Nummer = Shots.Count;
      tmp_Shot.Serialnummer = Shotnumber;
      tmp_Shot.Target_Serialnummer = hitSerialnummer;
      Shotnumber++;
      tmp_Shot.type = ShotType.SHIP;
      if (Saucer.Aktuelleposition != null)
      {
        if (newPosition.Entfernung_XY(Ship.Aktuelleposition) > newPosition.Entfernung_XY(Saucer.Aktuelleposition))
        {
          tmp_Shot.type = ShotType.SAUCER;
        }
      }
      Shots.Add(tmp_Shot);
      ShotsHash.Add(tmp_Shot.Serialnummer, tmp_Shot);
      // TargetData.ConsoleWriteLine("[{3}]Neuer Shot({0}): {1:000} - {2:000}", tmp_Shot.type, x, y, tmp_Shot.Nummer);
    }
    public static void setAsteroid ( int x, int y, int frameNumber, int sf, int type, int nummer )
    {
      AsteroidType asteroidType = AsteroidType.UNKNOWN;
      AsteroidGroesse asteroidGroesse = AsteroidGroesse.UNKNOWN;
      int Punktwert = 0;
      CPunkt newPosition = new CPunkt(x, y);
      CPunkt newAsteroidPosition;
      double tmpDist, min_Dist = 0x1FFFFF, help_Dist;
      int delta_frame;
      Asteroids.Sort(); // Sortierung nach CAsteroid.Nummer
      switch (type)
      {
        case 1: asteroidType = AsteroidType.EINS; break;
        case 2: asteroidType = AsteroidType.ZWEI; break;
        case 3: asteroidType = AsteroidType.DREI; break;
        case 4: asteroidType = AsteroidType.VIER; break;
        default: asteroidType = AsteroidType.UNKNOWN; break;
      }
      switch (sf)
      {
        case 0: asteroidGroesse = AsteroidGroesse.GROSS; Punktwert = 520; break;
        case 14: asteroidGroesse = AsteroidGroesse.KLEIN; Punktwert = 100; break;
        case 15: asteroidGroesse = AsteroidGroesse.MITTEL; Punktwert = 250; break;
        default: asteroidGroesse = AsteroidGroesse.UNKNOWN; Punktwert = 0; break;
      }
      CAsteroid tmp_Asteroid = null;
      min_Dist = 5.0; // ziemlich weit weg ?!
      if (Asteroids.Count > nummer)
      {
        tmp_Asteroid = Asteroids[nummer] as CAsteroid;
        delta_frame = frameNumber - tmp_Asteroid.AktuellerFrame;
        if (delta_frame < 0) delta_frame += 255;
        if (delta_frame != 0 &&
             tmp_Asteroid.groesse == asteroidGroesse &&
             tmp_Asteroid.type == asteroidType)
        {
          newAsteroidPosition = tmp_Asteroid.Berechneposition(delta_frame);
          if (newAsteroidPosition != null)
          {
            //            tmpDist = newPosition.Entfernung(newAsteroidPosition);
            tmpDist = newPosition.Entfernung_XY(newAsteroidPosition);
            if (tmpDist < min_Dist)
            {
              tmp_Asteroid.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
          else
          {
            if (tmp_Asteroid.Fluggeschwindigkeit > 0)
            {
              if (tmp_Asteroid.Aktuelleposition != null)
              {
                //tmpDist = newPosition.Entfernung(tmp_Asteroid.Aktuelleposition);
                tmpDist = newPosition.Entfernung_XY(tmp_Asteroid.Aktuelleposition);
                //help_Dist = tmp_Asteroid.Aktuelleposition.Entfernung(tmp_Asteroid.Startposition) / tmp_Asteroid.Flugzeit;
                help_Dist = tmp_Asteroid.Aktuelleposition.Entfernung_XY(tmp_Asteroid.Startposition) / tmp_Asteroid.Flugzeit;
                if (Math.Abs(tmpDist - help_Dist) < min_Dist)
                {
                  tmp_Asteroid.SetPosition(x, y, frameNumber);
                  return; // gefunden -> weiter;
                }
              }
              else if (tmp_Asteroid.Letzteposition != null)
              {
                //tmpDist = newPosition.Entfernung(tmp_Asteroid.Letzteposition);
                tmpDist = newPosition.Entfernung_XY(tmp_Asteroid.Letzteposition);
                //min_Dist = tmp_Asteroid.Letzteposition.Entfernung(tmp_Asteroid.Startposition);
                min_Dist = tmp_Asteroid.Letzteposition.Entfernung_XY(tmp_Asteroid.Startposition);
                if ((tmpDist - min_Dist) < min_Dist)
                {
                  tmp_Asteroid.SetPosition(x, y, frameNumber);
                  return; // gefunden -> weiter;
                }
              }
            }
            else
            {
              //tmpDist = newPosition.Entfernung(tmp_Asteroid.Startposition);
              tmpDist = newPosition.Entfernung_XY(tmp_Asteroid.Startposition);
              if (tmpDist < 10)
              {
                tmp_Asteroid.SetPosition(x, y, frameNumber);
                return;
              }
            }
          }
        }
        tmp_Asteroid = null;
      }
      min_Dist = 5.0;
      foreach (CAsteroid al_asteroid in Asteroids)
      {
        delta_frame = frameNumber - al_asteroid.AktuellerFrame;
        if (delta_frame == 0) continue; //schon gesetzt
        if (delta_frame < 0) delta_frame += 255;
        if (al_asteroid.groesse != asteroidGroesse) continue; //Groesse stimmt nicht
        if (al_asteroid.type != asteroidType) continue; //Type stimmt nicht
        newAsteroidPosition = al_asteroid.Berechneposition(delta_frame);
        if (newAsteroidPosition == null) continue; // 
        //tmpDist = newPosition.Entfernung(newAsteroidPosition);
        tmpDist = newPosition.Entfernung_XY(newAsteroidPosition);
        if (tmpDist < min_Dist)
        {
          tmp_Asteroid = al_asteroid;
          min_Dist = tmpDist;
        }
      }
      if (tmp_Asteroid != null)
      {
        tmp_Asteroid.SetPosition(x, y, frameNumber);
        tmp_Asteroid.Nummer = nummer;
        return;
      }
      foreach (CAsteroid al_asteroid in Asteroids)
      {
        delta_frame = frameNumber - al_asteroid.AktuellerFrame;
        if (delta_frame == 0) continue; //schon gesetzt
        if (delta_frame < 0) delta_frame += 255;
        if (al_asteroid.groesse != asteroidGroesse) continue; //Groesse stimmt nicht
        if (al_asteroid.type != asteroidType) continue; //Type stimmt nicht
        if (al_asteroid.Fluggeschwindigkeit > 0)
        {
          if (al_asteroid.Aktuelleposition != null)
          {
            //tmpDist = newPosition.Entfernung(al_asteroid.Aktuelleposition);
            tmpDist = newPosition.Entfernung_XY(al_asteroid.Aktuelleposition);
            //help_Dist = al_asteroid.Aktuelleposition.Entfernung(al_asteroid.Startposition) / al_asteroid.Flugzeit;
            help_Dist = al_asteroid.Aktuelleposition.Entfernung_XY(al_asteroid.Startposition) / al_asteroid.Flugzeit;
            if (Math.Abs(tmpDist - help_Dist) < min_Dist)
            {
              al_asteroid.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
          else if (al_asteroid.Letzteposition != null)
          {
            //tmpDist = newPosition.Entfernung(al_asteroid.Letzteposition);
            tmpDist = newPosition.Entfernung_XY(al_asteroid.Letzteposition);
            //min_Dist = al_asteroid.Letzteposition.Entfernung(al_asteroid.Startposition);
            min_Dist = al_asteroid.Letzteposition.Entfernung_XY(al_asteroid.Startposition);
            if ((tmpDist - min_Dist) < min_Dist)
            {
              al_asteroid.SetPosition(x, y, frameNumber);
              return; // gefunden -> weiter;
            }
          }
        }
        else
        {
          tmpDist = newPosition.Entfernung_XY(al_asteroid.Startposition);
          tmpDist = newPosition.Entfernung(al_asteroid.Startposition);
          if (tmpDist < 10)
          {
            al_asteroid.SetPosition(x, y, frameNumber);
            return;
          }
        }
      }
      tmp_Asteroid = new CAsteroid();
      tmp_Asteroid.SetPosition(x, y, frameNumber);
      tmp_Asteroid.Nummer = Asteroids.Count;
      tmp_Asteroid.groesse = asteroidGroesse;
      tmp_Asteroid.Punktwert = Punktwert;
      tmp_Asteroid.Radius = (int)asteroidGroesse;
      tmp_Asteroid.Serialnummer = ++serialnummer;
      if (tmp_Asteroid.groesse == AsteroidGroesse.GROSS) tmp_Asteroid.Parentnummer = tmp_Asteroid.Serialnummer;
      else tmp_Asteroid.Parentnummer = 0;
      tmp_Asteroid.type = asteroidType;
      Asteroids.Add(tmp_Asteroid);
      AsteroidsHash.Add(tmp_Asteroid.Serialnummer, tmp_Asteroid);
      //TargetData.ConsoleWriteLine("Neuer Astroid({0}): {1} - {2:000} - {3:000}", tmp_Asteroid.Nummer, tmp_Asteroid.groesse, x, y); 
    }
    public static void CleanUpShots ( int actualFrame )
    {
      CShot shot;
      int SNR;
      //string tmpStr = "";
      //foreach (CShot al_shot in Shots)
      //{ 
      //    tmpStr += string.Format("[{0}-{1}]-{2}", al_shot.Serialnummer, al_shot.Target_Serialnummer, al_shot.Hit_Frame);
      //}
      //TargetData.ConsoleWriteLine(tmpStr);
      for (int i = Shots.Count - 1; i > -1; i--)
      {
        shot = Shots[i] as CShot;
        if (shot.AktuellerFrame != actualFrame)
        {
          SNR = shot.Serialnummer;
          foreach (CAsteroid al_asteroid in Asteroids)
          {
            if (al_asteroid.Shots.ContainsKey(SNR))
            {
              al_asteroid.Shots.Remove(SNR);
            }
          }
          if (ShotsHash.ContainsKey(SNR)) ShotsHash.Remove(SNR);
          Shots.RemoveAt(i);
        }
      }
    }
    public static void CleanUpAsteroids ( int actualFrame )
    {
      CAsteroid asteroid;
      AsteroidGroesse help_groesse = AsteroidGroesse.UNKNOWN;
      int SNR = 0, PSNR = 0;
      for (int i = Asteroids.Count - 1; i > -1; i--)
      {
        asteroid = Asteroids[i] as CAsteroid;
        help_groesse = asteroid.groesse;
        if (asteroid.AktuellerFrame != actualFrame)
        {
          SNR = asteroid.Serialnummer;
          if (AsteroidsHash.ContainsKey(SNR)) AsteroidsHash.Remove(SNR);
          Asteroids.RemoveAt(i);
          if (help_groesse == AsteroidGroesse.KLEIN) PSNR = 0;
          else PSNR = asteroid.Parentnummer;
          if (PSNR > 0)
          {
            if (help_groesse == AsteroidGroesse.GROSS) help_groesse = AsteroidGroesse.MITTEL;
            else if (help_groesse == AsteroidGroesse.MITTEL) help_groesse = AsteroidGroesse.KLEIN;
            else TargetData.ConsoleWrite("Fehler in CleanUpAsteroids");
            foreach (CAsteroid al_asteroid in CTargets.Asteroids)
            {
              if (al_asteroid.groesse == help_groesse && al_asteroid.Parentnummer == 0)
              {
                al_asteroid.Parentnummer = PSNR;
              }
            }
          }
        }
      }
    }
    private static void checkTarget ( CShot checkShot )
    {
      CPunkt ShotFuturePos, AsteroidFuturePos;
      CAsteroid HitAsteroid = null;
      int asteroid_Groesse = 0, min_Hit = 1000;
      int distance;
      checkShot.Hit_Serialnummer = 0;
      checkShot.Hit_Frame = 0;
      if (checkShot.FuturePositions.Count > 1)
      {
        foreach (CAsteroid al_asteroid in Asteroids)
        {
          if (al_asteroid.Shots.ContainsKey(checkShot.Serialnummer))
          {
            al_asteroid.Shots.Remove(checkShot.Serialnummer);
          }
          if (al_asteroid.FuturePositions.Count < 2)
          {
            continue;
          }
          asteroid_Groesse = (int)al_asteroid.Radius / 2;
          //asteroid_Groesse =(int) (asteroid_Groesse / (al_asteroid.Position.Entfernung(checkShot.Position) / 150));
          if (al_asteroid.FuturePositions.Count < 10) continue;
          for (int i = 0; i < checkShot.FuturePositions.Count; i++)
          {
            ShotFuturePos = checkShot.FuturePositions[i] as CPunkt;
            AsteroidFuturePos = al_asteroid.FuturePositions[i] as CPunkt;
            distance = (int)ShotFuturePos.Entfernung_XY(AsteroidFuturePos);
            if (distance < asteroid_Groesse)
            {
              if (min_Hit > i)
              {
                min_Hit = i;
                //TargetData.ConsoleWriteLine("{2}-Check: {0} {1} [{3}] [{4}]", distance, asteroid_Groesse, min_Hit, checkShot.Serialnummer, al_asteroid.Serialnummer);
                HitAsteroid = al_asteroid;
                break;
              }
            }
          }
        }
        if (HitAsteroid != null)
        {
          if (!HitAsteroid.Shots.ContainsKey(checkShot.Serialnummer))
          {
            //TargetData.ConsoleWriteLine("[{0}] trifft [{1}] in {2}", checkShot.Serialnummer, HitAsteroid.Serialnummer, min_Hit);
            checkShot.Hit_Serialnummer = HitAsteroid.Serialnummer;
            checkShot.Hit_Frame = min_Hit;
            HitAsteroid.Shots.Add(checkShot.Serialnummer, min_Hit);
          }
          else
          {
            TargetData.ConsoleWriteLine("MIST - drfte nicht sein");
            HitAsteroid.Shots[checkShot.Serialnummer] = min_Hit;
          }
        }
      }

    }
    #region Taktik
    int tmpInt = 0;
    public static int getCollisionObject ( int SNR )
    {
      int returnSNR = SNR;
      int min_dist = 0x1FFFFF, tmpInt;
      TargetData.ConsoleWriteLine("Kollision ??");
      ArrayList SNRList = getCollisionObjects();
      CAsteroid asteroid = null;
      foreach (int al_SNR in SNRList)
      {
        if (AsteroidsHash.ContainsKey(al_SNR))
        {
          asteroid = AsteroidsHash[al_SNR] as CAsteroid;
          tmpInt = asteroid.HitShip;
          if (tmpInt > 0)
          {
            if (tmpInt < min_dist)
            {
              min_dist = tmpInt;
              returnSNR = asteroid.Serialnummer;
              TargetData.ConsoleWriteLine("Kollision: [{0}]-{1}", returnSNR, min_dist);
            }
          }
        }
      }
      return returnSNR;
    }
    public static ArrayList getCollisionObjects ()
    {
      ArrayList returnSNRList = new ArrayList(16);
      foreach (CAsteroid al_asteroid in CTargets.Asteroids)
      {
        if (al_asteroid.HitShip > 0)
        {
          returnSNRList.Add(al_asteroid);
        }
      }
      return returnSNRList;
    }
    public static ArrayList getChildAsteroids ( int PSNR )
    {
      ArrayList childAsteroids = new ArrayList(16);
      foreach (CAsteroid al_asteroid in Asteroids)
      {
        if (al_asteroid.Parentnummer == PSNR && al_asteroid.ParentInsertFrame == -1)
        {
          al_asteroid.ParentInsertFrame = Internal_counter;
          childAsteroids.Add(al_asteroid);
        }
      }
      return childAsteroids;
    }
    public int getNextDrehung ( int SNR )
    {
      return SNR;
    }
    public static void clearHitlist ()
    {
      HitList.Clear();
    }
    public static void updateHitlist ()
    {
      ArrayList collisionObjects = new ArrayList();
      ArrayList helpList = new ArrayList();
      CAsteroid collision_asteroid = null;
      CAsteroid hitlist_asteroid = null;
      CAsteroid asteroid = null;
      int my_counter = 0;
      max_shots = 4;
      int Drehung_collision_asteroid = 0;
      int Drehung_saucer = 0, Drehung_Asteroid1, Drehung_Asteroid2;
      int Drehung_saucer_collision_asteroid = 0;
      int saucer_Target = -1;
      int tmpSNR = 0, tmpPSNR = 0; ;
      string tmpStr = "";
      #region bereinige Saucer
      //!!!nicht verndern, da ich auf CAsteroid caste
      if (HitList.Count > 0)
      {
        saucer_Target = HitList.IndexOf(Saucer);
        if (saucer_Target > -1)
        {
          HitList.Remove(Saucer);
        }
      }
      //!!!nicht verndern, da ich auf CAsteroid caste
      #endregion
      #region bereinige Asteroiden
      if (HitList.Count > 0)
      {
        //TargetData.ConsoleWrite("{0:00} -> ", HitList.Count);
        my_counter = HitList.Count - 1;
        while (my_counter > -1)
        {
          hitlist_asteroid = HitList[my_counter] as CAsteroid;
          tmpSNR = hitlist_asteroid.Serialnummer;
          tmpPSNR = hitlist_asteroid.Parentnummer;
          if (!AsteroidsHash.ContainsKey(tmpSNR))
          {
            HitList.RemoveAt(my_counter);
            if (hitlist_asteroid.groesse != AsteroidGroesse.KLEIN)
            {
              helpList = getChildAsteroids(tmpPSNR);
              tmpStr = "";
              foreach (CAsteroid al_asteroid in helpList)
              {
                tmpStr += string.Format("[{0}:{1}] ", al_asteroid.Serialnummer, al_asteroid.groesse);
                if (HitList.IndexOf(al_asteroid) == -1)
                {
                  HitList.Add(al_asteroid);
                }
              }
              if (tmpStr.Length > 0) TargetData.ConsoleWriteLine("{2:00000}  [{0}] {1}", tmpSNR, tmpStr, Internal_counter);
            }
          }
          my_counter--;
        }
      }
      #endregion

      HitList.Clear();
      foreach (CAsteroid al_asteroid in Asteroids)
      {
        HitList.Add(al_asteroid);
      }
      collisionObjects = getCollisionObjects();
      collisionObjects.Sort(compareCollsionHit);
      for (int i = collisionObjects.Count - 1; i > -1; i--)
      {
        collision_asteroid = collisionObjects[i] as CAsteroid;
        if (HitList.IndexOf(collision_asteroid) > -1)
        {
          HitList.Remove(collision_asteroid);
        }
        HitList.Insert(0, collision_asteroid);
      }
      if (Saucer.Saucer_Present)
      {
        if (collision_asteroid != null)
        {
          Drehung_saucer = Saucer.HitDrehung - Ship.Drehung;
          Drehung_saucer = (int)(Drehung_saucer * 1.5);
          Drehung_collision_asteroid = collision_asteroid.HitDrehung - Ship.Drehung;
          Drehung_collision_asteroid = (int)(Drehung_collision_asteroid * 1.5);
          if (collisionObjects.Count == 1 && collision_asteroid.HitShip > Math.Abs(Drehung_collision_asteroid))
          {
            HitList.Insert(0, Saucer);
            //TargetData.ConsoleWriteLine("Saucer in Hitlist: 1x Collsion={0}", collision_asteroid.HitShip);
          }
        }
        else
        {
          HitList.Insert(0, Saucer);
        }
      }
      else
      {
        if (HitList.Count == 0)
        {
          AsteroidGroesse helpGroesse = AsteroidGroesse.UNKNOWN;
          Asteroids.Sort(compareAsteroidGroesse);
          helpList.Clear();
          for (int i = Asteroids.Count - 1; i > -1; i--)
          {
            asteroid = Asteroids[i] as CAsteroid;
            if (helpGroesse == AsteroidGroesse.UNKNOWN) helpGroesse = asteroid.groesse;
            if (asteroid.groesse == helpGroesse)
            {
              helpList.Add(asteroid);
            }
          }
          if (helpList.Count > 0)
          {
            helpList.Sort(compareAsteroidEntfernung);
            asteroid = helpList[0] as CAsteroid;
            TargetData.ConsoleWriteLine("Asteroid [{0}]({1}) hinzugefgt", asteroid.Serialnummer, asteroid.groesse);
            HitList.Add(asteroid);
          }
          //such' dir den schnsten aus
          //1. wer ist am Nchsten
        }
        else
        {
          if (collisionObjects.Count > 1)
          {
            return;
          }
          if (collisionObjects.Count == 1)
          {
            collision_asteroid = collisionObjects[0] as CAsteroid;
            if (collision_asteroid.groesse == AsteroidGroesse.KLEIN && collision_asteroid.HitShip < 50) return;
            if (collision_asteroid.groesse == AsteroidGroesse.MITTEL && collision_asteroid.HitShip < 60) return;
            if (collision_asteroid.groesse == AsteroidGroesse.GROSS && collision_asteroid.HitShip < 70) return;
            max_shots = 3;
          }
          HitList.Sort(compareAsteroidHitDrehung);
          if (HitList.Count >= 4) HitList.Sort(0, 4, compareAsteroidEntfernung);

          //asteroid = HitList[0] as CAsteroid;
          //tmpSNR = asteroid.Serialnummer;
          //int shot_counter = 0;
          //foreach (CShot al_shot in Shots)
          //{
          //  if (al_shot.Target_Serialnummer == tmpSNR)
          //  {
          //    shot_counter++;
          //  }
          //  if (shot_counter == 2 && asteroid.groesse == AsteroidGroesse.KLEIN)
          //  {
          //    HitList.Remove(asteroid);
          //    break;
          //  }
          //}
          //int last_index = 0;
          //for (int i = 0; i < HitList.Count; i++)
          //{
          //  asteroid = HitList[i] as CAsteroid;
          //  Drehung_Asteroid1 = Math.Abs(asteroid.HitDrehung - Ship.Drehung);
          //  if (Drehung_Asteroid1 > 8)
          //  {
          //    last_index = i;
          //  }
          //}
          //if (last_index > 1) HitList.Sort(0, last_index + 1, compareAsteroidEntfernung);
        }
      }
    }
  }
    #endregion
}
