using System;
//using System.Collections.Generic;
using System.Collections;
using System.Text;

namespace ct.Asteroid
{
  public class CompareAsteroidGroesse : IComparer
  {

    // Calls CaseInsensitiveComparer.Compare with the parameters reversed.
    int IComparer.Compare ( Object object_1, Object object_2 )
    {
      CAsteroid asteroid_1 = object_1 as CAsteroid;
      CAsteroid asteroid_2 = object_2 as CAsteroid;
      if (asteroid_1 == null || asteroid_2 == null)
      {
        return 0;
      }
      else
      {
        if (asteroid_1.groesse < asteroid_2.groesse) return -1;
        else if (asteroid_1.groesse == asteroid_2.groesse) return 0;
        else return 1;
      }
    }
  }
  public class CompareAsteroidEntfernung : IComparer
  {

    // Calls CaseInsensitiveComparer.Compare with the parameters reversed.
    int IComparer.Compare ( Object object_1, Object object_2 )
    {
      CAsteroid asteroid_1 = object_1 as CAsteroid;
      CAsteroid asteroid_2 = object_2 as CAsteroid;
      if (asteroid_1 == null || asteroid_2 == null)
      {
        return 0;
      }
      else
      {
        if (asteroid_1.ShipDistance < asteroid_2.ShipDistance) return -1;
        else if (asteroid_1.ShipDistance == asteroid_2.ShipDistance) return 0;
        else return 1;
      }
    }
  }
  public class CompareAsteroidHitDrehung : IComparer
  {
    // Calls CaseInsensitiveComparer.Compare with the parameters reversed.
    int IComparer.Compare ( Object object_1, Object object_2 )
    {
      CAsteroid asteroid_1 = object_1 as CAsteroid;
      CAsteroid asteroid_2 = object_2 as CAsteroid;
      CDrehung Drehung1, Drehung2;
      int int_drehung1, int_drehung2;
      if (asteroid_1 == null || asteroid_2 == null)
      {
        return 0;
      }
      else
      {
        Drehung1 = asteroid_1.HitDrehung;
        Drehung2 = asteroid_2.HitDrehung;
        int_drehung1 = Math.Abs( Drehung1 - CTargets.Ship.Drehung);
        int_drehung2 = Math.Abs( Drehung2 - CTargets.Ship.Drehung);
        if (int_drehung1 < int_drehung2) return -1;
        else if (int_drehung1 == int_drehung2) return 0;
        else return 1;
      }
    }
  }

  public class CompareCollisionHit : IComparer
  {

    // Calls CaseInsensitiveComparer.Compare with the parameters reversed.
    int IComparer.Compare ( Object object_1, Object object_2 )
    {
      CAsteroid asteroid_1 = object_1 as CAsteroid;
      CAsteroid asteroid_2 = object_2 as CAsteroid;
      if (asteroid_1 == null || asteroid_2 == null)
      {
        return 0;
      }
      else
      {
        if (asteroid_1.HitShip == asteroid_2.HitShip) return 0;
        else if (asteroid_1.HitShip < 0) return 1;
        else if (asteroid_2.HitShip < 0) return -1;
        else if (asteroid_1.HitShip < asteroid_2.HitShip) return -1;
        else return 1;
      }
    }
  }
  public class CompareAsteroidType : IComparer
  {

    // Calls CaseInsensitiveComparer.Compare with the parameters reversed.
    int IComparer.Compare ( Object object_1, Object object_2 )
    {
      CAsteroid asteroid_1 = object_1 as CAsteroid;
      CAsteroid asteroid_2 = object_2 as CAsteroid;
      if (asteroid_1 == null || asteroid_2 == null)
      {
        return 0;
      }
      else
      {
        if (asteroid_1.type < asteroid_2.type) return -1;
        else if (asteroid_1.type == asteroid_2.type) return 0;
        else return 1;
      }
    }
  }
}
