package asteroid.printer;

import java.io.PrintStream;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class Position extends APrinter {
	private Detect mDetect;
	private GameModel mModel;

	public Position( GameModel model, String file) {
		super( file);
		mModel = model;
		mDetect = new Detect( model, this);
	}

	public Position( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
		mDetect = new Detect( model, this);
	}

	public void forAsteroid( Asteroid ast) {
		switch (ast.getState()) {
			case AFlyable.STATE_VISIBLE:
				mOut.print( 'A');
				break;
			case AFlyable.STATE_EXPLOSION:
				mOut.print( 'E');
				break;
			case AFlyable.STATE_BLOCKED:
				mOut.print( '_');
				break;
			default:
				mOut.print( '.');
		}
	}

	public void forShip( Ship ship) {
		switch (ship.getState()) {
			case AFlyable.STATE_VISIBLE:
				mOut.print( 'S');
				break;
			case AFlyable.STATE_EXPLOSION:
				mOut.print( 'T');
				break;
			case AFlyable.STATE_JUMP:
				mOut.print( 'J');
				break;
			default:
				mOut.print( '.');
		}
	}

	public void forShot( Shot shot) {
		switch (shot.getState()) {
			case AFlyable.STATE_VISIBLE:
				mOut.print( shot.isShip() ? 'M' : 'P');
				break;
			default:
				mOut.print( '.');
		}
	}

	public void forUfo( Ufo ufo) {
		switch (ufo.getState()) {
			case AFlyable.STATE_VISIBLE:
				mOut.print( 'U');
				break;
			case AFlyable.STATE_EXPLOSION:
				mOut.print( 'X');
				break;
			default:
				mOut.print( '.');
		}
	}

	public void print() {
		mOut.savePos();
		mOut.print( "Frame ");
		mOut.print( GameModel.sFrame);
		mOut.fill( 12);
		mOut.print( mModel.getFireDirection());
		mOut.fill( 5);
		mOut.print( '|');
		mModel.forShip( this);
		mModel.forUfo( this);
		mOut.print( '|');
		mModel.forAllAsteroids( this);
		mOut.print( '|');
		mModel.forAllShots( this);
		mOut.print( '|');
//		mPrint.print( mModel.isError() ? "<--" : "   ");
		mDetect.print();
		mOut.println();
	}
}
