/*
 * Decompiled with CFR 0.152.
 */
package asteroid.ui;

import asteroid.Player;
import asteroid.SimpleLogging;
import asteroid.model.FlyInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;

public class TestView
extends JComponent {
    private static final long serialVersionUID = -8920459208626166274L;
    private static final String TEST = Player.HOME + "hits.txt";
    private static final int WIDTH = 640;
    private static final int HEIGHT = 480;
    private static final int ZOOM = 4;
    private static final double SHIP_SIZE = 5.0;
    private Vector mAsts = new Vector();
    private boolean mDrawShip;
    private boolean mDrawUfo;
    private Graphics mGraph;
    private FlyInfo mShip = new FlyInfo();
    private Vector mShots = new Vector();
    private FlyInfo mUfo = new FlyInfo();

    public TestView() {
        Dimension dimension = new Dimension(640, 480);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.mUfo.set(0, 0, 0, 0, 0);
        this.mShip.set(0, 0, 0, 0, 0);
        this.mAsts.clear();
        this.mShots.clear();
    }

    void drawArc(FlyInfo flyInfo, int n, int n2) {
        int n3 = TestView.getScreenX8(flyInfo.getX8() - (n *= 4));
        int n4 = TestView.getScreenX8(flyInfo.getX8() + n);
        int n5 = TestView.getScreenY8(flyInfo.getY8() - (n2 *= 4));
        int n6 = TestView.getScreenY8(flyInfo.getY8() + n2);
        this.mGraph.drawArc(n3, n6, n4 - n3, n5 - n6, 0, 360);
        this.mGraph.setColor(Color.GREEN);
        this.mGraph.drawArc(TestView.getScreenX8(flyInfo.getX8()), TestView.getScreenY8(flyInfo.getY8()), 3, 3, 0, 360);
    }

    void drawArc1(FlyInfo flyInfo, int n, int n2) {
        int n3 = TestView.getScreenX8(flyInfo.getX8() + flyInfo.getMoveX8() - (n *= 4));
        int n4 = TestView.getScreenX8(flyInfo.getX8() + flyInfo.getMoveX8() + n);
        int n5 = TestView.getScreenY8(flyInfo.getY8() + flyInfo.getMoveY8() - (n2 *= 4));
        int n6 = TestView.getScreenY8(flyInfo.getY8() + flyInfo.getMoveY8() + n2);
        this.mGraph.drawArc(n3, n6, n4 - n3, n5 - n6, 0, 360);
    }

    void drawAsteroid(FlyInfo flyInfo) {
        this.mGraph.setColor(Color.MAGENTA);
        switch (flyInfo.getZ()) {
            case 0: {
                this.drawArc(flyInfo, 160, 160);
                break;
            }
            case 15: {
                this.drawArc(flyInfo, 80, 80);
                break;
            }
            case 14: {
                this.drawArc(flyInfo, 32, 32);
            }
        }
    }

    void drawBorder(FlyInfo flyInfo, int n, int n2) {
        this.mGraph.setColor(Color.WHITE);
        int n3 = TestView.getScreenX8(flyInfo.getX8() - n);
        int n4 = TestView.getScreenX8(flyInfo.getX8() + n);
        int n5 = TestView.getScreenY8(flyInfo.getY8() - n2);
        int n6 = TestView.getScreenY8(flyInfo.getY8() + n2);
        this.mGraph.drawRect(n3, n6, n4 - n3, n5 - n6);
    }

    void drawBorder1(FlyInfo flyInfo, int n, int n2) {
        this.mGraph.setColor(Color.WHITE);
        int n3 = TestView.getScreenX8(flyInfo.getX8() - n);
        int n4 = TestView.getScreenX8(flyInfo.getX8() + n);
        int n5 = TestView.getScreenY8(flyInfo.getY8() - n2);
        int n6 = TestView.getScreenY8(flyInfo.getY8() + n2);
        this.mGraph.drawArc(n3, n6, n4 - n3, n5 - n6, 0, 360);
    }

    void drawShip(FlyInfo flyInfo) {
        double d = 0.0;
        int n = (int)Math.round(20.0 * Math.cos(d));
        int n2 = (int)Math.round(-20.0 * Math.sin(d));
        int n3 = TestView.getScreenX8(flyInfo.getX8());
        int n4 = TestView.getScreenY8(flyInfo.getY8());
        this.mGraph.setColor(Color.WHITE);
        this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 - n + n2, n4 - n2 - n);
        this.mGraph.drawLine(n3 - n + n2, n4 - n2 - n, n3 + n + n, n4 + n2 + n2);
        this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 + n + n, n4 + n2 + n2);
        this.drawBorder(flyInfo, 400, 400);
        this.drawBorder(flyInfo, 240, 240);
        this.drawBorder(flyInfo, 160, 160);
    }

    void drawShot(FlyInfo flyInfo) {
        this.mGraph.setColor(Color.GREEN);
        this.drawArc(flyInfo, 1, 1);
        this.drawVelocity(flyInfo);
    }

    void drawUfo(FlyInfo flyInfo) {
        int n = 0;
        int n2 = 0;
        switch (flyInfo.getZ()) {
            case 15: {
                n = 12;
                n2 = 5;
                this.drawBorder1(flyInfo, 400, 400);
                this.drawBorder1(flyInfo, 240, 240);
                this.drawBorder1(flyInfo, 160, 160);
                break;
            }
            case 14: {
                n = 6;
                n2 = 3;
                this.drawBorder1(flyInfo, 360, 360);
                this.drawBorder1(flyInfo, 200, 200);
                this.drawBorder1(flyInfo, 120, 120);
            }
        }
        this.mGraph.setColor(Color.RED);
        int n3 = TestView.getScreenX8(flyInfo.getX8());
        int n4 = TestView.getScreenY8(flyInfo.getY8());
        this.mGraph.drawLine(n3 - (n *= 4) + (n2 *= 4), n4 - n2, n3 + n - n2, n4 - n2);
        this.mGraph.drawLine(n3 - n, n4, n3 + n, n4);
        this.mGraph.drawLine(n3 - n + n2, n4 + n2, n3 + n - n2, n4 + n2);
        this.mGraph.drawLine(n3 - n, n4, n3 - n + n2, n4 + n2);
        this.mGraph.drawLine(n3 + n - n2, n4 + n2, n3 + n, n4);
        this.mGraph.drawLine(n3 - n, n4, n3 - n + (n2 <<= 1), n4 - n2);
        this.mGraph.drawLine(n3 - n + n2, n4 - n2, n3 + n - n2, n4 - n2);
        this.mGraph.drawLine(n3 + n - n2, n4 - n2, n3 + n, n4);
        this.drawVelocity(flyInfo);
    }

    void drawVelocity(FlyInfo flyInfo) {
        this.mGraph.setColor(Color.GRAY);
        int n = TestView.getScreenX8(flyInfo.getX8());
        int n2 = TestView.getScreenY8(flyInfo.getY8());
        int n3 = TestView.getScreenX8(flyInfo.getX8() + flyInfo.getMoveX8());
        int n4 = TestView.getScreenY8(flyInfo.getY8() + flyInfo.getMoveY8());
        this.mGraph.drawLine(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.mGraph = graphics;
        if (this.mDrawShip) {
            this.drawShip(this.mShip);
        }
        if (this.mDrawUfo) {
            this.drawUfo(this.mUfo);
        }
        Iterator iterator = this.mAsts.iterator();
        while (iterator.hasNext()) {
            this.drawAsteroid((FlyInfo)iterator.next());
        }
        iterator = this.mShots.iterator();
        while (iterator.hasNext()) {
            this.drawShot((FlyInfo)iterator.next());
        }
    }

    void parse(String string) {
        int n = 10000;
        int n2 = 10000;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        if (!"Frame".equals(stringTokenizer.nextToken())) {
            return;
        }
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":,");
            if (stringTokenizer2.countTokens() != 6) continue;
            String string3 = stringTokenizer2.nextToken();
            int n3 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            int n4 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            int n5 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            int n6 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            int n7 = Integer.parseInt(stringTokenizer2.nextToken().trim());
            if ("S".equals(string3) || "U".equals(string3) && n5 == 15) continue;
            if ("U".equals(string3) && n5 == 14) {
                n = n3;
                n2 = n4;
                this.mUfo.set(n3 - n, n4 - n2, n5, n6, n7);
                this.mDrawUfo = true;
                continue;
            }
            if (string3.startsWith("A") && n5 == 0 || string3.startsWith("A") && n5 == 15 || string3.startsWith("A") && n5 == 14 || !string3.startsWith("M")) continue;
            this.mShots.add(new FlyInfo(n3 - n, n4 - n2, n5, n6, n7));
        }
    }

    void parseFile() {
        try {
            File file = new File(TEST);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsoluteFile()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(" U") < 0 || string.indexOf(" M") < 0) continue;
                this.parse(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            SimpleLogging.addException(exception);
        }
    }

    private static int getScreenX8(int n) {
        return 320 + (2560 * n >> 13);
    }

    private static int getScreenY8(int n) {
        return 240 - (2560 * n >> 13);
    }
}

