/*
 * Decompiled with CFR 0.152.
 */
package asteroid.ui;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.ICompute;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;

class ListView
extends JComponent
implements ICompute {
    private static final long serialVersionUID = -4448378120664860752L;
    private static final int WIDTH = 640;
    private static final int HEIGHT = 480;
    private static final int FONT_SIZE = 9;
    private static final int WIDTH_CHAR = 9;
    private static final int WIDTH_SHORT = 18;
    private static final int WIDTH_INT = 36;
    private static final int WIDTH_DOUBLE = 45;
    private static final int WIDTH_ARRAY = 153;
    private static final int POS_X = 40;
    private static final int POS_Y = 76;
    private static final int POS_Z = 112;
    private static final int POS_MOVE_X = 148;
    private static final int POS_MOVE_Y = 184;
    private static final int POS_ANGLE = 220;
    private static final int POS_VELOCITY = 265;
    private static final int POS_SHIP_DX = 310;
    private static final int POS_SHIP_DY = 346;
    private static final int POS_STEPS_X = 382;
    private static final int POS_STEPS_Y = 535;
    private static final boolean DRAW_STEPS = false;
    private static final Color TEXT_COLOR = Color.WHITE;
    private FontMetrics mFM;
    private Font mFont = new Font("Monospace", 0, 9);
    private Graphics mGraph;
    private int mH;
    private GameModel mModel;
    private int mY;

    public ListView(GameModel gameModel) {
        this.mModel = gameModel;
        Dimension dimension = new Dimension(640, 480);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    void drawArrayLeft(int[] nArray, int n) {
        this.mGraph.drawString("[", n += 9, this.mY);
        for (int i = 0; i < 8; ++i) {
            this.drawShortLeft(nArray[i], n += 18);
        }
        this.mGraph.drawString("]", n, this.mY);
    }

    void drawDoubleLeft(double d, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((double)Math.round(100.0 * d) / 100.0);
        int n2 = stringBuffer.indexOf(".") + 3;
        while (stringBuffer.length() < n2) {
            stringBuffer.append('0');
        }
        String string = stringBuffer.toString();
        this.mGraph.drawString(string, n + 45 - this.mFM.stringWidth(string), this.mY);
    }

    void drawFlyable(AFlyable aFlyable) {
        this.drawIntegerLeft(aFlyable.getX8() >> 3, 40);
        this.drawIntegerLeft(aFlyable.getY8() >> 3, 76);
        this.drawIntegerLeft(aFlyable.getZ(), 112);
        this.drawIntegerLeft(aFlyable.getMoveX8(), 148);
        this.drawIntegerLeft(aFlyable.getMoveY8(), 184);
        this.drawDoubleLeft(Angle.toRoute(aFlyable.getBetha()), 220);
        this.drawDoubleLeft(aFlyable.getVelocity8() / 8.0, 265);
    }

    void drawHead() {
        this.mGraph.drawString("Objekt", 0, this.mY);
        this.drawStringLeft("PosX", 40, 36);
        this.drawStringLeft("PosY", 76, 36);
        this.drawStringLeft("Type", 112, 36);
        this.drawStringLeft("MoveX", 148, 36);
        this.drawStringLeft("MoveY", 184, 36);
        this.drawStringLeft("Winkel", 220, 45);
        this.drawStringLeft("Speed", 265, 45);
        this.drawStringLeft("DX", 310, 36);
        this.drawStringLeft("DY", 346, 36);
    }

    void drawIntegerLeft(int n, int n2) {
        String string = Integer.toString(n);
        this.mGraph.drawString(string, n2 + 36 - this.mFM.stringWidth(string), this.mY);
    }

    void drawShortLeft(int n, int n2) {
        String string = Integer.toString(n);
        this.mGraph.drawString(string, n2 - this.mFM.stringWidth(string), this.mY);
    }

    void drawStringCenter(String string, int n, int n2) {
        this.mGraph.drawString(string, n + (n2 - this.mFM.stringWidth(string)) / 2, this.mY);
    }

    void drawStringLeft(String string, int n, int n2) {
        this.mGraph.drawString(string, n + n2 - this.mFM.stringWidth(string), this.mY);
    }

    public void forAsteroid(Asteroid asteroid) {
        this.mY += this.mH;
        this.mGraph.drawString((asteroid.isExplosion() ? "Expl " : "Ast ") + asteroid.getIndex(), 0, this.mY);
        if (asteroid.isVisible() || asteroid.isExplosion()) {
            this.drawFlyable(asteroid);
        }
    }

    public void forAsteroid(FlyDetect flyDetect) {
    }

    public void forShip(Ship ship) {
        this.mY += this.mH;
        this.mGraph.drawString("Ship", 0, this.mY);
        if (ship.isVisible()) {
            this.drawFlyable(ship);
            this.drawIntegerLeft(ship.getDx(), 310);
            this.drawIntegerLeft(ship.getDy(), 346);
        }
    }

    public void forShot(FlyDetect flyDetect) {
    }

    public void forShot(Shot shot) {
        this.mY += this.mH;
        this.mGraph.drawString("Shot " + shot.getIndex(), 0, this.mY);
        if (shot.isVisible()) {
            this.drawFlyable(shot);
            if (!shot.isShip()) {
                this.mGraph.drawString("Feind", 346, this.mY);
            }
        }
    }

    public void forUfo(Ufo ufo) {
        this.mY += this.mH;
        this.mGraph.drawString(ufo.isExplosion() ? "Expl" : "Ufo", 0, this.mY);
        if (ufo.isVisible() || ufo.isExplosion()) {
            this.drawFlyable(ufo);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.mFont);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(TEXT_COLOR);
        this.mGraph = graphics;
        this.mFM = graphics.getFontMetrics(this.mFont);
        this.mY = this.mH = this.mFM.getHeight();
        this.drawHead();
        this.mY += this.mH;
        this.mModel.forShip(this);
        this.mModel.forUfo(this);
        this.mY += this.mH;
        this.mModel.forAllAsteroids(this);
        this.mY += this.mH;
        this.mModel.forAllShots(this);
    }
}

