/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.TargetInfo;
import asteroid.strategy.measure.AMeasure;

public class RotTime
extends AMeasure {
    private double mFakt;
    private Ship mShip;

    public RotTime(Ship ship, double d) {
        this.mShip = ship;
        this.mFakt = d;
    }

    protected void measure(AEnemy aEnemy) {
        TargetInfo targetInfo = aEnemy.getInfo();
        targetInfo.calculate(aEnemy, this.mShip, Angle.sDirection, GameModel.sFrame, GameModel.sFrame);
        int n = targetInfo.getRot() + 16 * targetInfo.getWait();
        aEnemy.mWeight += this.mFakt * (double)n;
        if (targetInfo.getRot() == 0) {
            aEnemy.mWeight -= 90.0;
        }
    }

    protected void print(AEnemy aEnemy, PrintWriterFormat printWriterFormat) {
        TargetInfo targetInfo = aEnemy.getInfo();
        printWriterFormat.print(targetInfo.getRot());
        printWriterFormat.print(':');
        printWriterFormat.print(targetInfo.getWait());
        printWriterFormat.fill(10);
    }
}

