/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy;

import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.strategy.AStrategie;
import asteroid.strategy.Gen;
import asteroid.strategy.Genom;

public class Permutation
extends AStrategie {
    private Genom mBest;
    private int mEndFrame;
    private int mFirst;
    private int mLast;
    private int mMaxTimeWait = Angle.sForward << 2;
    private Genom mPerm;

    public Permutation(GameModel gameModel) {
        super(gameModel);
        this.mBest = new Genom(gameModel);
        this.mPerm = new Genom(gameModel);
    }

    public void cleanup() {
        this.mMaxTimeWait = Angle.sForward << 2;
        this.mModel.forUfo(this);
        this.mModel.forAllAsteroids(this);
        this.mModel.forAllShots(this);
        for (int i = 0; i < this.mFirst; ++i) {
            Gen gen = this.mBest.get(i);
            if (gen.mShot == null && gen.mTimeOut > 0) {
                --gen.mTimeOut;
            }
            if (gen.mTimeOut > 0) continue;
            int n = gen.mEnemy.getID();
            this.mBest.moveEnemy(this.mLast - 1, n);
            this.mPerm.moveEnemy(this.mLast - 1, n);
            --this.mFirst;
        }
        this.mBest.calculate(this.mFirst, this.mLast);
        this.mEndFrame = this.mBest.getEndFrame();
    }

    public void forAsteroid(Asteroid asteroid) {
        this.forEnemy(asteroid);
    }

    private void forEnemy(AEnemy aEnemy) {
        if (aEnemy.getVanish() > 0) {
            int n = aEnemy.getID();
            --this.mLast;
            this.mBest.moveEnemy(this.mLast, n);
            this.mPerm.moveEnemy(this.mLast, n);
        }
        if (aEnemy.getCreate() > 0) {
            this.mBest.setEnemy(this.mLast, aEnemy);
            this.mPerm.setEnemy(this.mLast, aEnemy);
            ++this.mLast;
        }
    }

    public void forShot(Shot shot) {
        if (shot.isShip()) {
            Gen gen;
            int n;
            if (shot.getVanish() > 0 || shot.isHidden()) {
                for (n = 0; n < this.mFirst; ++n) {
                    gen = this.mBest.get(n);
                    if (gen.mShot != shot) continue;
                    int n2 = gen.mEnemy.getID();
                    this.mBest.moveEnemy(this.mLast - 1, n2);
                    this.mPerm.moveEnemy(this.mLast - 1, n2);
                    break;
                }
            }
            if (shot.getCreate() > 0) {
                for (n = 0; n < this.mFirst; ++n) {
                    gen = this.mBest.get(n);
                    if (gen.mShot != null) continue;
                    gen.mShot = shot;
                    break;
                }
            }
        }
    }

    public void forUfo(Ufo ufo) {
        this.forEnemy(ufo);
    }

    public int getKey() {
        if (this.mFirst >= this.mLast) {
            return 0;
        }
        Gen gen = this.mBest.get(this.mFirst);
        int n = gen.mInfo.getRot(gen.mEnemy);
        if (n == 0 && gen.mInfo.getWait() == 0) {
            n |= 2;
            gen.mTimeOut = this.mMaxTimeWait;
            this.mPerm.moveEnemy(this.mLast - 1, gen.mEnemy.getID(), this.mFirst);
            ++this.mFirst;
            if (this.mFirst < this.mLast) {
                Gen gen2 = this.mBest.get(this.mFirst);
                n |= gen2.mInfo.getRot(gen2.mEnemy);
            }
        }
        return n;
    }

    public void refresh() {
        this.mPerm.next(this.mFirst, this.mLast);
        this.mPerm.calculate(this.mFirst, this.mLast);
        int n = this.mPerm.getEndFrame();
        if (n < this.mEndFrame) {
            this.mBest.update(this.mFirst, this.mLast, this.mPerm);
            this.mEndFrame = n;
        }
    }
}

