/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import java.io.PrintStream;

public class Detect
extends APrinter {
    private GameModel mModel;

    public Detect(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public Detect(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
    }

    public Detect(GameModel gameModel, APrinter aPrinter) {
        super(aPrinter);
        this.mModel = gameModel;
    }

    public void forAsteroid(FlyDetect flyDetect) {
        switch (flyDetect.getType()) {
            case 2291: {
                this.forDetect("A1", flyDetect);
                break;
            }
            case 2303: {
                this.forDetect("A2", flyDetect);
                break;
            }
            case 2317: {
                this.forDetect("A3", flyDetect);
                break;
            }
            case 2330: {
                this.forDetect("A4", flyDetect);
                break;
            }
            case 2256: {
                this.forDetect("E0", flyDetect);
                break;
            }
            case 2229: {
                this.forDetect("E1", flyDetect);
                break;
            }
            case 2198: {
                this.forDetect("E2", flyDetect);
                break;
            }
            case 2176: {
                this.forDetect("E3", flyDetect);
            }
        }
    }

    private void forDetect(String string, FlyDetect flyDetect) {
        this.mOut.savePos();
        this.mOut.print(string);
        this.mOut.print(':');
        this.mOut.printPos(flyDetect.getX8());
        this.mOut.print(',');
        this.mOut.printPos(flyDetect.getY8());
        this.mOut.print(',');
        this.mOut.print(flyDetect.getZ());
        this.mOut.fill(20);
    }

    private void forFlyable(String string, AFlyable aFlyable) {
        this.mOut.savePos();
        this.mOut.print(string);
        this.mOut.print(':');
        if (aFlyable.isVisible() || aFlyable.isExplosion()) {
            this.mOut.printPos(aFlyable.getX8());
            this.mOut.print(',');
            this.mOut.printPos(aFlyable.getY8());
            this.mOut.print(',');
            this.mOut.print(aFlyable.getZ());
        }
        this.mOut.fill(20);
    }

    public void forShip(Ship ship) {
        this.forFlyable(" S", ship);
    }

    public void forShot(FlyDetect flyDetect) {
        this.forDetect(" M", flyDetect);
    }

    public void forUfo(Ufo ufo) {
        this.forFlyable(" U", ufo);
    }

    public void print() {
        this.mOut.print("    ");
        this.mModel.forShip(this);
        this.mModel.forUfo(this);
        this.mModel.forAllDetectAsteroids(this);
        this.mModel.forAllDetectShots(this);
    }
}

