/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.SimpleLogging;
import asteroid.model.AEnemy;
import asteroid.model.FlyDetect;
import asteroid.model.ICompute;
import asteroid.model.Ship;

public class Ufo
extends AEnemy {
    public static final int UFO_ID = 27;
    public static final int MAX_FIRE = 1;
    private boolean mMissing;
    private Ship mShip;

    Ufo(Ship ship) {
        this.mShip = ship;
    }

    void addUfo(int n, int n2, int n3) {
        n <<= 3;
        n2 <<= 3;
        switch (this.mState) {
            case 0: {
                this.mCreate = 1;
                this.initFire();
                this.initStep(0, 0);
                break;
            }
            case 1: {
                this.addStep8(n, n2);
                break;
            }
            default: {
                SimpleLogging.addLog("illegal Ufo state");
            }
        }
        this.setPos8(n, n2, n3);
        this.mType = 2345;
        this.mState = 1;
        this.mMissing = false;
    }

    void detect() {
        switch (this.mState) {
            case 1: {
                if (this.mMissing) {
                    this.mState = 0;
                    break;
                }
                this.init(this.mShip);
            }
            case 0: 
            case 2: {
                break;
            }
            default: {
                this.mType = 2345;
                SimpleLogging.addLog("illegal Ufo state");
            }
        }
    }

    int detExplosion(FlyDetect flyDetect) {
        int n = 0;
        switch (this.mState) {
            case 0: {
                break;
            }
            case 1: {
                if (flyDetect == null || !flyDetect.mExplosion || this.mX8 != flyDetect.mX8 || this.mY8 != flyDetect.mY8) break;
                this.mState = 2;
                this.mVanish = 1;
                this.mType = flyDetect.mType;
                n = 1;
                break;
            }
            case 2: {
                if (flyDetect != null && flyDetect.mExplosion && this.mX8 == flyDetect.mX8 && this.mY8 == flyDetect.mY8) {
                    this.mType = flyDetect.mType;
                    n = 1;
                } else {
                    this.mState = 0;
                    this.mType = 2345;
                }
                this.mVanish = 0;
                break;
            }
            default: {
                this.mState = 0;
                this.mType = 2345;
                this.mVanish = 0;
                SimpleLogging.addLog("illegal Ufo state");
            }
        }
        return n;
    }

    void doIt(ICompute iCompute) {
        iCompute.forUfo(this);
    }

    public boolean isFired() {
        return this.mFire < 1;
    }

    public int getID() {
        return 27;
    }

    public String getIdent() {
        return "U";
    }

    public void initFire() {
        this.mFire = 1;
    }

    void prepare() {
        this.mMissing = true;
        this.mVanish = 0;
    }

    public int getScore() {
        switch (this.mZ) {
            case 15: {
                return 200;
            }
            case 14: {
                return 1000;
            }
        }
        return 0;
    }

    public int size() {
        switch (this.mZ) {
            case 15: {
                return 96;
            }
            case 14: {
                return 64;
            }
        }
        return 0;
    }

    public int sizeX() {
        switch (this.mZ) {
            case 15: {
                return 160;
            }
            case 14: {
                return 80;
            }
        }
        return 0;
    }

    public int sizeY() {
        switch (this.mZ) {
            case 15: {
                return 96;
            }
            case 14: {
                return 64;
            }
        }
        return 0;
    }
}

