/*
 * Decompiled with CFR 0.152.
 */
package asteroid;

import asteroid.model.GameModel;
import asteroid.printer.APrinter;
import asteroid.printer.Shortly;
import asteroid.statistic.GameValues;
import asteroid.statistic.LevelValues;
import asteroid.strategy.AStrategie;
import asteroid.strategy.Priority;
import asteroid.udp.AHandler;
import asteroid.udp.NetHandler;
import asteroid.ui.MainFrame;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class Player {
    private static final int TEST_LATENZ = 0;
    private static final int READ_WRITE = 0;
    public static final boolean DEBUG = true;
    public static final String HOME;
    public static final String PROTOCOL;
    public static final String POSITION;
    public static final int HOST_LOCAL = 0;
    public static final int HOST_GAME = 1;
    public static final int HOST_HEISE = 2;
    public static int sHost;
    private MainFrame mFrame;
    private AStrategie mGenetic;
    private LevelValues mLevel = new LevelValues();
    private GameModel mModel;
    private APrinter mPrint;
    private AHandler mSrc;
    private AStrategie mStrategy;
    private GameValues mValues = new GameValues();

    private Player(AHandler aHandler) {
        this.mSrc = aHandler;
        this.mModel = new GameModel(aHandler);
        this.mPrint = new Shortly(this.mModel, POSITION);
        this.mStrategy = new Priority(this.mModel);
    }

    private void createFrame() {
        this.mFrame = new MainFrame(this.mModel, this.mValues);
        this.mFrame.pack();
        this.mFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length > 0) {
            string = stringArray[0];
        } else {
            System.out.println("Aufruf: asteroid <IP-Adresse>");
            switch (sHost) {
                default: {
                    string = "127.0.0.1";
                    break;
                }
                case 1: {
                    string = "192.168.0.152";
                    break;
                }
                case 2: {
                    string = "asteroids.heise.de";
                }
            }
        }
        AHandler aHandler = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            aHandler = new NetHandler(inetAddress, 0);
            Player player = new Player(aHandler);
            player.createFrame();
            player.play();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (aHandler != null) {
                aHandler.close();
            }
        }
    }

    private void play() {
        switch (sHost) {
            case 0: 
            case 1: {
                this.mModel.setRepeat(false);
                this.mModel.setTopList(false);
                break;
            }
            case 2: {
                this.mModel.setRepeat(true);
                this.mModel.setTopList(true);
            }
        }
        this.mSrc.start();
        this.mValues.reset();
        this.mModel.addKey(0);
        if (this.mStrategy != null) {
            this.runStrategy(this.mStrategy);
        } else {
            this.runGenetic(this.mGenetic);
        }
    }

    private void printData() {
        if (this.mPrint != null) {
            this.mPrint.print();
        }
    }

    private void runGenetic(AStrategie aStrategie) {
        while (this.mSrc.isAlive()) {
            ByteBuffer byteBuffer = this.mSrc.getNext(!this.mModel.isPlayTime());
            if (byteBuffer != null) {
                this.updateData(byteBuffer);
                aStrategie.cleanup();
                this.printData();
                this.mModel.updateKey(aStrategie);
                this.updateKey();
            }
            if (!this.mModel.isPlayTime()) continue;
            aStrategie.refresh();
        }
    }

    private void runStrategy(AStrategie aStrategie) {
        while (this.mSrc.isAlive()) {
            ByteBuffer byteBuffer = this.mSrc.getNext(true);
            while (byteBuffer != null) {
                this.updateData(byteBuffer);
                aStrategie.cleanup();
                this.printData();
                byteBuffer = this.mSrc.getNext(false);
            }
            if (this.mModel.isPlayTime()) {
                aStrategie.refresh();
            }
            this.mModel.updateKey(aStrategie);
            this.updateKey();
        }
    }

    private void updateData(ByteBuffer byteBuffer) {
        this.mValues.init();
        this.mModel.interpret(byteBuffer);
        this.mLevel.update(this.mModel);
    }

    private void updateKey() {
        this.mValues.update(this.mModel);
        if (this.mFrame != null) {
            this.mFrame.refresh();
        }
    }

    static {
        sHost = 0;
        String string = System.getProperty("os.name");
        HOME = string.regionMatches(true, 0, "win32", 0, 3) ? "D:\\Tools\\ct\\output\\" : System.getProperty("user.home") + "/tar/ct/save/";
        PROTOCOL = HOME + "self-2008-06-30-15-14-21";
        POSITION = HOME + "position.txt";
    }
}

